/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.devices;

import com.android.sdklib.AndroidApiLevel;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.idea.logcat.devices.DeviceKt;
import com.android.tools.idea.ui.screenshot.ScreenshotParameters;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 %2\u00020\u0001:\u0004#$%&B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010 \u001a\u00020!H&J\u001c\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018R\u0012\u0010\u001f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000e\u0082\u0001\u0002'(\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/logcat/devices/Device;", "", "<init>", "()V", "deviceId", "", "getDeviceId", "()Ljava/lang/String;", "name", "getName", "serialNumber", "getSerialNumber", "isOnline", "", "()Z", "release", "getRelease", "apiLevel", "Lcom/android/sdklib/AndroidApiLevel;", "getApiLevel", "()Lcom/android/sdklib/AndroidApiLevel;", "featureLevel", "", "getFeatureLevel", "()I", "type", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "sdk", "getSdk", "isEmulator", "getScreenshotParameters", "Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters;", "copy", "PhysicalDevice", "EmulatorDevice", "Companion", "DeviceSerializer", "Lcom/android/tools/idea/logcat/devices/Device$EmulatorDevice;", "Lcom/android/tools/idea/logcat/devices/Device$PhysicalDevice;", "intellij.android.logcat"})
public abstract sealed class Device {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PROPERTY_PHYSICAL_DEVICE = "physicalDevice";
    @NotNull
    private static final String PROPERTY_EMULATOR_DEVICE = "emulatorDevice";

    private Device() {
    }

    @NotNull
    public abstract String getDeviceId();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getSerialNumber();

    public abstract boolean isOnline();

    @NotNull
    public abstract String getRelease();

    @NotNull
    public abstract AndroidApiLevel getApiLevel();

    public abstract int getFeatureLevel();

    @Nullable
    public abstract DeviceType getType();

    public final int getSdk() {
        return this.getApiLevel().getMajorVersion();
    }

    public abstract boolean isEmulator();

    @NotNull
    public abstract ScreenshotParameters getScreenshotParameters();

    @NotNull
    public abstract Device copy(boolean var1, @NotNull AndroidApiLevel var2);

    public static /* synthetic */ Device copy$default(Device device2, boolean bl, AndroidApiLevel androidApiLevel, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            bl = device2.isOnline();
        }
        if ((n & 2) != 0) {
            androidApiLevel = device2.getApiLevel();
        }
        return device2.copy(bl, androidApiLevel);
    }

    public /* synthetic */ Device(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012JB\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/logcat/devices/Device$Companion;", "", "<init>", "()V", "PROPERTY_PHYSICAL_DEVICE", "", "PROPERTY_EMULATOR_DEVICE", "createPhysical", "Lcom/android/tools/idea/logcat/devices/Device;", "serialNumber", "isOnline", "", "release", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "manufacturer", "model", "type", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "createEmulator", "avdName", "avdPath", "intellij.android.logcat"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Device createPhysical(@NotNull String serialNumber, boolean isOnline, @NotNull String release, @NotNull AndroidVersion androidVersion, @NotNull String manufacturer, @NotNull String model, @Nullable DeviceType type) {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
            Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            String string = DeviceKt.access$normalizeVersion(release);
            AndroidApiLevel androidApiLevel = androidVersion.getAndroidApiLevel();
            Intrinsics.checkNotNullExpressionValue((Object)androidApiLevel, (String)"getAndroidApiLevel(...)");
            int n = androidVersion.getFeatureLevel();
            DeviceType deviceType = type;
            if (deviceType == null) {
                deviceType = DeviceType.HANDHELD;
            }
            return new PhysicalDevice(serialNumber, isOnline, string, androidApiLevel, n, manufacturer, model, deviceType);
        }

        public static /* synthetic */ Device createPhysical$default(Companion companion, String string, boolean bl, String string2, AndroidVersion androidVersion, String string3, String string4, DeviceType deviceType, int n, Object object) {
            if ((n & 0x40) != 0) {
                deviceType = null;
            }
            return companion.createPhysical(string, bl, string2, androidVersion, string3, string4, deviceType);
        }

        @NotNull
        public final Device createEmulator(@NotNull String serialNumber, boolean isOnline, @NotNull String release, @NotNull AndroidVersion androidVersion, @NotNull String avdName, @NotNull String avdPath, @Nullable DeviceType type) {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
            Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
            Intrinsics.checkNotNullParameter((Object)avdPath, (String)"avdPath");
            String string = DeviceKt.access$normalizeVersion(release);
            AndroidApiLevel androidApiLevel = androidVersion.getAndroidApiLevel();
            Intrinsics.checkNotNullExpressionValue((Object)androidApiLevel, (String)"getAndroidApiLevel(...)");
            int n = androidVersion.getFeatureLevel();
            DeviceType deviceType = type;
            if (deviceType == null) {
                deviceType = DeviceType.HANDHELD;
            }
            return new EmulatorDevice(serialNumber, isOnline, string, androidApiLevel, n, avdName, avdPath, deviceType);
        }

        public static /* synthetic */ Device createEmulator$default(Companion companion, String string, boolean bl, String string2, AndroidVersion androidVersion, String string3, String string4, DeviceType deviceType, int n, Object object) {
            if ((n & 0x40) != 0) {
                deviceType = null;
            }
            return companion.createEmulator(string, bl, string2, androidVersion, string3, string4, deviceType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/logcat/devices/Device$DeviceSerializer;", "Lcom/google/gson/JsonSerializer;", "Lcom/android/tools/idea/logcat/devices/Device;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "type", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "element", "Lcom/google/gson/JsonDeserializationContext;", "intellij.android.logcat"})
    public static final class DeviceSerializer
    implements JsonSerializer<Device>,
    JsonDeserializer<Device> {
        @NotNull
        public JsonElement serialize(@Nullable Device src, @NotNull Type type, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject obj = new JsonObject();
            JsonElement jsonTree = new Gson().toJsonTree((Object)src);
            Device device2 = src;
            if (device2 instanceof PhysicalDevice) {
                obj.add(Device.PROPERTY_PHYSICAL_DEVICE, jsonTree);
            } else if (device2 instanceof EmulatorDevice) {
                obj.add(Device.PROPERTY_EMULATOR_DEVICE, jsonTree);
            } else if (device2 != null) {
                throw new NoWhenBranchMatchedException();
            }
            return (JsonElement)obj;
        }

        @Nullable
        public Device deserialize(@NotNull JsonElement element, @NotNull Type type, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject obj = element.getAsJsonObject();
            Gson gson2 = new Gson();
            return obj.has(Device.PROPERTY_PHYSICAL_DEVICE) ? (Device)gson2.fromJson(obj.get(Device.PROPERTY_PHYSICAL_DEVICE), PhysicalDevice.class) : (obj.has(Device.PROPERTY_EMULATOR_DEVICE) ? (Device)gson2.fromJson(obj.get(Device.PROPERTY_EMULATOR_DEVICE), EmulatorDevice.class) : null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\nH\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u000eH\u00c6\u0003JY\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u00020\nH\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0014\u0010 \u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012\u00a8\u00062"}, d2={"Lcom/android/tools/idea/logcat/devices/Device$EmulatorDevice;", "Lcom/android/tools/idea/logcat/devices/Device;", "serialNumber", "", "isOnline", "", "release", "apiLevel", "Lcom/android/sdklib/AndroidApiLevel;", "featureLevel", "", "avdName", "avdPath", "type", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Lcom/android/sdklib/AndroidApiLevel;ILjava/lang/String;Ljava/lang/String;Lcom/android/sdklib/deviceprovisioner/DeviceType;)V", "getSerialNumber", "()Ljava/lang/String;", "()Z", "getRelease", "getApiLevel", "()Lcom/android/sdklib/AndroidApiLevel;", "getFeatureLevel", "()I", "getAvdName", "getAvdPath", "getType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "isEmulator", "deviceId", "getDeviceId", "name", "getName", "getScreenshotParameters", "Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters;", "copy", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "equals", "other", "", "hashCode", "toString", "intellij.android.logcat"})
    public static final class EmulatorDevice
    extends Device {
        @NotNull
        private final String serialNumber;
        private final boolean isOnline;
        @NotNull
        private final String release;
        @NotNull
        private final AndroidApiLevel apiLevel;
        private final int featureLevel;
        @NotNull
        private final String avdName;
        @NotNull
        private final String avdPath;
        @NotNull
        private final DeviceType type;

        public EmulatorDevice(@NotNull String serialNumber, boolean isOnline, @NotNull String release, @NotNull AndroidApiLevel apiLevel, int featureLevel, @NotNull String avdName, @NotNull String avdPath, @NotNull DeviceType type) {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
            Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
            Intrinsics.checkNotNullParameter((Object)avdPath, (String)"avdPath");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(null);
            this.serialNumber = serialNumber;
            this.isOnline = isOnline;
            this.release = release;
            this.apiLevel = apiLevel;
            this.featureLevel = featureLevel;
            this.avdName = avdName;
            this.avdPath = avdPath;
            this.type = type;
        }

        @Override
        @NotNull
        public String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public boolean isOnline() {
            return this.isOnline;
        }

        @Override
        @NotNull
        public String getRelease() {
            return this.release;
        }

        @Override
        @NotNull
        public AndroidApiLevel getApiLevel() {
            return this.apiLevel;
        }

        @Override
        public int getFeatureLevel() {
            return this.featureLevel;
        }

        @NotNull
        public final String getAvdName() {
            return this.avdName;
        }

        @NotNull
        public final String getAvdPath() {
            return this.avdPath;
        }

        @Override
        @NotNull
        public DeviceType getType() {
            return this.type;
        }

        @Override
        public boolean isEmulator() {
            return true;
        }

        @Override
        @NotNull
        public String getDeviceId() {
            return this.avdPath;
        }

        @Override
        @NotNull
        public String getName() {
            return this.avdName;
        }

        @Override
        @NotNull
        public ScreenshotParameters getScreenshotParameters() {
            String string = this.getSerialNumber();
            DeviceType deviceType = this.getType();
            Path path = Path.of(this.avdPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return new ScreenshotParameters(string, deviceType, path, null, 8, null);
        }

        @Override
        @NotNull
        public EmulatorDevice copy(boolean isOnline, @NotNull AndroidApiLevel apiLevel) {
            Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
            return new EmulatorDevice(this.getSerialNumber(), isOnline, this.getRelease(), apiLevel, this.getFeatureLevel(), this.avdName, this.avdPath, this.getType());
        }

        @NotNull
        public final String component1() {
            return this.serialNumber;
        }

        public final boolean component2() {
            return this.isOnline;
        }

        @NotNull
        public final String component3() {
            return this.release;
        }

        @NotNull
        public final AndroidApiLevel component4() {
            return this.apiLevel;
        }

        public final int component5() {
            return this.featureLevel;
        }

        @NotNull
        public final String component6() {
            return this.avdName;
        }

        @NotNull
        public final String component7() {
            return this.avdPath;
        }

        @NotNull
        public final DeviceType component8() {
            return this.type;
        }

        @NotNull
        public final EmulatorDevice copy(@NotNull String serialNumber, boolean isOnline, @NotNull String release, @NotNull AndroidApiLevel apiLevel, int featureLevel, @NotNull String avdName, @NotNull String avdPath, @NotNull DeviceType type) {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
            Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
            Intrinsics.checkNotNullParameter((Object)avdPath, (String)"avdPath");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new EmulatorDevice(serialNumber, isOnline, release, apiLevel, featureLevel, avdName, avdPath, type);
        }

        public static /* synthetic */ EmulatorDevice copy$default(EmulatorDevice emulatorDevice, String string, boolean bl, String string2, AndroidApiLevel androidApiLevel, int n, String string3, String string4, DeviceType deviceType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = emulatorDevice.serialNumber;
            }
            if ((n2 & 2) != 0) {
                bl = emulatorDevice.isOnline;
            }
            if ((n2 & 4) != 0) {
                string2 = emulatorDevice.release;
            }
            if ((n2 & 8) != 0) {
                androidApiLevel = emulatorDevice.apiLevel;
            }
            if ((n2 & 0x10) != 0) {
                n = emulatorDevice.featureLevel;
            }
            if ((n2 & 0x20) != 0) {
                string3 = emulatorDevice.avdName;
            }
            if ((n2 & 0x40) != 0) {
                string4 = emulatorDevice.avdPath;
            }
            if ((n2 & 0x80) != 0) {
                deviceType = emulatorDevice.type;
            }
            return emulatorDevice.copy(string, bl, string2, androidApiLevel, n, string3, string4, deviceType);
        }

        @NotNull
        public String toString() {
            return "EmulatorDevice(serialNumber=" + this.serialNumber + ", isOnline=" + this.isOnline + ", release=" + this.release + ", apiLevel=" + this.apiLevel + ", featureLevel=" + this.featureLevel + ", avdName=" + this.avdName + ", avdPath=" + this.avdPath + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.serialNumber.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isOnline);
            result2 = result2 * 31 + this.release.hashCode();
            result2 = result2 * 31 + this.apiLevel.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.featureLevel);
            result2 = result2 * 31 + this.avdName.hashCode();
            result2 = result2 * 31 + this.avdPath.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmulatorDevice)) {
                return false;
            }
            EmulatorDevice emulatorDevice = (EmulatorDevice)other;
            if (!Intrinsics.areEqual((Object)this.serialNumber, (Object)emulatorDevice.serialNumber)) {
                return false;
            }
            if (this.isOnline != emulatorDevice.isOnline) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.release, (Object)emulatorDevice.release)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.apiLevel, (Object)emulatorDevice.apiLevel)) {
                return false;
            }
            if (this.featureLevel != emulatorDevice.featureLevel) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.avdName, (Object)emulatorDevice.avdName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.avdPath, (Object)emulatorDevice.avdPath)) {
                return false;
            }
            return this.type == emulatorDevice.type;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\nH\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u000eH\u00c6\u0003JY\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u00020\nH\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u0014\u0010\u001f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0014\u0010!\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013\u00a8\u00062"}, d2={"Lcom/android/tools/idea/logcat/devices/Device$PhysicalDevice;", "Lcom/android/tools/idea/logcat/devices/Device;", "serialNumber", "", "isOnline", "", "release", "apiLevel", "Lcom/android/sdklib/AndroidApiLevel;", "featureLevel", "", "manufacturer", "model", "type", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Lcom/android/sdklib/AndroidApiLevel;ILjava/lang/String;Ljava/lang/String;Lcom/android/sdklib/deviceprovisioner/DeviceType;)V", "getSerialNumber", "()Ljava/lang/String;", "()Z", "getRelease", "getApiLevel", "()Lcom/android/sdklib/AndroidApiLevel;", "getFeatureLevel", "()I", "getManufacturer", "getModel", "getType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "deviceId", "getDeviceId", "name", "getName", "isEmulator", "getScreenshotParameters", "Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters;", "copy", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "equals", "other", "", "hashCode", "toString", "intellij.android.logcat"})
    public static final class PhysicalDevice
    extends Device {
        @NotNull
        private final String serialNumber;
        private final boolean isOnline;
        @NotNull
        private final String release;
        @NotNull
        private final AndroidApiLevel apiLevel;
        private final int featureLevel;
        @NotNull
        private final String manufacturer;
        @NotNull
        private final String model;
        @NotNull
        private final DeviceType type;

        public PhysicalDevice(@NotNull String serialNumber, boolean isOnline, @NotNull String release, @NotNull AndroidApiLevel apiLevel, int featureLevel, @NotNull String manufacturer, @NotNull String model, @NotNull DeviceType type) {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
            Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(null);
            this.serialNumber = serialNumber;
            this.isOnline = isOnline;
            this.release = release;
            this.apiLevel = apiLevel;
            this.featureLevel = featureLevel;
            this.manufacturer = manufacturer;
            this.model = model;
            this.type = type;
        }

        @Override
        @NotNull
        public String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public boolean isOnline() {
            return this.isOnline;
        }

        @Override
        @NotNull
        public String getRelease() {
            return this.release;
        }

        @Override
        @NotNull
        public AndroidApiLevel getApiLevel() {
            return this.apiLevel;
        }

        @Override
        public int getFeatureLevel() {
            return this.featureLevel;
        }

        @NotNull
        public final String getManufacturer() {
            return this.manufacturer;
        }

        @NotNull
        public final String getModel() {
            return this.model;
        }

        @Override
        @NotNull
        public DeviceType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getDeviceId() {
            return this.getSerialNumber();
        }

        @Override
        @NotNull
        public String getName() {
            return StringsKt.startsWith$default((String)this.model, (String)this.manufacturer, (boolean)false, (int)2, null) ? this.model : this.manufacturer + " " + this.model;
        }

        @Override
        public boolean isEmulator() {
            return false;
        }

        @Override
        @NotNull
        public ScreenshotParameters getScreenshotParameters() {
            return new ScreenshotParameters(this.getSerialNumber(), this.getType(), this.model);
        }

        @Override
        @NotNull
        public PhysicalDevice copy(boolean isOnline, @NotNull AndroidApiLevel apiLevel) {
            Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
            return new PhysicalDevice(this.getSerialNumber(), isOnline, this.getRelease(), apiLevel, this.getFeatureLevel(), this.manufacturer, this.model, this.getType());
        }

        @NotNull
        public final String component1() {
            return this.serialNumber;
        }

        public final boolean component2() {
            return this.isOnline;
        }

        @NotNull
        public final String component3() {
            return this.release;
        }

        @NotNull
        public final AndroidApiLevel component4() {
            return this.apiLevel;
        }

        public final int component5() {
            return this.featureLevel;
        }

        @NotNull
        public final String component6() {
            return this.manufacturer;
        }

        @NotNull
        public final String component7() {
            return this.model;
        }

        @NotNull
        public final DeviceType component8() {
            return this.type;
        }

        @NotNull
        public final PhysicalDevice copy(@NotNull String serialNumber, boolean isOnline, @NotNull String release, @NotNull AndroidApiLevel apiLevel, int featureLevel, @NotNull String manufacturer, @NotNull String model, @NotNull DeviceType type) {
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
            Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new PhysicalDevice(serialNumber, isOnline, release, apiLevel, featureLevel, manufacturer, model, type);
        }

        public static /* synthetic */ PhysicalDevice copy$default(PhysicalDevice physicalDevice, String string, boolean bl, String string2, AndroidApiLevel androidApiLevel, int n, String string3, String string4, DeviceType deviceType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = physicalDevice.serialNumber;
            }
            if ((n2 & 2) != 0) {
                bl = physicalDevice.isOnline;
            }
            if ((n2 & 4) != 0) {
                string2 = physicalDevice.release;
            }
            if ((n2 & 8) != 0) {
                androidApiLevel = physicalDevice.apiLevel;
            }
            if ((n2 & 0x10) != 0) {
                n = physicalDevice.featureLevel;
            }
            if ((n2 & 0x20) != 0) {
                string3 = physicalDevice.manufacturer;
            }
            if ((n2 & 0x40) != 0) {
                string4 = physicalDevice.model;
            }
            if ((n2 & 0x80) != 0) {
                deviceType = physicalDevice.type;
            }
            return physicalDevice.copy(string, bl, string2, androidApiLevel, n, string3, string4, deviceType);
        }

        @NotNull
        public String toString() {
            return "PhysicalDevice(serialNumber=" + this.serialNumber + ", isOnline=" + this.isOnline + ", release=" + this.release + ", apiLevel=" + this.apiLevel + ", featureLevel=" + this.featureLevel + ", manufacturer=" + this.manufacturer + ", model=" + this.model + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.serialNumber.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isOnline);
            result2 = result2 * 31 + this.release.hashCode();
            result2 = result2 * 31 + this.apiLevel.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.featureLevel);
            result2 = result2 * 31 + this.manufacturer.hashCode();
            result2 = result2 * 31 + this.model.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PhysicalDevice)) {
                return false;
            }
            PhysicalDevice physicalDevice = (PhysicalDevice)other;
            if (!Intrinsics.areEqual((Object)this.serialNumber, (Object)physicalDevice.serialNumber)) {
                return false;
            }
            if (this.isOnline != physicalDevice.isOnline) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.release, (Object)physicalDevice.release)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.apiLevel, (Object)physicalDevice.apiLevel)) {
                return false;
            }
            if (this.featureLevel != physicalDevice.featureLevel) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.manufacturer, (Object)physicalDevice.manufacturer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.model, (Object)physicalDevice.model)) {
                return false;
            }
            return this.type == physicalDevice.type;
        }
    }
}

