/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.ModCommandLintQuickFix;
import com.android.tools.idea.lint.quickFixes.RemoveSdkCheckFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

public class AndroidLintObsoleteSdkIntInspection
extends AndroidLintInspectionBase {
    public AndroidLintObsoleteSdkIntInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.obsolete.sdk.int", new Object[0]), ApiDetector.OBSOLETE_SDK);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        if (fixData instanceof LintFix.DataMap) {
            LintFix.DataMap map2 = (LintFix.DataMap)fixData;
            Boolean constant = null;
            if (map2.hasKey("conditional")) {
                constant = LintFix.getBoolean((LintFix)fixData, (String)"conditional", (boolean)false);
            }
            if (constant != null) {
                PsiBinaryExpression subExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiBinaryExpression.class, (boolean)false);
                if (subExpression != null) {
                    return new LintIdeQuickFix[]{new ModCommandLintQuickFix((ModCommandAction)new SimplifyBooleanExpressionFix((PsiExpression)subExpression, constant.booleanValue()))};
                }
                if (startElement.getLanguage() == KotlinLanguage.INSTANCE) {
                    return new LintIdeQuickFix[]{new RemoveSdkCheckFix(constant)};
                }
            } else {
                File file = map2.getFile("file", null);
                String destFolder = map2.getString("folderName", null);
                int api = map2.getInt("requiresApi", -1);
                if (file != null && destFolder != null && api != -1) {
                    AndroidVersion minSdkVersion2 = new AndroidVersion(api);
                    AndroidFacet facet = AndroidFacet.getInstance((PsiElement)startElement);
                    VirtualFile dir = StandardFileSystems.local().findFileByPath(file.getPath());
                    if (facet != null && dir != null) {
                        return new LintIdeQuickFix[]{new MergeResourceFolderFix(facet, dir, destFolder, minSdkVersion2)};
                    }
                }
            }
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }

    private static class MergeResourceFolderFix
    extends DefaultLintQuickFix {
        private final AndroidFacet facet;
        private final VirtualFile dir;
        private final String destFolderName;
        private final AndroidVersion minSdkVersion;
        List<VirtualFile> sourceFolders;

        MergeResourceFolderFix(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull String destFolderName, AndroidVersion minSdkVersion2) {
            super("");
            this.facet = facet;
            this.dir = dir;
            this.destFolderName = destFolderName;
            this.minSdkVersion = minSdkVersion2;
        }

        private List<VirtualFile> findSourceFolders() {
            if (this.sourceFolders == null) {
                ArrayList<VirtualFile> folders = new ArrayList<VirtualFile>();
                int apiLevel = this.minSdkVersion.getFeatureLevel();
                String dirName = this.dir.getName();
                FolderConfiguration oldConfig = FolderConfiguration.getConfigForFolder((String)dirName);
                assert (oldConfig != null);
                assert (oldConfig.getVersionQualifier() != null);
                int startingVersion = oldConfig.getVersionQualifier().getVersion();
                oldConfig.setVersionQualifier(null);
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)dirName);
                for (VirtualFile folder : this.dir.getParent().getChildren()) {
                    VersionQualifier versionQualifier;
                    FolderConfiguration siblingConfig;
                    if (!folder.isDirectory() || folderType != ResourceFolderType.getFolderType((String)folder.getName()) || (siblingConfig = FolderConfiguration.getConfigForFolder((String)folder.getName())) == null || (versionQualifier = siblingConfig.getVersionQualifier()) == null || versionQualifier.hasFakeValue() || versionQualifier.getVersion() > apiLevel || versionQualifier.getVersion() < startingVersion) continue;
                    siblingConfig.setVersionQualifier(null);
                    if (!siblingConfig.equals((Object)oldConfig)) continue;
                    folders.add(folder);
                }
                folders.sort((f1, f2) -> {
                    FolderConfiguration configuration1 = FolderConfiguration.getConfigForFolder((String)f1.getName());
                    FolderConfiguration configuration2 = FolderConfiguration.getConfigForFolder((String)f2.getName());
                    assert (configuration1 != null);
                    assert (configuration2 != null);
                    return -configuration1.compareTo(configuration2);
                });
                this.sourceFolders = folders;
            }
            return this.sourceFolders;
        }

        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            ResourceFolderRepository repository2 = ResourceFolderRegistry.getInstance(this.facet.getModule().getProject()).get(this.facet, this.dir.getParent());
            Project project = this.facet.getModule().getProject();
            List<VirtualFile> folders = this.findSourceFolders();
            if (!folders.isEmpty()) {
                for (int i = 0; i < folders.size() - 1; ++i) {
                    VirtualFile folder = folders.get(i);
                    VirtualFile target2 = folders.get(i + 1);
                    MergeResourceFolderFix.mergeResourceFolder(project, folder, target2.getName(), repository2);
                }
                MergeResourceFolderFix.mergeResourceFolder(project, folders.get(folders.size() - 1), this.destFolderName, repository2);
            }
        }

        private static void mergeResourceFolder(@NotNull Project project, @NotNull VirtualFile dir, @NotNull String targetDir, @NotNull ResourceRepository repository2) {
            Class<AndroidLintInspectionBase> requestor = AndroidLintInspectionBase.class;
            FolderConfiguration oldConfig = FolderConfiguration.getConfigForFolder((String)dir.getName());
            FolderConfiguration newConfig = FolderConfiguration.getConfigForFolder((String)targetDir);
            assert (oldConfig != null);
            assert (newConfig != null);
            ArrayListMultimap destFolderResources = ArrayListMultimap.create((int)100, (int)2);
            ArrayList<ResourceItem> srcItems = new ArrayList<ResourceItem>();
            for (ResourceItem item : repository2.getAllResources()) {
                FolderConfiguration configuration2 = item.getConfiguration();
                if (oldConfig.equals((Object)configuration2)) {
                    VirtualFile sourceFile = IdeResourcesUtil.getSourceAsVirtualFile(item);
                    if (sourceFile == null || !dir.equals(sourceFile.getParent())) continue;
                    srcItems.add(item);
                    continue;
                }
                if (!newConfig.equals((Object)configuration2)) continue;
                destFolderResources.put((Object)item.getName(), (Object)item.getType());
            }
            VirtualFile res2 = dir.getParent();
            if (res2 == null) {
                return;
            }
            try {
                VirtualFile destDir = res2.findChild(targetDir);
                if (destDir == null) {
                    destDir = res2.createChildDirectory(requestor, targetDir);
                }
                for (ResourceItem item : srcItems) {
                    PathString source2 = item.getSource();
                    if (source2 == null) continue;
                    String dirName = source2.getParentFileName();
                    if (dirName != null && dirName.startsWith("values")) {
                        String textValue = null;
                        ResourceValue resourceValue = item.getResourceValue();
                        if (resourceValue != null) {
                            textValue = resourceValue.getValue();
                        }
                        textValue = StringUtil.notNullize(textValue);
                        String fileName = source2.getFileName();
                        List<String> dirNames = Collections.singletonList(targetDir);
                        if (destFolderResources.containsEntry((Object)item.getName(), (Object)item.getType())) {
                            IdeResourcesUtil.changeValueResource(project, res2, item.getName(), item.getType(), textValue, fileName, dirNames, false);
                            continue;
                        }
                        IdeResourcesUtil.createValueResource(project, res2, item.getName(), item.getType(), fileName, dirNames, textValue);
                        continue;
                    }
                    VirtualFile virtualFile = IdeResourcesUtil.getSourceAsVirtualFile(item);
                    if (virtualFile != null) {
                        VirtualFile existing = destDir.findChild(virtualFile.getName());
                        if (existing != null) {
                            existing.delete(requestor);
                        }
                        VfsUtilCore.copyFile(requestor, (VirtualFile)virtualFile, (VirtualFile)destDir);
                        continue;
                    }
                    return;
                }
                for (VirtualFile resourceFile : dir.getChildren()) {
                    resourceFile.delete(requestor);
                }
                dir.delete(requestor);
            }
            catch (IOException e) {
                Logger.getInstance(AndroidLintInspectionBase.class).error((Throwable)e);
            }
        }

        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return this.dir.isDirectory();
        }

        @NotNull
        public String getName() {
            List<VirtualFile> folders = this.findSourceFolders();
            ArrayList names = Lists.newArrayListWithCapacity((int)folders.size());
            for (VirtualFile file : folders) {
                String name2 = file.getName();
                int index = name2.indexOf(45);
                if (index != -1) {
                    name2 = name2.substring(index);
                }
                names.add(name2);
            }
            String sourceFolders = Joiner.on((String)" and ").join((Iterable)names);
            return String.format("Merge resources from %1$s into %2$s", sourceFolders, this.destFolderName);
        }
    }
}

