/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.toolwindow.ContentManagerHierarchyAdapter;
import com.android.tools.idea.layoutinspector.runningdevices.RunningDevicesStateObserverKt;
import com.android.tools.idea.streaming.core.DeviceId;
import com.android.tools.idea.streaming.core.StreamingConstants;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 #2\u00020\u0001:\u0003\"#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000eR*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listeners", "", "Lcom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver$Listener;", "value", "", "Lcom/android/tools/idea/streaming/core/DeviceId;", "visibleTabs", "setVisibleTabs", "(Ljava/util/List;)V", "existingTabs", "setExistingTabs", "dispose", "", "addListener", "listener", "getAllContents", "Lcom/intellij/ui/content/Content;", "getTabContent", "deviceId", "updateVisibleTabs", "updateExistingTabs", "getRunningDevicesVisibleTabs", "getAllTabsDeviceIds", "hasDeviceWithSerialNumber", "", "desiredSerialNumber", "", "hasDevice", "Listener", "Companion", "RunningDevicesContentManagerListener", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nRunningDevicesStateObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunningDevicesStateObserver.kt\ncom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1869#2,2:223\n1869#2,2:225\n774#2:228\n865#2,2:229\n1617#2,9:231\n1869#2:240\n1870#2:242\n1626#2:243\n1563#2:244\n1634#2,3:245\n808#2,11:248\n1617#2,9:259\n1869#2:268\n1870#2:270\n1626#2:271\n1563#2:272\n1634#2,3:273\n1#3:227\n1#3:241\n1#3:269\n*S KotlinDebug\n*F\n+ 1 RunningDevicesStateObserver.kt\ncom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver\n*L\n73#1:223,2\n83#1:225,2\n179#1:228\n179#1:229,2\n180#1:231,9\n180#1:240\n180#1:242\n180#1:243\n188#1:244\n188#1:245,3\n189#1:248,11\n190#1:259,9\n190#1:268\n190#1:270\n190#1:271\n204#1:272\n204#1:273,3\n180#1:241\n190#1:269\n*E\n"})
public final class RunningDevicesStateObserver
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<Listener> listeners;
    @NotNull
    private List<? extends DeviceId> visibleTabs;
    @NotNull
    private List<? extends DeviceId> existingTabs;

    public RunningDevicesStateObserver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.listeners = new ArrayList();
        this.visibleTabs = CollectionsKt.emptyList();
        this.existingTabs = CollectionsKt.emptyList();
        Ref.ObjectRef toolWindowListener = new Ref.ObjectRef();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener((Ref.ObjectRef<RunningDevicesContentManagerListener>)toolWindowListener, this){
            final /* synthetic */ Ref.ObjectRef<RunningDevicesContentManagerListener> $toolWindowListener;
            final /* synthetic */ RunningDevicesStateObserver this$0;
            {
                this.$toolWindowListener = $toolWindowListener;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = toolWindowManager.getToolWindow("Running Devices");
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                if (this.$toolWindowListener.element == null) {
                    void it;
                    RunningDevicesContentManagerListener runningDevicesContentManagerListener = this.this$0.new RunningDevicesContentManagerListener(toolWindow2);
                    RunningDevicesStateObserver runningDevicesStateObserver = this.this$0;
                    RunningDevicesContentManagerListener runningDevicesContentManagerListener2 = runningDevicesContentManagerListener;
                    Ref.ObjectRef<RunningDevicesContentManagerListener> objectRef = this.$toolWindowListener;
                    boolean bl = false;
                    Disposer.register((Disposable)runningDevicesStateObserver, (Disposable)((Disposable)it));
                    objectRef.element = runningDevicesContentManagerListener;
                }
                toolWindowManager.invokeLater(() -> 1.stateChanged$lambda$1(toolWindow2, this.this$0));
            }

            private static final void stateChanged$lambda$1(ToolWindow $toolWindow, RunningDevicesStateObserver this$0) {
                if (!$toolWindow.isDisposed()) {
                    if ($toolWindow.isVisible()) {
                        this$0.updateVisibleTabs();
                    } else {
                        this$0.setVisibleTabs(CollectionsKt.emptyList());
                    }
                }
            }
        });
    }

    private final void setVisibleTabs(List<? extends DeviceId> value2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Intrinsics.areEqual(value2, this.visibleTabs)) {
            return;
        }
        this.visibleTabs = value2;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onVisibleTabsChanged(value2);
        }
    }

    private final void setExistingTabs(List<? extends DeviceId> value2) {
        if (Intrinsics.areEqual(value2, this.existingTabs)) {
            return;
        }
        this.existingTabs = value2;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onExistingTabsChanged(value2);
        }
    }

    public void dispose() {
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        listener2.onVisibleTabsChanged(this.visibleTabs);
        listener2.onExistingTabsChanged(this.existingTabs);
        this.listeners.add(listener2);
    }

    private final List<Content> getAllContents() {
        ToolWindow toolWindow;
        ToolWindowManager toolWindowManager = (ToolWindowManager)this.project.getServiceIfCreated(ToolWindowManager.class);
        if (toolWindowManager == null || (toolWindow = toolWindowManager.getToolWindow("Running Devices")) == null) {
            return CollectionsKt.emptyList();
        }
        ToolWindow toolWindow2 = toolWindow;
        Object object = toolWindow2.getContentManagerIfCreated();
        if (object == null || (object = object.getContentsRecursively()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final Content getTabContent(@NotNull DeviceId deviceId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Iterable iterable = this.getAllContents();
            for (Object t : iterable) {
                Content it = (Content)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)RunningDevicesStateObserverKt.access$getDeviceId(it), (Object)deviceId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void updateVisibleTabs() {
        List<DeviceId> deviceIds = this.getRunningDevicesVisibleTabs();
        this.setVisibleTabs(deviceIds);
    }

    private final void updateExistingTabs() {
        List<DeviceId> deviceIds = this.getAllTabsDeviceIds();
        this.setExistingTabs(deviceIds);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DeviceId> getRunningDevicesVisibleTabs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllContents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Content it = (Content)element$iv$iv;
            boolean bl = false;
            if (!it.isSelected()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selectedContent = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = selectedContent;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DeviceId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Content it = (Content)element$iv$iv;
            boolean bl2 = false;
            if (RunningDevicesStateObserverKt.access$getDeviceId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DeviceId> getAllTabsDeviceIds() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        List<Content> contents = this.getAllContents();
        Iterable $this$map$iv = contents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Content)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getComponent());
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UiDataProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            DeviceId it$iv$iv;
            DataContext dataContext;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            UiDataProvider dataProvider = (UiDataProvider)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)DataManager.getInstance().customizeDataContext(DataContext.EMPTY_CONTEXT, (Object)dataProvider), (String)"customizeDataContext(...)");
            if ((DeviceId)StreamingConstants.DEVICE_ID_KEY.getData(dataContext) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List tabIds = (List)destination$iv$iv;
        return tabIds;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasDeviceWithSerialNumber(String desiredSerialNumber) {
        void $this$mapTo$iv$iv;
        List<DeviceId> devicesIds = this.getAllTabsDeviceIds();
        Iterable $this$map$iv = devicesIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeviceId deviceId = (DeviceId)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getSerialNumber());
        }
        return ((List)destination$iv$iv).contains(desiredSerialNumber);
    }

    public final boolean hasDevice(@NotNull DeviceId deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        return this.hasDeviceWithSerialNumber(deviceId.getSerialNumber());
    }

    @JvmStatic
    @NotNull
    public static final RunningDevicesStateObserver getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RunningDevicesStateObserver getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(RunningDevicesStateObserver.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RunningDevicesStateObserver)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver$Listener;", "", "onVisibleTabsChanged", "", "visibleTabs", "", "Lcom/android/tools/idea/streaming/core/DeviceId;", "onExistingTabsChanged", "existingTabs", "intellij.android.layout-inspector"})
    public static interface Listener {
        public void onVisibleTabsChanged(@NotNull List<? extends DeviceId> var1);

        public void onExistingTabsChanged(@NotNull List<? extends DeviceId> var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver$RunningDevicesContentManagerListener;", "Lcom/android/tools/adtui/toolwindow/ContentManagerHierarchyAdapter;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/android/tools/idea/layoutinspector/runningdevices/RunningDevicesStateObserver;Lcom/intellij/openapi/wm/ToolWindow;)V", "contentAdded", "", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "contentRemoveQuery", "selectionChanged", "intellij.android.layout-inspector"})
    private final class RunningDevicesContentManagerListener
    extends ContentManagerHierarchyAdapter {
        public RunningDevicesContentManagerListener(ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            super(toolWindow);
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ActionsKt.invokeLater$default(null, () -> RunningDevicesContentManagerListener.contentAdded$lambda$0(RunningDevicesStateObserver.this), (int)1, null);
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ActionsKt.invokeLater$default(null, () -> RunningDevicesContentManagerListener.contentRemoveQuery$lambda$1(RunningDevicesStateObserver.this), (int)1, null);
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ActionsKt.invokeLater$default(null, () -> RunningDevicesContentManagerListener.selectionChanged$lambda$2(RunningDevicesStateObserver.this), (int)1, null);
        }

        private static final Unit contentAdded$lambda$0(RunningDevicesStateObserver this$0) {
            this$0.updateExistingTabs();
            return Unit.INSTANCE;
        }

        private static final Unit contentRemoveQuery$lambda$1(RunningDevicesStateObserver this$0) {
            this$0.updateExistingTabs();
            return Unit.INSTANCE;
        }

        private static final Unit selectionChanged$lambda$2(RunningDevicesStateObserver this$0) {
            this$0.updateVisibleTabs();
            return Unit.INSTANCE;
        }
    }
}

