/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.legacy;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DebugViewDumpHandler;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.ComponentTreeData;
import com.android.tools.idea.layoutinspector.pipeline.TreeLoader;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtils;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtilsKt;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyAndroidWindow;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyClient;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyEvent;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyPropertiesProvider;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyTreeLoaderKt;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyTreeParser;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.resource.data.ResourceKt;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader;", "Lcom/android/tools/idea/layoutinspector/pipeline/TreeLoader;", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;", "<init>", "(Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;)V", "selectedDdmClient", "Lcom/android/ddmlib/Client;", "getSelectedDdmClient", "(Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;)Lcom/android/ddmlib/Client;", "ddmClientOverride", "getDdmClientOverride$annotations", "()V", "getDdmClientOverride", "()Lcom/android/ddmlib/Client;", "setDdmClientOverride", "(Lcom/android/ddmlib/Client;)V", "loadComponentTree", "Lcom/android/tools/idea/layoutinspector/pipeline/ComponentTreeData;", "data", "", "resourceLookup", "Lcom/android/tools/idea/layoutinspector/resource/ResourceLookup;", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "getAllWindowIds", "", "", "capture", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "windowName", "propertiesUpdater", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyPropertiesProvider$Updater;", "updateConfiguration", "", "ddmClient", "findConfiguration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "adb", "Lcom/android/ddmlib/AndroidDebugBridge;", "findTheme", "Lcom/android/ide/common/rendering/api/ResourceReference;", "findCurrentActivity", "CaptureByteArrayHandler", "ListViewRootsHandler", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nLegacyTreeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyTreeLoader.kt\ncom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class LegacyTreeLoader
implements TreeLoader {
    @NotNull
    private final LegacyClient client;
    @Nullable
    private Client ddmClientOverride;

    public LegacyTreeLoader(@NotNull LegacyClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    private final Client getSelectedDdmClient(LegacyClient $this$selectedDdmClient) {
        Object object = this.ddmClientOverride;
        if (object == null) {
            AndroidDebugBridge androidDebugBridge = (AndroidDebugBridge)AdbUtils.INSTANCE.getAdbFuture(this.client.getModel().getProject()).get();
            object = androidDebugBridge != null ? AdbUtilsKt.findClient(androidDebugBridge, $this$selectedDdmClient.getProcess()) : null;
        }
        return object;
    }

    @Nullable
    public final Client getDdmClientOverride() {
        return this.ddmClientOverride;
    }

    public final void setDdmClientOverride(@Nullable Client client) {
        this.ddmClientOverride = client;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDdmClientOverride$annotations() {
    }

    @Override
    @Nullable
    public ComponentTreeData loadComponentTree(@Nullable Object data2, @NotNull ResourceLookup resourceLookup, @NotNull ProcessDescriptor process2) {
        ComponentTreeData componentTreeData;
        Intrinsics.checkNotNullParameter((Object)resourceLookup, (String)"resourceLookup");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        LegacyEvent legacyEvent = data2 instanceof LegacyEvent ? (LegacyEvent)data2 : null;
        if (legacyEvent == null) {
            return null;
        }
        LegacyEvent legacyEvent2 = legacyEvent;
        String windowName = legacyEvent2.component1();
        LegacyPropertiesProvider.Updater updater = legacyEvent2.component2();
        AndroidWindow androidWindow = this.capture(windowName, updater);
        if (androidWindow != null) {
            AndroidWindow it = androidWindow;
            boolean bl = false;
            componentTreeData = new ComponentTreeData(it, 0, SetsKt.emptySet());
        } else {
            componentTreeData = null;
        }
        return componentTreeData;
    }

    @Nullable
    public List<String> getAllWindowIds(@Nullable Object data2) {
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_WINDOW_LIST_REQUESTED);
        Client client = this.getSelectedDdmClient(this.client);
        if (client == null) {
            return null;
        }
        Client ddmClient = client;
        List<String> result2 = data2 instanceof LegacyEvent ? ((LegacyEvent)data2).getAllWindows() : new ListViewRootsHandler().getWindows(ddmClient, 5L, TimeUnit.SECONDS);
        this.client.getLatestScreenshots().keySet().retainAll((Collection)result2);
        this.client.getLatestData().keySet().retainAll((Collection)result2);
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_WINDOW_LIST_RECEIVED);
        return result2;
    }

    @Slow
    private final AndroidWindow capture(String windowName, LegacyPropertiesProvider.Updater propertiesUpdater) {
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_HIERARCHY_REQUESTED);
        Client client = this.getSelectedDdmClient(this.client);
        if (client == null) {
            return null;
        }
        Client ddmClient = client;
        CaptureByteArrayHandler hierarchyHandler = new CaptureByteArrayHandler();
        ddmClient.dumpViewHierarchy(windowName, false, true, false, (DebugViewDumpHandler)hierarchyHandler);
        this.updateConfiguration(ddmClient);
        byte[] byArray = hierarchyHandler.getData();
        if (byArray == null) {
            return null;
        }
        byte[] hierarchyData = byArray;
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_HIERARCHY_RECEIVED);
        this.client.getLatestData().put(windowName, hierarchyData);
        if (!this.client.isConnected()) {
            return null;
        }
        Pair<ViewNode, String> pair = LegacyTreeParser.INSTANCE.parseLiveViewNode(hierarchyData, propertiesUpdater);
        if (pair == null) {
            return null;
        }
        Pair<ViewNode, String> pair2 = pair;
        ViewNode rootNode = (ViewNode)pair2.component1();
        String hash = (String)pair2.component2();
        CaptureByteArrayHandler imageHandler = new CaptureByteArrayHandler();
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_SCREENSHOT_REQUESTED);
        ddmClient.captureView(windowName, hash, (DebugViewDumpHandler)imageHandler);
        try {
            byte[] byArray2 = imageHandler.getData();
            if (byArray2 != null) {
                byte[] it = byArray2;
                boolean bl = false;
                this.client.getLatestScreenshots().put(windowName, it);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_SCREENSHOT_RECEIVED);
        return new LegacyAndroidWindow(this.client, rootNode, windowName);
    }

    private final void updateConfiguration(Client ddmClient) {
        ResourceReference theme;
        FolderConfiguration folderConfiguration;
        AndroidDebugBridge adb;
        AndroidDebugBridge androidDebugBridge = adb = (AndroidDebugBridge)AdbUtils.INSTANCE.getAdbFuture(this.client.getModel().getProject()).get();
        if (androidDebugBridge != null) {
            AndroidDebugBridge it = androidDebugBridge;
            boolean bl = false;
            folderConfiguration = this.findConfiguration(it);
        } else {
            folderConfiguration = null;
        }
        FolderConfiguration folderConfiguration2 = folderConfiguration;
        AndroidDebugBridge androidDebugBridge2 = adb;
        if (androidDebugBridge2 != null) {
            AndroidDebugBridge it = androidDebugBridge2;
            boolean bl = false;
            v3 = this.findTheme(it);
        } else {
            v3 = theme = null;
        }
        if (folderConfiguration2 != null) {
            this.client.getModel().getResourceLookup().updateConfiguration(folderConfiguration2, theme, this.client.getProcess(), 1.0f, CollectionsKt.emptyList());
        } else {
            ResourceLookup.updateConfiguration$default(this.client.getModel().getResourceLookup(), ddmClient.getDevice().getDensity(), null, 2, null);
        }
    }

    private final FolderConfiguration findConfiguration(AndroidDebugBridge adb) {
        this.client.setLatestConfig("");
        String configurations = AdbUtilsKt.executeShellCommand$default(adb, this.client.getProcess().getDevice(), "am get-config", 0L, 4, null);
        MatchResult matchResult = Regex.find$default((Regex)LegacyTreeLoaderKt.access$getCONFIGURATION_REGEX$p(), (CharSequence)configurations, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        if (result2.getGroupValues().size() < 2) {
            return null;
        }
        String config = (String)result2.getGroupValues().get(1);
        this.client.setLatestConfig(config);
        return FolderConfiguration.getConfigForQualifierString((String)config);
    }

    private final ResourceReference findTheme(AndroidDebugBridge adb) {
        String string;
        block8: {
            Module module;
            block7: {
                Module module2;
                String activity;
                block6: {
                    this.client.setLatestTheme("");
                    activity = this.findCurrentActivity(adb);
                    Module[] moduleArray = ProjectUtil.getModules((Project)this.client.getModel().getProject());
                    int n = moduleArray.length;
                    for (int i = 0; i < n; ++i) {
                        Module module3;
                        Module it = module3 = moduleArray[i];
                        boolean bl = false;
                        if (!ProjectSystemUtil.getModuleSystem(it).isProductionAndroidModule()) continue;
                        module2 = module3;
                        break block6;
                    }
                    module2 = null;
                }
                if (module2 == null) {
                    return null;
                }
                module = module2;
                string = activity;
                if (string == null) break block7;
                String it = string;
                boolean bl = false;
                String string2 = ThemeUtils.getThemeNameForActivity(module, it);
                string = string2;
                if (string2 != null) break block8;
            }
            if ((string = ThemeUtils.getAppThemeName(module)) == null) {
                return null;
            }
        }
        String themeString = string;
        this.client.setLatestTheme(themeString);
        return ResourceKt.createReference(themeString, this.client.getProcess().getPackageName());
    }

    private final String findCurrentActivity(AndroidDebugBridge adb) {
        String activities = AdbUtilsKt.executeShellCommand$default(adb, this.client.getProcess().getDevice(), "dumpsys activity activities", 0L, 4, null);
        MatchResult matchResult = Regex.find$default((Regex)LegacyTreeLoaderKt.access$getACTIVITY_REGEX$p(), (CharSequence)activities, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        if (result2.getGroupValues().size() < 2) {
            return null;
        }
        return StringsKt.replace$default((String)((String)result2.getGroupValues().get(1)), (String)"/", (String)"", (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader$CaptureByteArrayHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "<init>", "()V", "mData", "Ljava/util/concurrent/atomic/AtomicReference;", "", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "getData", "intellij.android.layout-inspector"})
    private static final class CaptureByteArrayHandler
    extends DebugViewDumpHandler {
        @NotNull
        private final AtomicReference<byte[]> mData = new AtomicReference();

        protected void handleViewDebugResult(@NotNull ByteBuffer data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            byte[] b = new byte[data2.remaining()];
            data2.get(b);
            this.mData.set(b);
        }

        @Nullable
        public final byte[] getData() {
            this.waitForResult(15L, TimeUnit.SECONDS);
            return this.mData.get();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader$ListViewRootsHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "<init>", "()V", "viewRoots", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "kotlin.jvm.PlatformType", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "getWindows", "", "c", "Lcom/android/ddmlib/Client;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "intellij.android.layout-inspector"})
    private static final class ListViewRootsHandler
    extends DebugViewDumpHandler {
        private final CopyOnWriteArrayList<String> viewRoots = Lists.newCopyOnWriteArrayList();

        protected void handleViewDebugResult(@NotNull ByteBuffer data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            int nWindows = data2.getInt();
            for (int i = 0; i < nWindows; ++i) {
                int len = data2.getInt();
                this.viewRoots.add(DebugViewDumpHandler.getString((ByteBuffer)data2, (int)len));
            }
        }

        @Slow
        @NotNull
        public final List<String> getWindows(@NotNull Client c, long timeout, @NotNull TimeUnit unit) throws IOException {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            c.listViewRoots((DebugViewDumpHandler)this);
            this.waitForResult(timeout, unit);
            CopyOnWriteArrayList<String> copyOnWriteArrayList = this.viewRoots;
            Intrinsics.checkNotNullExpressionValue(copyOnWriteArrayList, (String)"viewRoots");
            return copyOnWriteArrayList;
        }
    }
}

