/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.config;

import com.android.tools.idea.lang.databinding._DbLexer;
import com.android.tools.idea.lang.databinding.config.DbFile;
import com.android.tools.idea.lang.databinding.config.DbLanguage;
import com.android.tools.idea.lang.databinding.parser.DbParser;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class DbParserDefinition
implements ParserDefinition {
    private static final IFileElementType FILE_ELEMENT_TYPE = new IFileElementType((Language)DbLanguage.INSTANCE);
    private static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});

    @NotNull
    public Lexer createLexer(Project project) {
        return new FlexAdapter((FlexLexer)new _DbLexer(null));
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new DbParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.STRING_LITERAL});
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return DbTokenTypes.Factory.createElement(node);
    }

    @NotNull
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new DbFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left2, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

