/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.androidSql;

import com.android.tools.idea.lang.androidSql.AndroidSqlKnownContextInspection;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlBindParameter;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlDefinedTableName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlDeleteStatement;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlFile;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlInsertStatement;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectStatement;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectedTableName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlUpdateStatement;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlVisitor;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlWithClauseStatement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/lang/androidSql/AndroidSqlUnresolvedReferenceInspection;", "Lcom/android/tools/idea/lang/androidSql/AndroidSqlKnownContextInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.android.lang"})
public final class AndroidSqlUnresolvedReferenceInspection
extends AndroidSqlKnownContextInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new AndroidSqlVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitColumnName(AndroidSqlColumnName columnName) {
                Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
                super.visitColumnName(columnName);
                this.checkReference(columnName);
            }

            public void visitDefinedTableName(AndroidSqlDefinedTableName definedTableName) {
                Intrinsics.checkNotNullParameter((Object)definedTableName, (String)"definedTableName");
                super.visitDefinedTableName(definedTableName);
                this.checkReference(definedTableName);
            }

            public void visitSelectedTableName(AndroidSqlSelectedTableName selectedTableName) {
                Intrinsics.checkNotNullParameter((Object)selectedTableName, (String)"selectedTableName");
                super.visitSelectedTableName(selectedTableName);
                this.checkReference(selectedTableName);
            }

            public void visitBindParameter(AndroidSqlBindParameter bindParameter) {
                Intrinsics.checkNotNullParameter((Object)bindParameter, (String)"bindParameter");
                super.visitBindParameter(bindParameter);
                this.checkReference(bindParameter);
            }

            private final void checkReference(PsiElement referenceElement) {
                PsiFile psiFile = referenceElement.getContainingFile();
                AndroidSqlFile androidSqlFile = psiFile instanceof AndroidSqlFile ? (AndroidSqlFile)psiFile : null;
                if (androidSqlFile == null) {
                    return;
                }
                AndroidSqlFile sqlFile = androidSqlFile;
                if (InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).isFrankensteinInjection((PsiElement)sqlFile)) {
                    return;
                }
                PsiElement psiElement = PsiTreeUtil.findPrevParent((PsiElement)((PsiElement)referenceElement.getContainingFile()), (PsiElement)referenceElement);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findPrevParent(...)");
                if (!this.isWellUnderstood(psiElement)) {
                    return;
                }
                PsiReference psiReference = referenceElement.getReference();
                if (psiReference == null) {
                    return;
                }
                PsiReference reference = psiReference;
                if (reference.resolve() == null) {
                    this.$holder.registerProblem(reference);
                }
            }

            private final boolean isWellUnderstood(PsiElement stmt) {
                PsiElement psiElement = stmt;
                return psiElement instanceof AndroidSqlSelectStatement || psiElement instanceof AndroidSqlUpdateStatement || psiElement instanceof AndroidSqlInsertStatement || psiElement instanceof AndroidSqlDeleteStatement || psiElement instanceof AndroidSqlWithClauseStatement;
            }
        };
    }
}

