/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui.vcs;

import com.android.tools.idea.insights.VCS_CATEGORY;
import com.android.tools.idea.insights.ui.vcs.ContextDataForDiff;
import com.android.tools.idea.insights.ui.vcs.InsightsDiffViewProvider;
import com.android.tools.idea.insights.ui.vcs.JumpToDiffUtilsKt;
import com.android.tools.idea.insights.vcs.VcsForAppInsights;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DiffPreviewProvider;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/insights/ui/vcs/InsightsDiffViewProvider;", "Lcom/intellij/openapi/vcs/changes/DiffPreviewProvider;", "insightsContext", "Lcom/android/tools/idea/insights/ui/vcs/ContextDataForDiff;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/insights/ui/vcs/ContextDataForDiff;Lcom/intellij/openapi/project/Project;)V", "getInsightsContext", "()Lcom/android/tools/idea/insights/ui/vcs/ContextDataForDiff;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createDiffRequestProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "getOwner", "", "getEditorTabName", "", "processor", "viewConfiguration", "", "Lcom/intellij/openapi/util/Key;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getChange", "()Lcom/intellij/openapi/vcs/changes/Change;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "OwnerObject", "intellij.android.app-quality-insights.ui"})
public final class InsightsDiffViewProvider
implements DiffPreviewProvider {
    @NotNull
    private final ContextDataForDiff insightsContext;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<Key<?>, Object> viewConfiguration;

    public InsightsDiffViewProvider(@NotNull ContextDataForDiff insightsContext, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)insightsContext, (String)"insightsContext");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.insightsContext = insightsContext;
        this.project = project;
        kotlin.Pair[] pairArray = new kotlin.Pair[3];
        Object[] objectArray = new DiffEditorTitleCustomizer[]{JumpToDiffUtilsKt.access$createEditorTitleFromContext(this.insightsContext, this.project), JumpToDiffUtilsKt.access$createEditorTitle("Current source")};
        pairArray[0] = TuplesKt.to((Object)DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER, (Object)CollectionsKt.listOfNotNull((Object[])objectArray));
        pairArray[1] = TuplesKt.to((Object)DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.LEFT, (Object)(this.insightsContext.getLineNumber() - 1)));
        pairArray[2] = TuplesKt.to((Object)DiffUserDataKeys.ALIGNED_TWO_SIDED_DIFF, (Object)true);
        this.viewConfiguration = MapsKt.mapOf((kotlin.Pair[])pairArray);
    }

    @NotNull
    public final ContextDataForDiff getInsightsContext() {
        return this.insightsContext;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DiffRequestProcessor createDiffRequestProcessor() {
        Project project = this.project;
        return (DiffRequestProcessor)new CacheDiffRequestProcessor<ChangeDiffRequestProducer>(this, project){
            final /* synthetic */ InsightsDiffViewProvider this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected String getRequestName(ChangeDiffRequestProducer provider) {
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                String string = provider.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }

            protected ChangeDiffRequestProducer getCurrentRequestProvider() {
                return ChangeDiffRequestProducer.create((Project)this.getProject(), (Change)InsightsDiffViewProvider.access$getChange(this.this$0), (Map)InsightsDiffViewProvider.access$getViewConfiguration$p(this.this$0));
            }

            protected DiffRequest loadRequest(ChangeDiffRequestProducer provider, ProgressIndicator indicator) {
                DiffRequest diffRequest;
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                DiffRequest diffRequest2 = provider.process((UserDataHolder)this.getContext(), indicator);
                Intrinsics.checkNotNullExpressionValue((Object)diffRequest2, (String)"process(...)");
                DiffRequest request = diffRequest2;
                if (request instanceof ErrorDiffRequest) {
                    String message = "Source revision is not available. Update your working tree and try again.";
                    createDiffRequestProcessor.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(createDiffRequestProcessor.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn(message + "(original message: " + ((ErrorDiffRequest)request).getMessage() + ")");
                    diffRequest = (DiffRequest)new ErrorDiffRequest(((ErrorDiffRequest)request).getTitle(), message, ((ErrorDiffRequest)request).getProducer(), ((ErrorDiffRequest)request).getException());
                } else {
                    diffRequest = request;
                }
                return diffRequest;
            }
        };
    }

    @NotNull
    public Object getOwner() {
        return new OwnerObject(this.insightsContext.getVcsKey(), this.insightsContext.getRevision(), this.insightsContext.getFilePath(), this.project);
    }

    @NotNull
    public String getEditorTabName(@Nullable DiffRequestProcessor processor) {
        String string = this.insightsContext.getFilePath().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private final Change getChange() {
        VcsForAppInsights vcsForAppInsights = VcsForAppInsights.Companion.getExtensionByKey(this.insightsContext.getVcsKey());
        ContentRevision vcsContent = vcsForAppInsights != null ? vcsForAppInsights.createVcsContent(this.insightsContext.getFilePath(), this.insightsContext.getRevision(), this.project) : null;
        List list = VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)this.insightsContext.getFilePath(), vcsContent);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createChangesWithCurrentContentForFile(...)");
        Object object = CollectionsKt.single((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
        return (Change)object;
    }

    @NotNull
    public final ContextDataForDiff component1() {
        return this.insightsContext;
    }

    @NotNull
    public final Project component2() {
        return this.project;
    }

    @NotNull
    public final InsightsDiffViewProvider copy(@NotNull ContextDataForDiff insightsContext, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)insightsContext, (String)"insightsContext");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new InsightsDiffViewProvider(insightsContext, project);
    }

    public static /* synthetic */ InsightsDiffViewProvider copy$default(InsightsDiffViewProvider insightsDiffViewProvider, ContextDataForDiff contextDataForDiff, Project project, int n, Object object) {
        if ((n & 1) != 0) {
            contextDataForDiff = insightsDiffViewProvider.insightsContext;
        }
        if ((n & 2) != 0) {
            project = insightsDiffViewProvider.project;
        }
        return insightsDiffViewProvider.copy(contextDataForDiff, project);
    }

    @NotNull
    public String toString() {
        return "InsightsDiffViewProvider(insightsContext=" + this.insightsContext + ", project=" + this.project + ")";
    }

    public int hashCode() {
        int result2 = this.insightsContext.hashCode();
        result2 = result2 * 31 + this.project.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InsightsDiffViewProvider)) {
            return false;
        }
        InsightsDiffViewProvider insightsDiffViewProvider = (InsightsDiffViewProvider)other;
        if (!Intrinsics.areEqual((Object)this.insightsContext, (Object)insightsDiffViewProvider.insightsContext)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.project, (Object)insightsDiffViewProvider.project);
    }

    public static final /* synthetic */ Change access$getChange(InsightsDiffViewProvider $this) {
        return $this.getChange();
    }

    public static final /* synthetic */ Map access$getViewConfiguration$p(InsightsDiffViewProvider $this) {
        return $this.viewConfiguration;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/insights/ui/vcs/InsightsDiffViewProvider$OwnerObject;", "", "vcsKey", "Lcom/android/tools/idea/insights/VCS_CATEGORY;", "revision", "", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/insights/VCS_CATEGORY;Ljava/lang/String;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/project/Project;)V", "getVcsKey", "()Lcom/android/tools/idea/insights/VCS_CATEGORY;", "getRevision", "()Ljava/lang/String;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.app-quality-insights.ui"})
    public static final class OwnerObject {
        @NotNull
        private final VCS_CATEGORY vcsKey;
        @NotNull
        private final String revision;
        @NotNull
        private final FilePath filePath;
        @NotNull
        private final Project project;

        public OwnerObject(@NotNull VCS_CATEGORY vcsKey, @NotNull String revision, @NotNull FilePath filePath, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)((Object)vcsKey), (String)"vcsKey");
            Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.vcsKey = vcsKey;
            this.revision = revision;
            this.filePath = filePath;
            this.project = project;
        }

        @NotNull
        public final VCS_CATEGORY getVcsKey() {
            return this.vcsKey;
        }

        @NotNull
        public final String getRevision() {
            return this.revision;
        }

        @NotNull
        public final FilePath getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VCS_CATEGORY component1() {
            return this.vcsKey;
        }

        @NotNull
        public final String component2() {
            return this.revision;
        }

        @NotNull
        public final FilePath component3() {
            return this.filePath;
        }

        @NotNull
        public final Project component4() {
            return this.project;
        }

        @NotNull
        public final OwnerObject copy(@NotNull VCS_CATEGORY vcsKey, @NotNull String revision, @NotNull FilePath filePath, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)((Object)vcsKey), (String)"vcsKey");
            Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new OwnerObject(vcsKey, revision, filePath, project);
        }

        public static /* synthetic */ OwnerObject copy$default(OwnerObject ownerObject, VCS_CATEGORY vCS_CATEGORY, String string, FilePath filePath, Project project, int n, Object object) {
            if ((n & 1) != 0) {
                vCS_CATEGORY = ownerObject.vcsKey;
            }
            if ((n & 2) != 0) {
                string = ownerObject.revision;
            }
            if ((n & 4) != 0) {
                filePath = ownerObject.filePath;
            }
            if ((n & 8) != 0) {
                project = ownerObject.project;
            }
            return ownerObject.copy(vCS_CATEGORY, string, filePath, project);
        }

        @NotNull
        public String toString() {
            return "OwnerObject(vcsKey=" + this.vcsKey + ", revision=" + this.revision + ", filePath=" + this.filePath + ", project=" + this.project + ")";
        }

        public int hashCode() {
            int result2 = this.vcsKey.hashCode();
            result2 = result2 * 31 + this.revision.hashCode();
            result2 = result2 * 31 + this.filePath.hashCode();
            result2 = result2 * 31 + this.project.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OwnerObject)) {
                return false;
            }
            OwnerObject ownerObject = (OwnerObject)other;
            if (this.vcsKey != ownerObject.vcsKey) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.revision, (Object)ownerObject.revision)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)ownerObject.filePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.project, (Object)ownerObject.project);
        }
    }
}

