/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui.vcs;

import com.android.tools.idea.insights.AppVcsInfo;
import com.android.tools.idea.insights.Connection;
import com.android.tools.idea.insights.RepoInfo;
import com.android.tools.idea.insights.analytics.AppInsightsTracker;
import com.android.tools.idea.insights.ui.vcs.ContextDataForDiff;
import com.android.tools.idea.insights.ui.vcs.InlayPresentationUtilsKt;
import com.android.tools.idea.insights.ui.vcs.InsightsExceptionInfoCache;
import com.android.tools.idea.insights.ui.vcs.InsightsTextInlayPresentation;
import com.android.tools.idea.insights.ui.vcs.JumpToDiffUtilsKt;
import com.android.tools.idea.insights.ui.vcs.KeysKt;
import com.android.tools.idea.insights.vcs.VcsUtilsKt;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/insights/ui/vcs/InsightsAttachInlayDiffLinkFilter;", "Lcom/intellij/execution/filters/Filter;", "exceptionInfoCache", "Lcom/android/tools/idea/insights/ui/vcs/InsightsExceptionInfoCache;", "containingConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "tracker", "Lcom/android/tools/idea/insights/analytics/AppInsightsTracker;", "<init>", "(Lcom/android/tools/idea/insights/ui/vcs/InsightsExceptionInfoCache;Lcom/intellij/execution/impl/ConsoleViewImpl;Lcom/android/tools/idea/insights/analytics/AppInsightsTracker;)V", "project", "Lcom/intellij/openapi/project/Project;", "fetchVcsInfo", "Lcom/android/tools/idea/insights/AppVcsInfo$ValidInfo;", "fetchAssociatedConnection", "Lcom/android/tools/idea/insights/Connection;", "createContextDataForDiff", "Lcom/android/tools/idea/insights/ui/vcs/ContextDataForDiff;", "appVcsInfo", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "textEndOffset", "DiffLinkInlayResult", "Companion", "intellij.android.app-quality-insights.ui"})
@SourceDebugExtension(value={"SMAP\nInsightsAttachInlayDiffLinkFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsAttachInlayDiffLinkFilter.kt\ncom/android/tools/idea/insights/ui/vcs/InsightsAttachInlayDiffLinkFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n295#2,2:296\n1617#2,9:298\n1869#2:307\n1870#2:309\n1626#2:310\n1#3:308\n1#3:311\n*S KotlinDebug\n*F\n+ 1 InsightsAttachInlayDiffLinkFilter.kt\ncom/android/tools/idea/insights/ui/vcs/InsightsAttachInlayDiffLinkFilter\n*L\n86#1:296,2\n89#1:298,9\n89#1:307\n89#1:309\n89#1:310\n89#1:308\n*E\n"})
public final class InsightsAttachInlayDiffLinkFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InsightsExceptionInfoCache exceptionInfoCache;
    @NotNull
    private final ConsoleViewImpl containingConsole;
    @NotNull
    private final AppInsightsTracker tracker;
    @NotNull
    private final Project project;
    @NotNull
    private static final String INLAY_DIFF_LINK_DISPLAY_TEXT = "show diff";
    @NotNull
    private static final String TOOLTIP_TEXT = "Show the difference between the historical source from the app version referenced in the issue and the current source.";

    public InsightsAttachInlayDiffLinkFilter(@NotNull InsightsExceptionInfoCache exceptionInfoCache, @NotNull ConsoleViewImpl containingConsole, @NotNull AppInsightsTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)exceptionInfoCache, (String)"exceptionInfoCache");
        Intrinsics.checkNotNullParameter((Object)containingConsole, (String)"containingConsole");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.exceptionInfoCache = exceptionInfoCache;
        this.containingConsole = containingConsole;
        this.tracker = tracker;
        this.project = this.containingConsole.getProject();
    }

    private final AppVcsInfo.ValidInfo fetchVcsInfo() {
        Object object = this.containingConsole.getClientProperty(KeysKt.getVCS_INFO_OF_SELECTED_CRASH());
        return object instanceof AppVcsInfo.ValidInfo ? (AppVcsInfo.ValidInfo)object : null;
    }

    private final Connection fetchAssociatedConnection() {
        Object object = this.containingConsole.getClientProperty(KeysKt.getCONNECTION_OF_SELECTED_CRASH());
        return object instanceof Connection ? (Connection)object : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ContextDataForDiff createContextDataForDiff(AppVcsInfo.ValidInfo appVcsInfo, List<? extends VirtualFile> virtualFiles, int lineNumber) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = appVcsInfo.getRepoInfo();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RepoInfo it = (RepoInfo)element$iv;
                boolean bl = false;
                if (!(VcsUtilsKt.locateRepository(it, this.project) != null)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        RepoInfo repoInfo = v0;
        if (repoInfo == null) {
            return null;
        }
        RepoInfo firstVcsInfo = repoInfo;
        Iterable iterable = virtualFiles;
        boolean $i$f$mapNotNull = false;
        void $i$f$firstOrNull = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ContextDataForDiff it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile vFile = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((VcsUtilsKt.getVcsManager(vFile, this.project) == null ? null : new ContextDataForDiff(firstVcsInfo.getVcsKey(), firstVcsInfo.getRevision(), VcsUtilsKt.toVcsFilePath(vFile), lineNumber, this.fetchAssociatedConnection())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (ContextDataForDiff)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        AppVcsInfo.ValidInfo validInfo = this.fetchVcsInfo();
        if (validInfo == null) {
            return null;
        }
        AppVcsInfo.ValidInfo foundVcsInfo = validInfo;
        ExceptionWorker.ParsedLine parsedLine = ExceptionWorker.parseExceptionLine((String)line);
        if (parsedLine == null) {
            return null;
        }
        ExceptionWorker.ParsedLine parsedLineInfo = parsedLine;
        Integer n = parsedLineInfo.lineNumber;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it < 1) ? n : null;
        if (n2 == null) {
            return null;
        }
        int lineNumber = n2;
        String string = parsedLineInfo.classFqnRange.substring(line);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String className = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String fileName = parsedLineInfo.fileName;
        ExceptionInfoCache.ClassResolveInfo resolvedInfo = this.exceptionInfoCache.resolveClassOrFile(className, fileName);
        if (resolvedInfo.isInLibrary() || resolvedInfo.getClasses().isEmpty()) {
            return null;
        }
        ContextDataForDiff contextDataForDiff = this.createContextDataForDiff(foundVcsInfo, CollectionsKt.toList((Iterable)resolvedInfo.getClasses().keySet()), lineNumber);
        if (contextDataForDiff == null) {
            return null;
        }
        ContextDataForDiff contextDataForDiff2 = contextDataForDiff;
        int textStartOffset = textEndOffset - line.length();
        int highlightStartOffset = textStartOffset + parsedLineInfo.fileLineRange.getStartOffset();
        int highlightEndOffset = textStartOffset + parsedLineInfo.fileLineRange.getEndOffset();
        DiffLinkInlayResult diffLinkInlayResult = new DiffLinkInlayResult(contextDataForDiff2, highlightStartOffset, highlightEndOffset, this.tracker);
        return new Filter.Result(CollectionsKt.listOf((Object)((Object)diffLinkInlayResult)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/insights/ui/vcs/InsightsAttachInlayDiffLinkFilter$Companion;", "", "<init>", "()V", "INLAY_DIFF_LINK_DISPLAY_TEXT", "", "TOOLTIP_TEXT", "intellij.android.app-quality-insights.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\t\u0010\u0015\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c2\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/insights/ui/vcs/InsightsAttachInlayDiffLinkFilter$DiffLinkInlayResult;", "Lcom/intellij/execution/filters/Filter$ResultItem;", "Lcom/intellij/execution/impl/InlayProvider;", "diffContextData", "Lcom/android/tools/idea/insights/ui/vcs/ContextDataForDiff;", "highlightStartOffset", "", "highlightEndOffset", "tracker", "Lcom/android/tools/idea/insights/analytics/AppInsightsTracker;", "<init>", "(Lcom/android/tools/idea/insights/ui/vcs/ContextDataForDiff;IILcom/android/tools/idea/insights/analytics/AppInsightsTracker;)V", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createInlayPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "logActivity", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.android.app-quality-insights.ui"})
    public static final class DiffLinkInlayResult
    extends Filter.ResultItem
    implements InlayProvider {
        @NotNull
        private final ContextDataForDiff diffContextData;
        private final int highlightStartOffset;
        private final int highlightEndOffset;
        @NotNull
        private final AppInsightsTracker tracker;

        public DiffLinkInlayResult(@NotNull ContextDataForDiff diffContextData, int highlightStartOffset, int highlightEndOffset, @NotNull AppInsightsTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)diffContextData, (String)"diffContextData");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            super(highlightStartOffset, highlightEndOffset, null);
            this.diffContextData = diffContextData;
            this.highlightStartOffset = highlightStartOffset;
            this.highlightEndOffset = highlightEndOffset;
            this.tracker = tracker;
        }

        @NotNull
        public EditorCustomElementRenderer createInlayRenderer(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            PresentationFactory factory2 = new PresentationFactory((Editor)((EditorImpl)editor));
            InlayPresentation inlayPresentation = this.createInlayPresentation(factory2, editor);
            return (EditorCustomElementRenderer)new PresentationRenderer(inlayPresentation);
        }

        private final InlayPresentation createInlayPresentation(PresentationFactory $this$createInlayPresentation, Editor editor) {
            HelpTooltip helpTooltip;
            TextAttributesKey textAttributesKey = CodeInsightColors.HYPERLINK_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"HYPERLINK_ATTRIBUTES");
            InsightsTextInlayPresentation commaInlay = new InsightsTextInlayPresentation(", ", textAttributesKey, false, editor);
            HelpTooltip $this$createInlayPresentation_u24lambda_u241 = helpTooltip = new HelpTooltip();
            boolean bl = false;
            $this$createInlayPresentation_u24lambda_u241.setDescription(InsightsAttachInlayDiffLinkFilter.TOOLTIP_TEXT);
            $this$createInlayPresentation_u24lambda_u241.setLink("", DiffLinkInlayResult::createInlayPresentation$lambda$1$lambda$0);
            $this$createInlayPresentation_u24lambda_u241.setBrowserLink("More info", new URL("https://d.android.com/studio/releases/past-releases/as-iguana-release-notes#aqi-vcs"));
            HelpTooltip showDiffTooltip = helpTooltip;
            TextAttributesKey textAttributesKey2 = CodeInsightColors.HYPERLINK_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"HYPERLINK_ATTRIBUTES");
            InlayPresentation showDiffInlay = InlayPresentationUtilsKt.withTooltip(InlayPresentationUtilsKt.withHandCursor(InlayPresentationUtilsKt.withOnClick((InlayPresentation)new InsightsTextInlayPresentation(InsightsAttachInlayDiffLinkFilter.INLAY_DIFF_LINK_DISPLAY_TEXT, textAttributesKey2, true, editor), $this$createInlayPresentation, (Function2<? super MouseEvent, ? super Point, Unit>)((Function2)(arg_0, arg_1) -> DiffLinkInlayResult.createInlayPresentation$lambda$2(editor, this, arg_0, arg_1))), editor), showDiffTooltip, $this$createInlayPresentation);
            InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{commaInlay, showDiffInlay};
            return $this$createInlayPresentation.seq(inlayPresentationArray);
        }

        private final void logActivity() {
            AppQualityInsightsUsageEvent.AppQualityInsightsStacktraceDetails.Builder builder;
            AppQualityInsightsUsageEvent.AppQualityInsightsStacktraceDetails.Builder $this$logActivity_u24lambda_u243 = builder = AppQualityInsightsUsageEvent.AppQualityInsightsStacktraceDetails.newBuilder();
            boolean bl = false;
            $this$logActivity_u24lambda_u243.setClickLocation(AppQualityInsightsUsageEvent.AppQualityInsightsStacktraceDetails.ClickLocation.DIFF_INLAY);
            AppQualityInsightsUsageEvent.AppQualityInsightsStacktraceDetails.Builder metricsEventBuilder = builder;
            AppQualityInsightsUsageEvent.AppQualityInsightsStacktraceDetails appQualityInsightsStacktraceDetails = metricsEventBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)appQualityInsightsStacktraceDetails, (String)"build(...)");
            this.tracker.logStacktraceClicked(null, appQualityInsightsStacktraceDetails);
        }

        private final ContextDataForDiff component1() {
            return this.diffContextData;
        }

        private final int component2() {
            return this.highlightStartOffset;
        }

        private final int component3() {
            return this.highlightEndOffset;
        }

        private final AppInsightsTracker component4() {
            return this.tracker;
        }

        @NotNull
        public final DiffLinkInlayResult copy(@NotNull ContextDataForDiff diffContextData, int highlightStartOffset, int highlightEndOffset, @NotNull AppInsightsTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)diffContextData, (String)"diffContextData");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            return new DiffLinkInlayResult(diffContextData, highlightStartOffset, highlightEndOffset, tracker);
        }

        public static /* synthetic */ DiffLinkInlayResult copy$default(DiffLinkInlayResult diffLinkInlayResult, ContextDataForDiff contextDataForDiff, int n, int n2, AppInsightsTracker appInsightsTracker, int n3, Object object) {
            if ((n3 & 1) != 0) {
                contextDataForDiff = diffLinkInlayResult.diffContextData;
            }
            if ((n3 & 2) != 0) {
                n = diffLinkInlayResult.highlightStartOffset;
            }
            if ((n3 & 4) != 0) {
                n2 = diffLinkInlayResult.highlightEndOffset;
            }
            if ((n3 & 8) != 0) {
                appInsightsTracker = diffLinkInlayResult.tracker;
            }
            return diffLinkInlayResult.copy(contextDataForDiff, n, n2, appInsightsTracker);
        }

        @NotNull
        public String toString() {
            return "DiffLinkInlayResult(diffContextData=" + this.diffContextData + ", highlightStartOffset=" + this.highlightStartOffset + ", highlightEndOffset=" + this.highlightEndOffset + ", tracker=" + this.tracker + ")";
        }

        public int hashCode() {
            int result2 = this.diffContextData.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.highlightStartOffset);
            result2 = result2 * 31 + Integer.hashCode(this.highlightEndOffset);
            result2 = result2 * 31 + this.tracker.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiffLinkInlayResult)) {
                return false;
            }
            DiffLinkInlayResult diffLinkInlayResult = (DiffLinkInlayResult)((Object)other);
            if (!Intrinsics.areEqual((Object)this.diffContextData, (Object)diffLinkInlayResult.diffContextData)) {
                return false;
            }
            if (this.highlightStartOffset != diffLinkInlayResult.highlightStartOffset) {
                return false;
            }
            if (this.highlightEndOffset != diffLinkInlayResult.highlightEndOffset) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tracker, (Object)diffLinkInlayResult.tracker);
        }

        private static final void createInlayPresentation$lambda$1$lambda$0() {
        }

        private static final Unit createInlayPresentation$lambda$2(Editor $editor, DiffLinkInlayResult this$0, MouseEvent mouseEvent, Point point) {
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
            Project project = $editor.getProject();
            if (project == null) {
                return Unit.INSTANCE;
            }
            Project project2 = project;
            JumpToDiffUtilsKt.goToDiff(this$0.diffContextData, project2);
            this$0.logActivity();
            return Unit.INSTANCE;
        }
    }
}

