/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/insights/TimeIntervalFilter;", "", "numDays", "", "displayString", "", "<init>", "(Ljava/lang/String;IJLjava/lang/String;)V", "getNumDays", "()J", "ONE_DAY", "SEVEN_DAYS", "FOURTEEN_DAYS", "TWENTY_EIGHT_DAYS", "THIRTY_DAYS", "SIXTY_DAYS", "NINETY_DAYS", "toString", "asMillisFromNow", "Lkotlin/Pair;", "intellij.android.app-quality-insights.api"})
public final class TimeIntervalFilter
extends Enum<TimeIntervalFilter> {
    private final long numDays;
    @NotNull
    private final String displayString;
    public static final /* enum */ TimeIntervalFilter ONE_DAY = new TimeIntervalFilter(1L, "Last 24 hours");
    public static final /* enum */ TimeIntervalFilter SEVEN_DAYS = new TimeIntervalFilter(7L, "Last 7 days");
    public static final /* enum */ TimeIntervalFilter FOURTEEN_DAYS = new TimeIntervalFilter(14L, "Last 14 days");
    public static final /* enum */ TimeIntervalFilter TWENTY_EIGHT_DAYS = new TimeIntervalFilter(28L, "Last 28 days");
    public static final /* enum */ TimeIntervalFilter THIRTY_DAYS = new TimeIntervalFilter(30L, "Last 30 days");
    public static final /* enum */ TimeIntervalFilter SIXTY_DAYS = new TimeIntervalFilter(60L, "Last 60 days");
    public static final /* enum */ TimeIntervalFilter NINETY_DAYS = new TimeIntervalFilter(90L, "Last 90 days");
    private static final /* synthetic */ TimeIntervalFilter[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private TimeIntervalFilter(long numDays, String displayString) {
        this.numDays = numDays;
        this.displayString = displayString;
    }

    public final long getNumDays() {
        return this.numDays;
    }

    @NotNull
    public String toString() {
        return this.displayString;
    }

    @NotNull
    public final Pair<Long, Long> asMillisFromNow() {
        Instant endOfRange = Instant.now();
        Instant startOfRange = endOfRange.minus(this.numDays, ChronoUnit.DAYS);
        return TuplesKt.to((Object)startOfRange.toEpochMilli(), (Object)endOfRange.toEpochMilli());
    }

    public static TimeIntervalFilter[] values() {
        return (TimeIntervalFilter[])$VALUES.clone();
    }

    public static TimeIntervalFilter valueOf(String value2) {
        return Enum.valueOf(TimeIntervalFilter.class, value2);
    }

    @NotNull
    public static EnumEntries<TimeIntervalFilter> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = timeIntervalFilterArray = new TimeIntervalFilter[]{TimeIntervalFilter.ONE_DAY, TimeIntervalFilter.SEVEN_DAYS, TimeIntervalFilter.FOURTEEN_DAYS, TimeIntervalFilter.TWENTY_EIGHT_DAYS, TimeIntervalFilter.THIRTY_DAYS, TimeIntervalFilter.SIXTY_DAYS, TimeIntervalFilter.NINETY_DAYS};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

