/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AgpVersions;
import com.android.tools.idea.gradle.util.CompatibleGradleVersion;
import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u001cJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/gradle/util/GradleWrapper;", "", "propertiesFilePath", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/io/File;Lcom/intellij/openapi/project/Project;)V", "getPropertiesFilePath", "()Ljava/io/File;", "propertiesFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPropertiesFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "gradleVersion", "", "getGradleVersion", "()Ljava/lang/String;", "distributionUrl", "getDistributionUrl", "properties", "Ljava/util/Properties;", "getProperties", "()Ljava/util/Properties;", "updateDistributionUrlAndDisplayFailure", "", "gradleVersionString", "updateDistributionUrl", "Lorg/gradle/util/GradleVersion;", "gradleDistribution", "getUpdatedDistributionUrl", "binOnlyIfCurrentlyUnknown", "Companion", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleWrapper.kt\ncom/android/tools/idea/gradle/util/GradleWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
public final class GradleWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File propertiesFilePath;
    @Nullable
    private final Project project;
    @NotNull
    private static final String GRADLEW_PROPERTIES_PATH;
    @NotNull
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN;

    private GradleWrapper(File propertiesFilePath, Project project) {
        this.propertiesFilePath = propertiesFilePath;
        this.project = project;
    }

    @NotNull
    public final File getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    @Nullable
    public final VirtualFile getPropertiesFile() {
        return VfsUtil.findFileByIoFile((File)this.propertiesFilePath, (boolean)true);
    }

    @Nullable
    public final String getGradleVersion() {
        String url = this.getDistributionUrl();
        return Companion.getGradleVersion(url);
    }

    @Nullable
    public final String getDistributionUrl() {
        return this.getProperties().getProperty("distributionUrl");
    }

    private final Properties getProperties() {
        Properties properties = PropertiesFiles.getProperties(this.propertiesFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        return properties;
    }

    public final boolean updateDistributionUrlAndDisplayFailure(@NotNull String gradleVersionString) {
        Intrinsics.checkNotNullParameter((Object)gradleVersionString, (String)"gradleVersionString");
        try {
            GradleVersion gradleVersion2 = GradleVersion.version((String)gradleVersionString);
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"version(...)");
            boolean updated = this.updateDistributionUrl(gradleVersion2);
            if (updated) {
                return true;
            }
        }
        catch (IOException e) {
            StringBuilder $this$updateDistributionUrlAndDisplayFailure_u24lambda_u240 = new StringBuilder();
            boolean bl = false;
            $this$updateDistributionUrlAndDisplayFailure_u24lambda_u240.append("Unable to update Gradle wrapper to use Gradle " + gradleVersionString).append('\n');
            $this$updateDistributionUrlAndDisplayFailure_u24lambda_u240.append(e.getMessage()).append('\n');
            String string = $this$updateDistributionUrlAndDisplayFailure_u24lambda_u240.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String message = string;
            Messages.showErrorDialog((Project)this.project, (String)message, (String)"Unexpected Error");
        }
        catch (IllegalArgumentException e) {
            StringBuilder $this$updateDistributionUrlAndDisplayFailure_u24lambda_u241 = new StringBuilder();
            boolean bl = false;
            $this$updateDistributionUrlAndDisplayFailure_u24lambda_u241.append("Invalid Gradle version " + gradleVersionString).append('\n');
            $this$updateDistributionUrlAndDisplayFailure_u24lambda_u241.append(e.getMessage()).append('\n');
            String string = $this$updateDistributionUrlAndDisplayFailure_u24lambda_u241.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String message = string;
            Messages.showErrorDialog((Project)this.project, (String)message, (String)"Invalid Gradle Version");
        }
        return false;
    }

    public final boolean updateDistributionUrl(@NotNull GradleVersion gradleVersion2) {
        String property2;
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        String string = property2 = this.getDistributionUrl();
        boolean isUsingSourceAndDocsDistribution = string != null ? StringsKt.endsWith$default((String)string, (String)"-all.zip", (boolean)false, (int)2, null) : false;
        String distributionUrl = Companion.getDistributionUrl(gradleVersion2, !isUsingSourceAndDocsDistribution);
        if (property2 != null && Intrinsics.areEqual((Object)property2, (Object)distributionUrl)) {
            return false;
        }
        Properties properties = this.getProperties();
        properties.setProperty("distributionUrl", distributionUrl);
        GradleWrapper.Companion.saveProperties(properties, this.propertiesFilePath, this.project);
        return true;
    }

    public final boolean updateDistributionUrl(@NotNull File gradleDistribution) {
        Intrinsics.checkNotNullParameter((Object)gradleDistribution, (String)"gradleDistribution");
        String path = gradleDistribution.getPath();
        if (!FileUtilRt.extensionEquals((String)path, (String)"zip")) {
            boolean bl = false;
            String string = "'" + path + "' should be a zip file";
            throw new IllegalArgumentException(string.toString());
        }
        Properties properties = this.getProperties();
        properties.setProperty("distributionUrl", gradleDistribution.toURI().toURL().toString());
        GradleWrapper.Companion.saveProperties(properties, this.propertiesFilePath, this.project);
        return true;
    }

    @NotNull
    public final String getUpdatedDistributionUrl(@NotNull GradleVersion gradleVersion2, boolean binOnlyIfCurrentlyUnknown) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        String current = this.getDistributionUrl();
        return Companion.getUpdatedDistributionUrl(current, gradleVersion2, binOnlyIfCurrentlyUnknown);
    }

    @JvmStatic
    @Nullable
    public static final GradleWrapper find(@NotNull Project project) {
        return Companion.find(project);
    }

    @JvmStatic
    @NotNull
    public static final GradleWrapper get(@NotNull File propertiesFilePath, @Nullable Project project) {
        return Companion.get(propertiesFilePath, project);
    }

    @JvmStatic
    @NotNull
    public static final GradleWrapper create(@NotNull File projectPath, @Nullable Project project) {
        return Companion.create(projectPath, project);
    }

    @JvmStatic
    @NotNull
    public static final GradleWrapper create(@NotNull File projectPath, @NotNull GradleVersion gradleVersion2, @Nullable Project project) {
        return Companion.create(projectPath, gradleVersion2, project);
    }

    @JvmStatic
    @NotNull
    public static final File getDefaultPropertiesFilePath(@NotNull File projectPath) {
        return Companion.getDefaultPropertiesFilePath(projectPath);
    }

    @NotNull
    public static final GradleVersion getGradleVersionToUse() {
        return Companion.getGradleVersionToUse();
    }

    @JvmStatic
    @NotNull
    public static final String getDistributionUrl(@NotNull GradleVersion gradleVersion2, boolean useBinaryOnlyDistribution) {
        return Companion.getDistributionUrl(gradleVersion2, useBinaryOnlyDistribution);
    }

    public /* synthetic */ GradleWrapper(File propertiesFilePath, Project project, DefaultConstructorMarker $constructor_marker) {
        this(propertiesFilePath, project);
    }

    static {
        String[] stringArray = new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        GRADLEW_PROPERTIES_PATH = string;
        Pattern pattern = Pattern.compile(".*/gradle-([^-]+)(-[^\\/\\\\]+)?-(bin|all).zip");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        GRADLE_DISTRIBUTION_URL_PATTERN = pattern;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u001a\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\"\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0007J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u0005J \u0010#\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020%H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00128FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lcom/android/tools/idea/gradle/util/GradleWrapper$Companion;", "", "<init>", "()V", "GRADLEW_PROPERTIES_PATH", "", "GRADLE_DISTRIBUTION_URL_PATTERN", "Ljava/util/regex/Pattern;", "find", "Lcom/android/tools/idea/gradle/util/GradleWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "get", "propertiesFilePath", "Ljava/io/File;", "create", "projectPath", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "Lcom/intellij/openapi/vfs/VirtualFile;", "wrapperLocation", "getWrapperLocation", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getDefaultPropertiesFilePath", "gradleVersionToUse", "getGradleVersionToUse$annotations", "getGradleVersionToUse", "()Lorg/gradle/util/GradleVersion;", "saveProperties", "", "properties", "Ljava/util/Properties;", "file", "getGradleVersion", "url", "getUpdatedDistributionUrl", "binOnlyIfCurrentlyUnknown", "", "getDistributionUrl", "useBinaryOnlyDistribution", "intellij.android.projectSystem.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleWrapper.kt\ncom/android/tools/idea/gradle/util/GradleWrapper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final GradleWrapper find(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = project.getBasePath();
            if (string == null) {
                return null;
            }
            String basePath = string;
            File baseDir2 = new File(basePath);
            File propertiesFilePath = this.getDefaultPropertiesFilePath(baseDir2);
            return propertiesFilePath.isFile() ? new GradleWrapper(propertiesFilePath, project, null) : null;
        }

        @JvmStatic
        @NotNull
        public final GradleWrapper get(@NotNull File propertiesFilePath, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)propertiesFilePath, (String)"propertiesFilePath");
            return new GradleWrapper(propertiesFilePath, project, null);
        }

        @JvmStatic
        @NotNull
        public final GradleWrapper create(@NotNull File projectPath, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return this.create(projectPath, this.getGradleVersionToUse(), project);
        }

        @JvmStatic
        @NotNull
        public final GradleWrapper create(@NotNull File projectPath, @NotNull GradleVersion gradleVersion2, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)projectPath, (boolean)true);
            if (virtualFile == null) {
                throw new IOException("Not existent project path: " + projectPath);
            }
            VirtualFile projectDirVirtualFile = virtualFile;
            return this.create(projectDirVirtualFile, gradleVersion2, project);
        }

        @NotNull
        public final GradleWrapper create(@NotNull VirtualFile projectPath, @NotNull GradleVersion gradleVersion2, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            WriteAction.computeAndWait(() -> Companion.create$lambda$1(projectPath));
            File propertiesFilePath = this.getDefaultPropertiesFilePath(new File(projectPath.getPath()));
            GradleWrapper gradleWrapper = this.get(propertiesFilePath, project);
            gradleWrapper.updateDistributionUrl(gradleVersion2);
            return gradleWrapper;
        }

        private final VirtualFile getWrapperLocation() {
            File resource = new File("templates/project/wrapper");
            String string = resource.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String resourceName = "/" + StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            URL wrapperUrl = Resources.getResource(GradleWrapper.class, (String)resourceName);
            VirtualFile virtualFile = VfsUtil.findFileByURL((URL)wrapperUrl);
            if (virtualFile == null) {
                boolean bl = false;
                String string2 = "Wrapper URL not found: " + wrapperUrl;
                throw new IllegalStateException(string2.toString());
            }
            VirtualFile wrapperVf = virtualFile;
            wrapperVf.refresh(false, true);
            return wrapperVf;
        }

        @JvmStatic
        @NotNull
        public final File getDefaultPropertiesFilePath(@NotNull File projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return new File(projectPath, GRADLEW_PROPERTIES_PATH);
        }

        @NotNull
        public final GradleVersion getGradleVersionToUse() {
            return CompatibleGradleVersion.Companion.getCompatibleGradleVersion(AgpVersions.getNewProject()).getVersion();
        }

        @JvmStatic
        public static /* synthetic */ void getGradleVersionToUse$annotations() {
        }

        private final void saveProperties(Properties properties, File file, Project project) {
            PropertiesFiles.savePropertiesToFile(properties, file, null);
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
            if (virtualFile != null) {
                virtualFile.refresh(false, false);
                if (project != null) {
                    Document document;
                    PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                    PsiFile psiFile = PsiManagerEx.getInstanceEx((Project)project).findFile(virtualFile);
                    if (psiFile != null && (document = manager.getDocument(psiFile)) != null) {
                        Application app = ApplicationManager.getApplication();
                        app.invokeAndWait(() -> Companion.saveProperties$lambda$4(app, manager, document));
                    }
                }
            }
        }

        @Nullable
        public final String getGradleVersion(@Nullable String url) {
            if (url == null) {
                return null;
            }
            Matcher m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url);
            if (m.matches()) {
                return m.group(1) + Strings.nullToEmpty((String)m.group(2));
            }
            return null;
        }

        @NotNull
        public final String getUpdatedDistributionUrl(@Nullable String url, @NotNull GradleVersion gradleVersion2, boolean binOnlyIfCurrentlyUnknown) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            if (url == null) {
                return this.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
            }
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)"://services.gradle.org/", (boolean)false, (int)2, null)) {
                Matcher matcher = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url);
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
                Matcher m = matcher;
                return m.matches() ? this.getDistributionUrl(gradleVersion2, Intrinsics.areEqual((Object)"bin", (Object)m.group(3))) : this.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
            }
            Matcher m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url);
            if (m.matches()) {
                StringBuilder sb = new StringBuilder();
                sb.append(url, 0, m.start(1));
                sb.append(gradleVersion2.getVersion());
                sb.append(url, m.end(2) == -1 ? m.end(1) : m.end(2), url.length());
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            return this.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
        }

        @JvmStatic
        @NotNull
        public final String getDistributionUrl(@NotNull GradleVersion gradleVersion2, boolean useBinaryOnlyDistribution) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
            String suffix = useBinaryOnlyDistribution ? "bin" : "all";
            String string = "gradle-%1$s-%2$s.zip";
            Object[] objectArray = new Object[]{gradleVersion2.getVersion(), suffix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String filename = string2;
            String localDistributionUrl = (String)StudioFlags.GRADLE_LOCAL_DISTRIBUTION_URL.get();
            Intrinsics.checkNotNull((Object)localDistributionUrl);
            if (!(((CharSequence)localDistributionUrl).length() == 0)) {
                return localDistributionUrl + filename;
            }
            String folderName = gradleVersion2.isSnapshot() ? "distributions-snapshots" : "distributions";
            String string3 = "https://services.gradle.org/%1$s/%2$s";
            Object[] objectArray2 = new Object[]{folderName, filename};
            String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            return string4;
        }

        private static final boolean create$lambda$1$lambda$0(VirtualFile $projectPath, String $sourceRootUrl, VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            String string2 = string;
            int n = $sourceRootUrl.length();
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return $projectPath.findFileByRelativePath(string3) == null;
        }

        private static final Object create$lambda$1(VirtualFile $projectPath) {
            if ($projectPath.findFileByRelativePath(SdkConstants.FD_GRADLE_WRAPPER) == null) {
                boolean madeExecutable;
                VirtualFile wrapperVf = Companion.getWrapperLocation();
                String string = wrapperVf.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                String sourceRootUrl = string;
                VfsUtil.copyDirectory(GradleWrapper.class, (VirtualFile)wrapperVf, (VirtualFile)$projectPath, arg_0 -> Companion.create$lambda$1$lambda$0($projectPath, sourceRootUrl, arg_0));
                VirtualFile gradlewDestination = $projectPath.findChild("gradlew");
                boolean bl = madeExecutable = gradlewDestination != null && new File(gradlewDestination.getPath()).setExecutable(true);
                if (!madeExecutable) {
                    Logger.getInstance(GradleWrapper.class).warn("Unable to make gradlew executable");
                }
            }
            return null;
        }

        private static final void saveProperties$lambda$4$lambda$3(PsiDocumentManager $manager, Document $document) {
            $manager.commitDocument($document);
        }

        private static final void saveProperties$lambda$4(Application $app, PsiDocumentManager $manager, Document $document) {
            $app.runWriteAction(() -> Companion.saveProperties$lambda$4$lambda$3($manager, $document));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

