/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.utils.FileUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class BuildFileProcessor {
    public static void processRecursively(@NotNull Project project, @NotNull Processor<? super GradleSettingsModel> settingsProcessor, @NotNull Processor<? super GradleBuildModel> buildProcessor) {
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile projectRootFolder = ProjectUtil.guessProjectDir((Project)project);
            if (projectRootFolder == null) {
                return;
            }
            ProjectBuildModel projectBuildModel = ProjectBuildModel.getOrLog(project);
            if (projectBuildModel == null) {
                return;
            }
            GradleSettingsModel settings = GradleBuildModel.tryOrLog(() -> projectBuildModel.getProjectSettingsModel());
            if (settings == null) {
                return;
            }
            boolean continueProcessing = settingsProcessor.process((Object)settings);
            if (!continueProcessing) {
                return;
            }
            for (String path : settings.modulePaths()) {
                GradleBuildModel buildModel = GradleBuildModel.tryOrLog(() -> settings.moduleModel(path));
                if (buildModel == null || (continueProcessing = buildProcessor.process((Object)buildModel))) continue;
                return;
            }
        });
    }

    @NotNull
    public static List<File> getCompositeBuildFolderPaths(@NotNull Project project) {
        String projectBasePath = project.getBasePath();
        if (StringUtil.isEmpty((String)projectBasePath)) {
            return Collections.emptyList();
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectBasePath);
        if (projectSettings == null) {
            return Collections.emptyList();
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return Collections.emptyList();
        }
        return compositeBuild.getCompositeParticipants().stream().map(p -> new File(FileUtils.toSystemDependentPath((String)p.getRootPath()))).collect(Collectors.toList());
    }
}

