/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.model.PsModelNameComparator;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import kotlin.Unit;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;

class ModuleDependenciesForm {
    @NotNull
    private final CheckboxTree myPossibleDependenciesTree;
    @NotNull
    private final Set<PsModule> mySelectedModules = Sets.newHashSet();
    private JPanel myMainPanel;
    private JBScrollPane myModulesScrollPane;
    private JXLabel myModulesLabel;

    ModuleDependenciesForm(@NotNull PsModule module) {
        this.setupUI();
        this.myModulesLabel.setBorder((Border)BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), JBUI.Borders.empty((int)2)));
        this.myModulesLabel.setBackground(UIUtil.getTextFieldBackground());
        this.myModulesLabel.setText(" ");
        CheckboxTree.CheckboxTreeCellRenderer cellRenderer2 = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object data2;
                if (value2 instanceof DefaultMutableTreeNode && (data2 = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof PsModule) {
                    PsModule m = (PsModule)data2;
                    ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                    textRenderer.setIcon(m.getIcon());
                    textRenderer.append(m.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        };
        CheckedTreeNode root = new CheckedTreeNode(null);
        List<PsModule> modules = ModuleDependenciesForm.findAvailableModules(module);
        Collections.sort(modules, new PsModelNameComparator());
        modules.forEach(m -> {
            CheckedTreeNode node = new CheckedTreeNode(m);
            node.setChecked(false);
            root.add((MutableTreeNode)node);
        });
        this.myPossibleDependenciesTree = new CheckboxTree(cellRenderer2, root);
        this.myPossibleDependenciesTree.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                Object data2 = node.getUserObject();
                if (data2 instanceof PsModule) {
                    PsModule m = (PsModule)data2;
                    if (node.isChecked()) {
                        ModuleDependenciesForm.this.mySelectedModules.add(m);
                    } else {
                        ModuleDependenciesForm.this.mySelectedModules.remove(m);
                    }
                    Object[] selectedModules = (PsModule[])ModuleDependenciesForm.this.myPossibleDependenciesTree.getCheckedNodes(PsModule.class, null);
                    Arrays.sort(selectedModules, new PsModelNameComparator());
                    String names = Joiner.on((String)", ").join(selectedModules);
                    if (names.isEmpty()) {
                        names = " ";
                    }
                    ModuleDependenciesForm.this.myModulesLabel.setText(names);
                }
            }
        });
        this.myModulesScrollPane.setViewportView((Component)this.myPossibleDependenciesTree);
    }

    private void setupUI() {
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myModulesScrollPane = new JBScrollPane();
        this.myMainPanel.add((Component)this.myModulesScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Modules:");
        this.myMainPanel.add((Component)jBLabel1, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myModulesLabel = new JXLabel();
        this.myMainPanel.add((Component)this.myModulesLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
    }

    @NotNull
    private static List<PsModule> findAvailableModules(@NotNull PsModule module) {
        ArrayList<PsModule> modules = new ArrayList<PsModule>();
        List<PsModule> dependencies2 = ModuleDependenciesForm.getModuleDependencies(module);
        module.getParent().forEachModule(m -> {
            if (module != m && !dependencies2.contains(m) && module.canDependOn((PsModule)m)) {
                modules.add((PsModule)m);
            }
        });
        return modules;
    }

    @NotNull
    private static List<PsModule> getModuleDependencies(@NotNull PsModule module) {
        PsProject project = module.getParent();
        ArrayList<PsModule> dependencies2 = new ArrayList<PsModule>();
        if (module instanceof PsAndroidModule) {
            ((PsAndroidModule)module).getDependencies().forEachModuleDependency(dependency -> {
                String name2 = dependency.getName();
                PsModule found = project.findModuleByName(name2);
                if (found != null) {
                    dependencies2.add(found);
                }
                return Unit.INSTANCE;
            });
        }
        return dependencies2;
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        return this.myPossibleDependenciesTree;
    }

    @NotNull
    JPanel getPanel() {
        return this.myMainPanel;
    }

    @NotNull
    List<PsModule> getSelectedModules() {
        return Lists.newArrayList(this.mySelectedModules);
    }

    JComponent getModulesLabel() {
        return this.myModulesLabel;
    }
}

