/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssueRenderer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueKt;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsPathKt;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/issues/DependencyViewIssueRenderer;", "Lcom/android/tools/idea/gradle/structure/configurables/issues/IssueRenderer;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "renderDescription", "", "<init>", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Z)V", "renderIssue", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "issue", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "scope", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nDependencyViewIssueRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyViewIssueRenderer.kt\ncom/android/tools/idea/gradle/structure/configurables/issues/DependencyViewIssueRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n967#2,7:53\n1869#2,2:60\n1869#2,2:62\n*S KotlinDebug\n*F\n+ 1 DependencyViewIssueRenderer.kt\ncom/android/tools/idea/gradle/structure/configurables/issues/DependencyViewIssueRenderer\n*L\n31#1:53,7\n31#1:60,2\n42#1:62,2\n*E\n"})
public final class DependencyViewIssueRenderer
implements IssueRenderer {
    @NotNull
    private final PsContext context;
    private final boolean renderDescription;

    public DependencyViewIssueRenderer(@NotNull PsContext context, boolean renderDescription) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.renderDescription = renderDescription;
    }

    @Override
    public void renderIssue(@NotNull StringBuilder buffer, @NotNull PsIssue issue2, @Nullable PsPath scope) {
        String description2;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Iterable $this$takeWhile$iv = CollectionsKt.asReversed((List)CollectionsKt.plus((Collection)PsPathKt.getParents(issue2.getPath()), (Object)issue2.getPath()));
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            PsPath it = (PsPath)item$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)scope))) break;
            list$iv.add(item$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)list$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsPath parentPath = (PsPath)element$iv;
            boolean bl = false;
            String parentPathHref = parentPath.getHyperlinkDestination(this.context);
            if (parentPathHref == null) continue;
            String parentPathText = this.makeTextWrappable(parentPath.toString());
            buffer.append("<a href=\"" + parentPathHref + "\">" + parentPathText + "</a>: ");
        }
        buffer.append(issue2.getText());
        if (!((Collection)issue2.getQuickFixes()).isEmpty()) {
            buffer.append("<br/>");
        }
        $this$forEach$iv = issue2.getQuickFixes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsQuickFix quickFix = (PsQuickFix)element$iv;
            boolean bl = false;
            buffer.append(" <a href='" + PsIssueKt.getHyperlinkDestination(quickFix) + "'>[" + quickFix.getText() + "]</a>");
        }
        if (this.renderDescription && StringUtil.isNotEmpty((String)(description2 = issue2.getDescription()))) {
            buffer.append("<br/><br/>").append(description2);
        }
    }

    @Override
    @NotNull
    public String renderIssue(@NotNull PsIssue issue2, @Nullable PsPath scope) {
        return IssueRenderer.super.renderIssue(issue2, scope);
    }

    @Override
    @NotNull
    public String makeTextWrappable(@NotNull String $this$makeTextWrappable) {
        return IssueRenderer.super.makeTextWrappable($this$makeTextWrappable);
    }
}

