/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GradleBuildModelRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GradleBuildModelUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.PointNecessity;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.google.wireless.android.sdk.stats.UpgradeAssistantComponentInfo;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u000289B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u001f\u001a\u00020\u0010H$J\u0015\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%H\u0014\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\u0010H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u001d\u00100\u001a\u0002012\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%H\u0014\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\rH\u0002J\b\u00107\u001a\u00020\rH\u0002R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0012\u0010\u0015\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/AbstractBlockPropertyUnlessNoOpProcessor;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "current", "Lcom/android/ide/common/repository/AgpVersion;", "new", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/repository/AgpVersion;Lcom/android/ide/common/repository/AgpVersion;)V", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "(Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;)V", "_isPropertyAppliedCache", "", "Ljava/lang/Boolean;", "featureName", "", "getFeatureName", "()Ljava/lang/String;", "propertyKey", "getPropertyKey", "propertyRemovedVersion", "getPropertyRemovedVersion", "()Lcom/android/ide/common/repository/AgpVersion;", "noOpValue", "getNoOpValue", "()Z", "componentKind", "Lcom/google/wireless/android/sdk/stats/UpgradeAssistantComponentInfo$UpgradeAssistantComponentKind;", "getComponentKind", "()Lcom/google/wireless/android/sdk/stats/UpgradeAssistantComponentInfo$UpgradeAssistantComponentKind;", "getRefactoringId", "necessityInfo", "Lcom/android/tools/idea/gradle/project/upgrade/PointNecessity;", "getNecessityInfo", "()Lcom/android/tools/idea/gradle/project/upgrade/PointNecessity;", "findComponentUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "getCommandName", "getShortDescription", "blockProcessorReasons", "", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor$BlockReason;", "completeComponentInfo", "Lcom/google/wireless/android/sdk/stats/UpgradeAssistantComponentInfo$Builder;", "builder", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "initializeComponentExtraCaches", "", "isPropertyApplied", "isPropertyAppliedNoCache", "PropertyUsedAfterRemoval", "RemovedPropertyUsageInfo", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nBlockPropertyRefactoringProcessors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockPropertyRefactoringProcessors.kt\ncom/android/tools/idea/gradle/project/upgrade/AbstractBlockPropertyUnlessNoOpProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,375:1\n37#2:376\n36#2,3:377\n37#2:380\n36#2,3:381\n*S KotlinDebug\n*F\n+ 1 BlockPropertyRefactoringProcessors.kt\ncom/android/tools/idea/gradle/project/upgrade/AbstractBlockPropertyUnlessNoOpProcessor\n*L\n60#1:376\n60#1:377,3\n72#1:380\n72#1:381,3\n*E\n"})
public abstract class AbstractBlockPropertyUnlessNoOpProcessor
extends AgpUpgradeComponentRefactoringProcessor {
    @Nullable
    private Boolean _isPropertyAppliedCache;

    public AbstractBlockPropertyUnlessNoOpProcessor(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"new");
        super(project, current, agpVersion);
    }

    public AbstractBlockPropertyUnlessNoOpProcessor(@NotNull AgpUpgradeRefactoringProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(processor);
    }

    @NotNull
    public abstract String getFeatureName();

    @NotNull
    public abstract String getPropertyKey();

    @NotNull
    public abstract AgpVersion getPropertyRemovedVersion();

    public abstract boolean getNoOpValue();

    @NotNull
    public abstract UpgradeAssistantComponentInfo.UpgradeAssistantComponentKind getComponentKind();

    @NotNull
    protected abstract String getRefactoringId();

    @Override
    @NotNull
    public PointNecessity getNecessityInfo() {
        return new PointNecessity(this.getPropertyRemovedVersion());
    }

    @Override
    @NotNull
    protected UsageInfo[] findComponentUsages() {
        IProperty property2;
        PsiFile gradlePropertiesPsiFile;
        List usages = new ArrayList();
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.getProject());
        if (virtualFile == null) {
            Collection $this$toTypedArray$iv = usages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new UsageInfo[0]);
        }
        VirtualFile baseDir2 = virtualFile;
        VirtualFile gradlePropertiesVirtualFile = baseDir2.findChild("gradle.properties");
        if (gradlePropertiesVirtualFile != null && gradlePropertiesVirtualFile.exists() && (gradlePropertiesPsiFile = PsiManager.getInstance((Project)this.getProject()).findFile(gradlePropertiesVirtualFile)) instanceof PropertiesFile && (property2 = ((PropertiesFile)gradlePropertiesPsiFile).findPropertyByKey(this.getPropertyKey())) != null) {
            PsiElement psiElement = property2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            WrappedPsiElement wrappedPsiElement = new WrappedPsiElement(psiElement, this, null, null, 8, null);
            usages.add(new RemovedPropertyUsageInfo(wrappedPsiElement));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    @Override
    @NotNull
    public String getCommandName() {
        return "Remove " + this.getPropertyKey() + " if set to " + this.getNoOpValue();
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return StringsKt.trimIndent((String)("\n    The property " + this.getPropertyKey() + " is being removed.\n    Upgrading to AGP " + this.getPropertyRemovedVersion() + " or newer\n    will be blocked if this property is present and\n    not set to " + this.getNoOpValue() + ".\n  "));
    }

    @Override
    @NotNull
    public List<AgpUpgradeComponentRefactoringProcessor.BlockReason> blockProcessorReasons() {
        List reasons = new ArrayList();
        reasons.addAll((Collection)super.blockProcessorReasons());
        if (this.getCurrent().compareTo(this.getPropertyRemovedVersion()) < 0 && this.getNew().compareTo(this.getPropertyRemovedVersion()) >= 0 && this.isPropertyApplied()) {
            reasons.add(new PropertyUsedAfterRemoval());
        }
        return reasons;
    }

    @Override
    @NotNull
    public UpgradeAssistantComponentInfo.Builder completeComponentInfo(@NotNull UpgradeAssistantComponentInfo.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        UpgradeAssistantComponentInfo.Builder builder2 = builder.setKind(this.getComponentKind());
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setKind(...)");
        return builder2;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(this){
            final /* synthetic */ AbstractBlockPropertyUnlessNoOpProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return this.this$0.getPropertyKey() + " is being used";
            }
        };
    }

    @Override
    public void initializeComponentExtraCaches() {
        super.initializeComponentExtraCaches();
        this._isPropertyAppliedCache = this.isPropertyAppliedNoCache();
    }

    private final boolean isPropertyApplied() {
        if (this._isPropertyAppliedCache == null) {
            this._isPropertyAppliedCache = this.isPropertyAppliedNoCache();
        }
        Boolean bl = this._isPropertyAppliedCache;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    private final boolean isPropertyAppliedNoCache() {
        IProperty property2;
        PsiFile gradlePropertiesPsiFile;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.getProject());
        if (virtualFile == null) {
            return false;
        }
        VirtualFile baseDir2 = virtualFile;
        Boolean propertyValue = null;
        VirtualFile gradlePropertiesVirtualFile = baseDir2.findChild("gradle.properties");
        if (gradlePropertiesVirtualFile != null && gradlePropertiesVirtualFile.exists() && (gradlePropertiesPsiFile = PsiManager.getInstance((Project)this.getProject()).findFile(gradlePropertiesVirtualFile)) instanceof PropertiesFile && (property2 = ((PropertiesFile)gradlePropertiesPsiFile).findPropertyByKey(this.getPropertyKey())) != null) {
            propertyValue = Boolean.parseBoolean(property2.getValue());
        }
        return propertyValue != null && !Intrinsics.areEqual(propertyValue, (Object)this.getNoOpValue());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/AbstractBlockPropertyUnlessNoOpProcessor$PropertyUsedAfterRemoval;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor$BlockReason;", "<init>", "(Lcom/android/tools/idea/gradle/project/upgrade/AbstractBlockPropertyUnlessNoOpProcessor;)V", "intellij.android.projectSystem.gradle.upgrade"})
    protected final class PropertyUsedAfterRemoval
    extends AgpUpgradeComponentRefactoringProcessor.BlockReason {
        public PropertyUsedAfterRemoval() {
            super("Property " + AbstractBlockPropertyUnlessNoOpProcessor.this.getPropertyKey() + " has been removed in " + AbstractBlockPropertyUnlessNoOpProcessor.this.getPropertyRemovedVersion() + ".", "Remove it from gradle.properties and make sure your project builds correctly before continuing", null, 4, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/AbstractBlockPropertyUnlessNoOpProcessor$RemovedPropertyUsageInfo;", "Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelUsageInfo;", "wrappedElement", "Lcom/android/tools/idea/gradle/project/upgrade/WrappedPsiElement;", "<init>", "(Lcom/android/tools/idea/gradle/project/upgrade/AbstractBlockPropertyUnlessNoOpProcessor;Lcom/android/tools/idea/gradle/project/upgrade/WrappedPsiElement;)V", "getTooltipText", "", "performBuildModelRefactoring", "", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelRefactoringProcessor;", "intellij.android.projectSystem.gradle.upgrade"})
    public final class RemovedPropertyUsageInfo
    extends GradleBuildModelUsageInfo {
        @NotNull
        private final WrappedPsiElement wrappedElement;

        public RemovedPropertyUsageInfo(WrappedPsiElement wrappedElement) {
            Intrinsics.checkNotNullParameter((Object)wrappedElement, (String)"wrappedElement");
            super(wrappedElement);
            this.wrappedElement = wrappedElement;
        }

        @Override
        @NotNull
        public String getTooltipText() {
            return "This property has been removed in AGP " + AbstractBlockPropertyUnlessNoOpProcessor.this.getPropertyRemovedVersion();
        }

        @Override
        public void performBuildModelRefactoring(@NotNull GradleBuildModelRefactoringProcessor processor) {
            Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
            PsiElement realElement = this.wrappedElement.getRealElement();
            PsiElement parent = realElement.getParent();
            if (parent instanceof PropertiesList) {
                parent = ((PropertiesList)parent).getParent();
            }
            if (parent instanceof PsiFile) {
                this.getOtherAffectedFiles().add((PsiFile)parent);
            }
            realElement.delete();
            FileDocumentManager.getInstance().saveAllDocuments();
        }
    }
}

