/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.quickFixes;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/sync/quickFixes/InstallCmakeQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "cmakeVersion", "Lcom/android/repository/Revision;", "<init>", "(Lcom/android/repository/Revision;)V", "id", "", "getId", "()Ljava/lang/String;", "myCmakeVersion", "getMyCmakeVersion", "()Lcom/android/repository/Revision;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "notifyCmakePackageNotFound", "", "intellij.android.projectSystem.gradle"})
public final class InstallCmakeQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String id;
    @Nullable
    private final Revision myCmakeVersion;

    public InstallCmakeQuickFix(@Nullable Revision cmakeVersion) {
        this.id = "INSTALL_CMAKE";
        this.myCmakeVersion = cmakeVersion;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public final Revision getMyCmakeVersion() {
        return this.myCmakeVersion;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getRepoManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, "Loading Remote SDK", project, null, 8, null);
        RepoManager.RepoLoadedListener onComplete = arg_0 -> InstallCmakeQuickFix.runQuickFix$lambda$3(this, sdkHandler, progressIndicator, project, future2, arg_0);
        Runnable onError = () -> InstallCmakeQuickFix.runQuickFix$lambda$5(project, future2);
        RepoManager.load$default((RepoManager)sdkManager, (long)RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (RepoManager.RepoLoadedListener)onComplete, (Runnable)onError, (ProgressRunner)((ProgressRunner)progressRunner), (Downloader)new StudioDownloader(), (SettingsController)StudioSettingsController.getInstance(), (int)2, null);
        return future2;
    }

    private final void notifyCmakePackageNotFound(Project project) {
        if (this.myCmakeVersion == null) {
            Messages.showErrorDialog((Project)project, (String)"Failed to obtain CMake package", (String)"Gradle Sync");
        } else {
            Messages.showErrorDialog((Project)project, (String)("Failed to obtain CMake package version " + this.myCmakeVersion), (String)"Gradle Sync");
        }
    }

    private static final boolean runQuickFix$lambda$3$lambda$2$lambda$0(InstallCmakeQuickFix this$0, RemotePackage remotePackage) {
        RemotePackage remotePackage2 = remotePackage;
        Intrinsics.checkNotNull((Object)remotePackage2);
        return Intrinsics.areEqual((Object)remotePackage2.getVersion(), (Object)this$0.myCmakeVersion);
    }

    private static final boolean runQuickFix$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit runQuickFix$lambda$3$lambda$2(RepositoryPackages $packages, InstallCmakeQuickFix this$0, AndroidSdkHandler $sdkHandler, StudioLoggerProgressIndicator $progressIndicator, Project $project, CompletableFuture $future) {
        RemotePackage cmakePackage;
        Collection cmakePackages = $packages.getRemotePackagesForPrefix("cmake");
        RemotePackage remotePackage = this$0.myCmakeVersion == null ? (cmakePackages.size() == 1 ? (RemotePackage)ContainerUtil.getFirstItem((Collection)cmakePackages) : $sdkHandler.getLatestRemotePackageForPrefix("cmake", null, false, (ProgressIndicator)$progressIndicator)) : (cmakePackage = (RemotePackage)cmakePackages.stream().filter(arg_0 -> InstallCmakeQuickFix.runQuickFix$lambda$3$lambda$2$lambda$1(arg_0 -> InstallCmakeQuickFix.runQuickFix$lambda$3$lambda$2$lambda$0(this$0, arg_0), arg_0)).findFirst().orElse(null));
        if (cmakePackage != null) {
            ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths($project, (Collection<String>)((Collection)ImmutableList.of((Object)cmakePackage.getPath())), true);
            if (dialog2 != null && dialog2.showAndGet()) {
                ProjectSystemUtil.getSyncManager($project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_QF_CMAKE_INSTALLED));
            }
            $future.complete(null);
            return Unit.INSTANCE;
        }
        this$0.notifyCmakePackageNotFound($project);
        $future.complete(null);
        return Unit.INSTANCE;
    }

    private static final void runQuickFix$lambda$3(InstallCmakeQuickFix this$0, AndroidSdkHandler $sdkHandler, StudioLoggerProgressIndicator $progressIndicator, Project $project, CompletableFuture $future, RepositoryPackages packages) {
        Intrinsics.checkNotNullParameter((Object)packages, (String)"packages");
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> InstallCmakeQuickFix.runQuickFix$lambda$3$lambda$2(packages, this$0, $sdkHandler, $progressIndicator, $project, $future));
    }

    private static final Unit runQuickFix$lambda$5$lambda$4(Project $project, CompletableFuture $future) {
        Messages.showErrorDialog((Project)$project, (String)"Failed to install CMake package", (String)"Gradle Sync");
        $future.complete(null);
        return Unit.INSTANCE;
    }

    private static final void runQuickFix$lambda$5(Project $project, CompletableFuture $future) {
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> InstallCmakeQuickFix.runQuickFix$lambda$5$lambda$4($project, $future));
    }
}

