/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetType;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class NdkModuleModelDataService
extends ModuleModelDataService<NdkModuleModel> {
    @NotNull
    public Key<NdkModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.NDK_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<? extends DataNode<NdkModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, DataNode<NdkModuleModel>> modelsByModuleName) {
        for (Module module : modelsProvider.getModules()) {
            DataNode<NdkModuleModel> ndkModuleModelNode = modelsByModuleName.get(module.getName());
            if (ndkModuleModelNode == null) continue;
            NdkFacet facet = Facets.findFacet(module, modelsProvider, NdkFacet.getFacetTypeId());
            if (facet == null) {
                ModifiableFacetModel model = modelsProvider.getModifiableFacetModel(module);
                NdkFacetType facetType = NdkFacet.getFacetType();
                facet = facetType.createFacet(module, NdkFacet.getFacetName(), facetType.createDefaultConfiguration(), (Facet)null);
                model.addFacet((Facet)facet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
            }
            facet.setNdkModuleModel((NdkModuleModel)ndkModuleModelNode.getData());
        }
    }

    public void removeData(Computable<? extends Collection<? extends Module>> toRemoveComputable, @NotNull Collection<? extends DataNode<NdkModuleModel>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (Module module : (Collection)toRemoveComputable.get()) {
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            Facets.removeAllFacets(facetModel, NdkFacet.getFacetTypeId());
        }
    }
}

