/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenLinkQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.SelectJdkFromFileSystemQuickFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH&J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JD\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/RuntimeJavaCompiledVersionIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "expectedErrorRegex", "Lkotlin/text/Regex;", "getExpectedErrorRegex", "()Lkotlin/text/Regex;", "parseErrorRegexMatch", "Lkotlin/Pair;", "", "matchResult", "Lkotlin/text/MatchResult;", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "createBuildIssue", "createJdkVersionIncompatibleBuildIssue", "agpMinCompatibleJdkVersion", "gradleJdkVersion", "intellij.android.projectSystem.gradle"})
public abstract class RuntimeJavaCompiledVersionIssueChecker
implements GradleIssueChecker {
    @NotNull
    public abstract Regex getExpectedErrorRegex();

    @Nullable
    public abstract Pair<String, String> parseErrorRegexMatch(@NotNull MatchResult var1);

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        BuildIssue buildIssue2 = this.createBuildIssue(issueData);
        if (buildIssue2 != null) {
            SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.GRADLE_JVM_NOT_COMPATIBLE_WITH_AGP);
        }
        return buildIssue2;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return Regex.find$default((Regex)this.getExpectedErrorRegex(), (CharSequence)message, (int)0, (int)2, null) != null;
    }

    @VisibleForTesting
    @Nullable
    public final BuildIssue createBuildIssue(@NotNull GradleIssueData issueData) {
        BuildIssue buildIssue2;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        MatchResult matchResult = Regex.find$default((Regex)this.getExpectedErrorRegex(), (CharSequence)message, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        Pair<String, String> pair = this.parseErrorRegexMatch(match);
        if (pair != null) {
            Pair<String, String> pair2 = pair;
            boolean bl = false;
            String agpMinCompatibleJdkVersion = (String)pair2.component1();
            String gradleJdkVersion = (String)pair2.component2();
            buildIssue2 = this.createJdkVersionIncompatibleBuildIssue(agpMinCompatibleJdkVersion, gradleJdkVersion);
        } else {
            buildIssue2 = null;
        }
        return buildIssue2;
    }

    private final BuildIssue createJdkVersionIncompatibleBuildIssue(String agpMinCompatibleJdkVersion, String gradleJdkVersion) {
        BuildIssueComposer buildIssueComposer;
        BuildIssueComposer $this$createJdkVersionIncompatibleBuildIssue_u24lambda_u241 = buildIssueComposer = new BuildIssueComposer("Gradle JVM version incompatible.", null, 2, null);
        boolean bl = false;
        $this$createJdkVersionIncompatibleBuildIssue_u24lambda_u241.addDescriptionOnNewLine("This project is configured to use an older Gradle JVM that supports up to version " + gradleJdkVersion + " but the current AGP requires a Gradle JVM that supports version " + agpMinCompatibleJdkVersion + ".");
        $this$createJdkVersionIncompatibleBuildIssue_u24lambda_u241.startNewParagraph();
        $this$createJdkVersionIncompatibleBuildIssue_u24lambda_u241.addQuickFix(new SelectJdkFromFileSystemQuickFix());
        $this$createJdkVersionIncompatibleBuildIssue_u24lambda_u241.addQuickFix("See AGP Release Notes...", new OpenLinkQuickFix("https://developer.android.com/studio/releases/gradle-plugin"));
        return buildIssueComposer.composeBuildIssue();
    }
}

