/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenGradleJdkSettingsQuickfix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016JD\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u0017H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "JAVA_HOME", "", "ERROR_DAEMON", "JVM_IS_INCOMPATIBLE", "JAVA_HOME_DIFFERENT", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseExpectedAndActualJavaHome", "intellij.android.projectSystem.gradle"})
public final class DaemonContextMismatchIssueChecker
implements GradleIssueChecker {
    @NotNull
    private final String JAVA_HOME;
    @NotNull
    private final String ERROR_DAEMON;
    @NotNull
    private final String JVM_IS_INCOMPATIBLE;
    @NotNull
    private final String JAVA_HOME_DIFFERENT;

    public DaemonContextMismatchIssueChecker() {
        this.JAVA_HOME = "javaHome=";
        this.ERROR_DAEMON = "The newly created daemon process has a different context than expected.";
        this.JVM_IS_INCOMPATIBLE = "JVM is incompatible.";
        this.JAVA_HOME_DIFFERENT = "Java home is different.";
    }

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        List messageLines = StringsKt.lines((CharSequence)message);
        if (StringsKt.isBlank((CharSequence)((CharSequence)messageLines.get(0))) || messageLines.size() <= 3) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)((CharSequence)messageLines.get(0)), (CharSequence)this.ERROR_DAEMON, (boolean)false, (int)2, null) && (Intrinsics.areEqual(messageLines.get(2), (Object)this.JVM_IS_INCOMPATIBLE) || Intrinsics.areEqual(messageLines.get(2), (Object)this.JAVA_HOME_DIFFERENT))) {
            BuildIssueComposer buildIssueComposer;
            String string2 = this.parseExpectedAndActualJavaHome(message);
            if (string2 == null) {
                return null;
            }
            String expectedAndActual = string2;
            if (((CharSequence)expectedAndActual).length() == 0) {
                return null;
            }
            SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.DAEMON_CONTEXT_MISMATCH);
            BuildIssueComposer $this$check_u24lambda_u240 = buildIssueComposer = new BuildIssueComposer((String)messageLines.get(2), null, 2, null);
            boolean bl = false;
            $this$check_u24lambda_u240.addDescriptionOnNewLine(expectedAndActual);
            $this$check_u24lambda_u240.startNewParagraph();
            $this$check_u24lambda_u240.addDescriptionOnNewLine("Please configure the JDK to match the expected one.");
            $this$check_u24lambda_u240.startNewParagraph();
            $this$check_u24lambda_u240.addQuickFix("Open JDK Settings", new OpenGradleJdkSettingsQuickfix());
            return buildIssueComposer.composeBuildIssue();
        }
        return null;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        List failureLines = StringsKt.lines((CharSequence)failureCause);
        return StringsKt.contains$default((CharSequence)((CharSequence)failureLines.get(0)), (CharSequence)this.ERROR_DAEMON, (boolean)false, (int)2, null) && failureLines.size() > 3 && (Intrinsics.areEqual(failureLines.get(2), (Object)this.JVM_IS_INCOMPATIBLE) || Intrinsics.areEqual(failureLines.get(2), (Object)this.JAVA_HOME_DIFFERENT));
    }

    private final String parseExpectedAndActualJavaHome(String message) {
        int startIndex = StringsKt.indexOf$default((CharSequence)message, (String)this.JAVA_HOME, (int)0, (boolean)false, (int)6, null);
        int endIndex = StringsKt.indexOf$default((CharSequence)message, (String)",", (int)startIndex, (boolean)false, (int)4, null);
        if (endIndex == -1 || startIndex == -1 || endIndex < startIndex) {
            return null;
        }
        String string = message.substring(startIndex + this.JAVA_HOME.length(), endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String expected = string;
        if (((CharSequence)expected).length() > 0) {
            StringBuilder stringBuilder;
            startIndex = StringsKt.indexOf$default((CharSequence)message, (String)this.JAVA_HOME, (int)endIndex, (boolean)false, (int)4, null);
            if ((endIndex = StringsKt.indexOf$default((CharSequence)message, (String)",", (int)startIndex, (boolean)false, (int)4, null)) == -1 || startIndex == -1 || endIndex < startIndex) {
                return null;
            }
            String string2 = message.substring(startIndex + this.JAVA_HOME.length(), endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String actual = string2;
            StringBuilder $this$parseExpectedAndActualJavaHome_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$parseExpectedAndActualJavaHome_u24lambda_u241.append("Expecting: '" + expected + "'");
            StringBuilder stringBuilder2 = ((CharSequence)actual).length() > 0 ? $this$parseExpectedAndActualJavaHome_u24lambda_u241.append(" but was: '" + actual + "'.") : $this$parseExpectedAndActualJavaHome_u24lambda_u241.append(".");
            return stringBuilder.toString();
        }
        return null;
    }
}

