/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AgpVersions;
import com.android.tools.idea.gradle.project.sync.AgpVersionIncompatible;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooNew;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooOld;
import com.android.tools.idea.gradle.project.sync.AndroidSyncException;
import com.android.tools.idea.gradle.project.sync.AndroidSyncExceptionType;
import com.android.tools.idea.gradle.project.sync.errors.AgpUpgradeQuickFix;
import com.android.tools.idea.gradle.project.sync.errors.AgpVersionNotSupportedIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenLinkQuickFix;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JD\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "Companion", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nAgpVersionNotSupportedIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgpVersionNotSupportedIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1740#2,3:135\n1740#2,3:138\n1740#2,3:141\n*S KotlinDebug\n*F\n+ 1 AgpVersionNotSupportedIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker\n*L\n99#1:135,3\n100#1:138,3\n101#1:141,3\n*E\n"})
public final class AgpVersionNotSupportedIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TOO_OLD_URL = "https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility";
    @NotNull
    private static final String PREVIEW_URL = "https://developer.android.com/studio/preview/features#agp-previews";
    @NotNull
    private static final String TOO_NEW_URL = "https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility";

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        BuildIssueComposer buildIssueComposer;
        Triple triple;
        String message;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            string = "";
        }
        if (StringsKt.isBlank((CharSequence)(message = string))) {
            return null;
        }
        if (!(rootCause instanceof AndroidSyncException)) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[((AndroidSyncException)rootCause).getType().ordinal()]) {
            case 1: {
                Matcher tooOldMatcher = AgpVersionTooOld.Companion.getPATTERN().matcher(message);
                if (!tooOldMatcher.find()) {
                    return null;
                }
                triple = new Triple((Object)tooOldMatcher.group(1), (Object)tooOldMatcher.group(0), (Object)"https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility");
                break;
            }
            case 2: {
                Matcher incompatiblePreviewMatcher = AgpVersionIncompatible.Companion.pattern(AgpVersions.getLatestKnown()).matcher(message);
                if (!incompatiblePreviewMatcher.find()) {
                    return null;
                }
                triple = new Triple((Object)incompatiblePreviewMatcher.group(1), (Object)incompatiblePreviewMatcher.group(0), (Object)PREVIEW_URL);
                break;
            }
            case 3: {
                Matcher tooNewMatcher = AgpVersionTooNew.Companion.pattern(AgpVersions.getLatestKnown()).matcher(message);
                if (!tooNewMatcher.find()) {
                    return null;
                }
                triple = new Triple((Object)tooNewMatcher.group(1), (Object)tooNewMatcher.group(0), (Object)"https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility");
                break;
            }
            default: {
                return null;
            }
        }
        Triple triple2 = triple;
        String agpVersion = (String)triple2.component1();
        String userMessage = (String)triple2.component2();
        String url = (String)triple2.component3();
        Intrinsics.checkNotNull((Object)userMessage);
        BuildIssueComposer $this$check_u24lambda_u242 = buildIssueComposer = new BuildIssueComposer(userMessage, null, 2, null);
        boolean bl = false;
        if (((AndroidSyncException)rootCause).getType() == AndroidSyncExceptionType.AGP_VERSION_INCOMPATIBLE) {
            Intrinsics.checkNotNull((Object)agpVersion);
            AgpVersion agpVersion2 = AgpVersion.Companion.tryParse(agpVersion);
            if (agpVersion2 != null) {
                AgpVersion version2 = agpVersion2;
                boolean bl2 = false;
                if (!AndroidGradleProjectResolver.Companion.shouldDisableForceUpgrades()) {
                    Project project = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(issueData.getProjectPath());
                    if (project != null) {
                        Project project2 = project;
                        boolean bl3 = false;
                        AgpVersionNotSupportedIssueCheckerKt.updateAndRequestSync$default(project2, version2, null, 4, null);
                    }
                }
                $this$check_u24lambda_u242.addQuickFix(new AgpUpgradeQuickFix(version2));
            }
        }
        $this$check_u24lambda_u242.addQuickFix("See Android Studio & AGP compatibility options.", new OpenLinkQuickFix(url));
        return $this$check_u24lambda_u242.composeBuildIssue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Object element$iv;
        String it;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Iterable $this$all$iv = AgpVersionTooOld.Companion.getALWAYS_PRESENT_STRINGS();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (StringsKt.contains$default((CharSequence)failureCause, (CharSequence)it, (boolean)false, (int)2, null));
        boolean bl = false;
        if (bl) return true;
        $this$all$iv = AgpVersionIncompatible.Companion.getALWAYS_PRESENT_STRINGS();
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl2 = false;
        } while (StringsKt.contains$default((CharSequence)failureCause, (CharSequence)it, (boolean)false, (int)2, null));
        boolean bl3 = false;
        if (bl3) return true;
        $this$all$iv = AgpVersionTooNew.Companion.getALWAYS_PRESENT_STRINGS();
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl4 = false;
        } while (StringsKt.contains$default((CharSequence)failureCause, (CharSequence)it, (boolean)false, (int)2, null));
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker$Companion;", "", "<init>", "()V", "TOO_OLD_URL", "", "PREVIEW_URL", "TOO_NEW_URL", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidSyncExceptionType.values().length];
            try {
                nArray[AndroidSyncExceptionType.AGP_VERSION_TOO_OLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidSyncExceptionType.AGP_VERSION_INCOMPATIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidSyncExceptionType.AGP_VERSION_TOO_NEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

