/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output.tomlParser;

import com.android.tools.idea.gradle.project.build.output.tomlParser.ReferenceIssueHandler;
import com.android.tools.idea.gradle.project.build.output.tomlParser.ReferenceSource;
import com.android.tools.idea.gradle.project.build.output.tomlParser.TomlErrorHandler;
import com.android.tools.idea.gradle.project.build.output.tomlParser.TomlErrorHelperKt;
import com.android.tools.idea.gradle.project.build.output.tomlParser.TomlErrorMessageAwareIssue;
import com.intellij.build.events.BuildIssueEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/tomlParser/ReferenceIssueHandler;", "Lcom/android/tools/idea/gradle/project/build/output/tomlParser/TomlErrorHandler;", "<init>", "()V", "PROBLEM_REFERENCE_PATTERN", "Lkotlin/text/Regex;", "REASON_REFERENCE_PATTERN", "REASON_PLUGIN_REFERENCE_PATTERN", "tryExtractMessage", "", "Lcom/intellij/build/events/BuildIssueEvent;", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "extractReferenceInformation", "catalog", "", "reference", "description", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.android.projectSystem.gradle"})
public final class ReferenceIssueHandler
implements TomlErrorHandler {
    @NotNull
    private final Regex PROBLEM_REFERENCE_PATTERN = new Regex("\\s+- Problem: In version catalog ([^ ]+), version reference '([^']+)' doesn't exist.");
    @NotNull
    private final Regex REASON_REFERENCE_PATTERN = new Regex("\\s+Reason: Dependency '([^']+)' references version '([^']+)' which doesn't exist.");
    @NotNull
    private final Regex REASON_PLUGIN_REFERENCE_PATTERN = new Regex("\\s+Reason: Plugin '([^']+)' references version '([^']+)' which doesn't exist.");

    @Override
    @NotNull
    public List<BuildIssueEvent> tryExtractMessage(@NotNull BuildOutputInstantReader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        String string = reader2.readLine();
        boolean bl = string != null ? StringsKt.endsWith$default((String)string, (String)"Invalid catalog definition:", (boolean)false, (int)2, null) : false;
        if (bl) {
            StringBuilder description2 = new StringBuilder().append("Invalid catalog definition.").append('\n');
            String string2 = reader2.readLine();
            if (string2 == null) {
                return CollectionsKt.emptyList();
            }
            String problemLine = string2;
            description2.append(problemLine).append('\n');
            MatchResult matchResult = this.PROBLEM_REFERENCE_PATTERN.matchEntire((CharSequence)problemLine);
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl2 = false;
                MatchResult.Destructured destructured = it.getDestructured();
                String catalog = (String)destructured.getMatch().getGroupValues().get(1);
                String reference = (String)destructured.getMatch().getGroupValues().get(2);
                BuildIssueEvent buildIssueEvent = this.extractReferenceInformation(catalog, reference, description2, reader2);
                if (buildIssueEvent == null) {
                    return CollectionsKt.emptyList();
                }
                BuildIssueEvent event = buildIssueEvent;
                return CollectionsKt.listOf((Object)event);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final BuildIssueEvent extractReferenceInformation(String catalog, String reference, StringBuilder description2, BuildOutputInstantReader reader2) {
        Ref.ObjectRef dependency = new Ref.ObjectRef();
        description2.append(TomlErrorHelperKt.readUntilLine(reader2, "> Invalid catalog definition", (Function1<? super String, Unit>)((Function1)arg_0 -> ReferenceIssueHandler.extractReferenceInformation$lambda$3(dependency, this, arg_0))));
        if (dependency.element == null) {
            return null;
        }
        Object object = dependency.element;
        Intrinsics.checkNotNull((Object)object);
        String dependencyName = (String)((Pair)object).getFirst();
        String string = description2.toString();
        TomlErrorMessageAwareIssue buildIssue2 = new TomlErrorMessageAwareIssue(dependencyName, reference, catalog, (Ref.ObjectRef<Pair<String, ReferenceSource>>)dependency, string){
            final /* synthetic */ String $dependencyName;
            final /* synthetic */ String $reference;
            final /* synthetic */ String $catalog;
            final /* synthetic */ Ref.ObjectRef<Pair<String, ReferenceSource>> $dependency;
            {
                this.$dependencyName = $dependencyName;
                this.$reference = $reference;
                this.$catalog = $catalog;
                this.$dependency = $dependency;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            private final OpenFileDescriptor computeNavigable(Project project, VirtualFile virtualFile, String tableHeader, Function1<? super TomlKeyValue, Boolean> predicate) {
                Object v4;
                OpenFileDescriptor fileDescriptor;
                block6: {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    fileDescriptor = new OpenFileDescriptor(project, virtualFile);
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile == null) {
                        return fileDescriptor;
                    }
                    PsiFile psiFile2 = psiFile;
                    Object $this$childrenOfType$iv = (PsiElement)psiFile2;
                    boolean $i$f$childrenOfType = false;
                    List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, TomlTable.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                    $this$childrenOfType$iv = list;
                    boolean $i$f$filter = false;
                    Iterator<T> iterator2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        TomlTable it = (TomlTable)element$iv$iv;
                        boolean bl = false;
                        TomlKey tomlKey = it.getHeader().getKey();
                        if (!Intrinsics.areEqual((Object)(tomlKey != null ? tomlKey.getText() : null), (Object)tableHeader)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$flatMap = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        TomlTable table2 = (TomlTable)element$iv$iv;
                        boolean bl = false;
                        PsiElement $this$childrenOfType$iv2 = (PsiElement)table2;
                        boolean $i$f$childrenOfType2 = false;
                        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv2, TomlKeyValue.class);
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
                        Iterable list$iv$iv = list2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Iterable iterable = (List)destination$iv$iv;
                    for (T t : iterable) {
                        if (!((Boolean)predicate.invoke(t)).booleanValue()) continue;
                        v4 = t;
                        break block6;
                    }
                    v4 = null;
                }
                TomlKeyValue tomlKeyValue = v4;
                if (tomlKeyValue == null) {
                    return fileDescriptor;
                }
                TomlKeyValue element = tomlKeyValue;
                OpenFileDescriptor openFileDescriptor = TomlErrorHelperKt.getDescriptor((PsiElement)element, project, virtualFile);
                if (openFileDescriptor == null) {
                    openFileDescriptor = fileDescriptor;
                }
                return openFileDescriptor;
            }

            public final boolean isLibraryAliasDeclaration(TomlKeyValue element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                TomlValue content2 = element.getValue();
                String[] stringArray = new String[]{":"};
                List list = StringsKt.split$default((CharSequence)this.$dependencyName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String group2 = (String)list.get(0);
                String name2 = (String)list.get(1);
                return content2 instanceof TomlInlineTable ? (TomlErrorHelperKt.findKeyValue((TomlInlineTable)content2, "module", this.$dependencyName) || TomlErrorHelperKt.findKeyValue((TomlInlineTable)content2, "group", group2) && TomlErrorHelperKt.findKeyValue((TomlInlineTable)content2, "name", name2)) && TomlErrorHelperKt.findKeyValue((TomlInlineTable)content2, "version.ref", this.$reference) : false;
            }

            public final boolean isPluginAliasDeclaration(TomlKeyValue element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                TomlValue content2 = element.getValue();
                return content2 instanceof TomlInlineTable ? TomlErrorHelperKt.findKeyValue((TomlInlineTable)content2, "id", this.$dependencyName) && TomlErrorHelperKt.findKeyValue((TomlInlineTable)content2, "version.ref", this.$reference) : false;
            }

            public Navigatable getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                VirtualFile virtualFile = TomlErrorHelperKt.findCatalogFile(project, this.$catalog);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file = virtualFile;
                return (Navigatable)ActionsKt.runReadAction(() -> extractReferenceInformation.buildIssue.1.getNavigatable$lambda$2(this.$dependency, this, project, file));
            }

            private static final OpenFileDescriptor getNavigatable$lambda$2(Ref.ObjectRef $dependency, extractReferenceInformation.buildIssue.1 this$0, Project $project, VirtualFile $file) {
                Object object = $dependency.element;
                Intrinsics.checkNotNull((Object)object);
                return switch (extractReferenceInformation.buildIssue.WhenMappings.$EnumSwitchMapping$0[((ReferenceSource)((Object)((Pair)object).getSecond())).ordinal()]) {
                    case 1 -> this$0.computeNavigable($project, $file, "libraries", (Function1<? super TomlKeyValue, Boolean>)((Function1)new Function1<TomlKeyValue, Boolean>((Object)this$0){

                        public final Boolean invoke(TomlKeyValue p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return (this.receiver).isLibraryAliasDeclaration(p0);
                        }
                    }));
                    case 2 -> this$0.computeNavigable($project, $file, "plugins", (Function1<? super TomlKeyValue, Boolean>)((Function1)new Function1<TomlKeyValue, Boolean>((Object)this$0){

                        public final Boolean invoke(TomlKeyValue p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return (this.receiver).isPluginAliasDeclaration(p0);
                        }
                    }));
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        };
        return (BuildIssueEvent)new BuildIssueEventImpl(reader2.getParentEventId(), (BuildIssue)buildIssue2, MessageEvent.Kind.ERROR);
    }

    private static final Unit extractReferenceInformation$lambda$3(Ref.ObjectRef $dependency, ReferenceIssueHandler this$0, String descriptionLine) {
        block2: {
            String dep;
            Intrinsics.checkNotNullParameter((Object)descriptionLine, (String)"descriptionLine");
            if ($dependency.element != null) break block2;
            MatchResult matchResult = this$0.REASON_REFERENCE_PATTERN.matchEntire((CharSequence)descriptionLine);
            if (matchResult != null) {
                MatchResult $this$extractReferenceInformation_u24lambda_u243_u24lambda_u241 = matchResult;
                boolean bl = false;
                dep = (String)$this$extractReferenceInformation_u24lambda_u243_u24lambda_u241.getDestructured().getMatch().getGroupValues().get(1);
                $dependency.element = TuplesKt.to((Object)dep, (Object)((Object)ReferenceSource.LIBRARY));
            }
            MatchResult matchResult2 = this$0.REASON_PLUGIN_REFERENCE_PATTERN.matchEntire((CharSequence)descriptionLine);
            if (matchResult2 != null) {
                MatchResult $this$extractReferenceInformation_u24lambda_u243_u24lambda_u242 = matchResult2;
                boolean bl = false;
                dep = (String)$this$extractReferenceInformation_u24lambda_u243_u24lambda_u242.getDestructured().getMatch().getGroupValues().get(1);
                $dependency.element = TuplesKt.to((Object)dep, (Object)((Object)ReferenceSource.PLUGIN));
            }
        }
        return Unit.INSTANCE;
    }
}

