/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.attribution;

import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionManager;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class BuildAttributionOutputLinkFilter
implements Filter,
DumbAware {
    public static final String LINK_TEXT = "Build Analyzer";
    public static final String INSIGHTS_AVAILABLE_LINE = "Build Analyzer results available";

    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        int index;
        int lineStart = entireLength - line.length();
        if (line.contains(INSIGHTS_AVAILABLE_LINE) && (index = line.indexOf(LINK_TEXT)) != -1) {
            return new Filter.Result(Collections.singletonList(BuildAttributionOutputLinkFilter.createLink(lineStart + index, lineStart + index + LINK_TEXT.length())));
        }
        return null;
    }

    @NotNull
    private static Filter.ResultItem createLink(int start2, int end) {
        return new Filter.ResultItem(start2, end, BuildAttributionOutputLinkFilter.getHyperLinkInfo());
    }

    @NotNull
    private static HyperlinkInfo getHyperLinkInfo() {
        return new HyperlinkInfo(){

            public void navigate(@NotNull Project project) {
                ((BuildAttributionManager)project.getService(BuildAttributionManager.class)).openResultsTab();
            }
        };
    }
}

