/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleBuildState {
    private static final Logger LOG = Logger.getInstance(GradleBuildState.class);
    @VisibleForTesting
    public static final Topic<GradleBuildListener> GRADLE_BUILD_TOPIC = new Topic("Gradle build", GradleBuildListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final Object myLock = new Object();
    @Nullable
    private BuildContext myCurrentContext;
    @Nullable
    private BuildSummary mySummary;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener2) {
        return GradleBuildState.subscribe(project, listener2, (Disposable)project);
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener2, @NotNull Disposable parentDisposable) {
        MessageBusConnection connection2 = project.getMessageBus().connect(parentDisposable);
        connection2.subscribe(GRADLE_BUILD_TOPIC, (Object)listener2);
        return connection2;
    }

    @NotNull
    public static GradleBuildState getInstance(@NotNull Project project) {
        return (GradleBuildState)project.getService(GradleBuildState.class);
    }

    public GradleBuildState(@NotNull Project project) {
        this.myProject = project;
        this.myMessageBus = project.getMessageBus();
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BuildCompleter buildStarted(@NotNull BuildContext context) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = context;
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildStarted(context)));
        return new BuildCompleter(context);
    }

    private void syncPublisher(@NotNull Consumer<GradleBuildListener> consumer2) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> consumer2.consume((Object)((GradleBuildListener)this.myMessageBus.syncPublisher(GRADLE_BUILD_TOPIC))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuildInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @TestOnly
    BuildContext getRunningBuildContext() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildSummary getLastFinishedBuildSummary() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySummary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = null;
            this.mySummary = null;
        }
    }

    public class BuildCompleter {
        @NotNull
        private final BuildContext myContext;

        public BuildCompleter(BuildContext context) {
            this.myContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void buildFinished(@NotNull BuildStatus status2) {
            Object object = GradleBuildState.this.myLock;
            synchronized (object) {
                if (GradleBuildState.this.myCurrentContext != this.myContext) {
                    LOG.error((Throwable)new IllegalStateException("buildStarted and buildFinished contexts do not match"));
                }
                GradleBuildState.this.myCurrentContext = null;
                GradleBuildState.this.mySummary = new BuildSummary(status2, this.myContext);
                GradleBuildState.this.myModificationTracker.incModificationCount();
            }
            GradleBuildState.this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildFinished(status2, this.myContext)));
        }
    }
}

