/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.AndroidGradleProjectOpenProcessorKt;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidGradleProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "promptToCloseIfNecessary", "project", "canOpenAsExistingProject", "intellij.android.projectSystem.gradle"})
public final class AndroidGradleProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    public String getName() {
        return "Android Gradle";
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return GradleProjects.canImportAsGradleProject(file);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile virtualFile2 = ProjectImportUtil.findGradleTarget(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile importTarget = virtualFile2;
        VirtualFile adjustedOpenTarget = importTarget.isDirectory() ? importTarget : importTarget.getParent();
        Intrinsics.checkNotNull((Object)adjustedOpenTarget);
        if (!FileExtensions.toIoFile(adjustedOpenTarget).canWrite()) {
            Messages.showErrorDialog((String)AndroidBundle.message("android.project.open.permission.readonly.message", new Object[0]), (String)AndroidBundle.message("android.project.open.permission.readonly.title", new Object[0]));
            return null;
        }
        GradleProjectImporter gradleImporter = GradleProjectImporter.Companion.getInstance();
        if (!this.canOpenAsExistingProject(adjustedOpenTarget)) {
            if (!forceOpenInNewFrame && !this.promptToCloseIfNecessary(projectToClose)) {
                return null;
            }
            return gradleImporter.importAndOpenProjectCore(projectToClose, forceOpenInNewFrame, adjustedOpenTarget);
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.Companion.getInstanceEx();
        Path path = adjustedOpenTarget.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        return projectManagerEx.openProject(path, ProjectSystemService.Companion.projectSystemOpenProjectTask$default(ProjectSystemService.Companion, "com.android.tools.idea.GradleProjectSystem", forceOpenInNewFrame, projectToClose, null, 8, null));
    }

    private final boolean promptToCloseIfNecessary(Project project) {
        boolean success = true;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project[] openProjects = projectArray;
        if (!(openProjects.length == 0)) {
            int exitCode2 = AndroidGradleProjectOpenProcessorKt.access$confirmOpenNewProject();
            if (exitCode2 == 1) {
                Project project2;
                if (project != null && !project.isDefault()) {
                    project2 = project;
                } else {
                    Project project3 = openProjects[openProjects.length - 1];
                    project2 = project3;
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"get(...)");
                }
                Project toClose = project2;
                if (!ProjectManager.getInstance().closeAndDispose(toClose)) {
                    success = false;
                }
            } else if (exitCode2 != 0) {
                success = false;
            }
        }
        return success;
    }

    private final boolean canOpenAsExistingProject(VirtualFile file) {
        return FileExtensions.toVirtualFile(FileExtensions.toPathString(file).resolve(".idea"), true) != null;
    }
}

