/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.google.common.base.Charsets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslFileCache {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<GradleDslFile> myParsedDslFiles = new ArrayList<GradleDslFile>();
    @NotNull
    private final Map<String, GradleBuildFile> myParsedBuildFiles = new LinkedHashMap<String, GradleBuildFile>();
    @NotNull
    private final Map<String, GradleSettingsFile> myParsedSettingsFiles = new LinkedHashMap<String, GradleSettingsFile>();
    @NotNull
    private final Map<String, GradlePropertiesFile> myParsedPropertiesFiles = new LinkedHashMap<String, GradlePropertiesFile>();
    @NotNull
    private final Map<String, GradleVersionCatalogFile> myParsedVersionCatalogFiles = new LinkedHashMap<String, GradleVersionCatalogFile>();
    @NotNull
    private Deque<VirtualFile> myParsingStack = new ArrayDeque<VirtualFile>();

    public GradleDslFileCache(@NotNull Project project) {
        this.myProject = project;
    }

    public void clearAllFiles() {
        this.myParsedBuildFiles.clear();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name2, @NotNull BuildModelContext context, boolean isApplied) {
        GradleBuildFile dslFile = this.myParsedBuildFiles.get(file.getUrl());
        if (dslFile == null) {
            if (!this.myParsingStack.contains(file)) {
                this.myParsingStack.push(file);
                dslFile = context.parseBuildFile(this.myProject, file, name2, isApplied);
                this.myParsingStack.pop();
                this.myParsedBuildFiles.put(file.getUrl(), dslFile);
                this.myParsedDslFiles.add(dslFile);
            } else {
                dslFile = new GradleBuildFile(file, this.myProject, name2, context);
                dslFile.notification(NotificationTypeReference.CIRCULAR_APPLICATION);
            }
        }
        return dslFile;
    }

    public void putBuildFile(@NotNull String name2, @NotNull GradleBuildFile buildFile) {
        this.myParsedBuildFiles.put(name2, buildFile);
        this.myParsedDslFiles.add(buildFile);
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myParsingStack.isEmpty() ? null : this.myParsingStack.getLast();
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile, @NotNull BuildModelContext context) {
        GradleSettingsFile dslFile = this.myParsedSettingsFiles.get(settingsFile.getUrl());
        if (dslFile == null) {
            dslFile = new GradleSettingsFile(settingsFile, this.myProject, "settings", context);
            dslFile.parse();
            this.myParsedSettingsFiles.put(settingsFile.getUrl(), dslFile);
            this.myParsedDslFiles.add(dslFile);
        }
        return dslFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName, @NotNull BuildModelContext context) {
        GradlePropertiesFile dslFile = this.myParsedPropertiesFiles.get(file.getUrl());
        if (dslFile == null) {
            try {
                Properties properties = GradleDslFileCache.getProperties(file);
                dslFile = new GradlePropertiesFile(properties, file, this.myProject, moduleName, context);
                this.myParsedPropertiesFiles.put(file.getUrl(), dslFile);
                this.myParsedDslFiles.add(dslFile);
            }
            catch (IOException e) {
                Logger.getInstance(GradleDslFileCache.class).warn("Failed to process properties file " + file.getPath(), (Throwable)e);
                return null;
            }
        }
        return dslFile;
    }

    private static Properties getProperties(@NotNull VirtualFile file) throws IOException {
        Properties properties = new Properties();
        try (InputStreamReader reader2 = new InputStreamReader(file.getInputStream(), Charsets.UTF_8);){
            properties.load(reader2);
        }
        return properties;
    }

    @NotNull
    public GradleVersionCatalogFile getOrCreateVersionCatalogFile(@NotNull VirtualFile file, @NotNull String catalogName, @NotNull BuildModelContext context) {
        GradleVersionCatalogFile dslFile = this.myParsedVersionCatalogFiles.get(file.getUrl());
        if (dslFile == null) {
            dslFile = new GradleVersionCatalogFile(file, this.myProject, "versionCatalog", catalogName, context);
            dslFile.parse();
            this.myParsedVersionCatalogFiles.put(file.getUrl(), dslFile);
            this.myParsedDslFiles.add(dslFile);
        }
        return dslFile;
    }

    @NotNull
    public List<GradleDslFile> getAllFiles() {
        return this.myParsedDslFiles;
    }
}

