/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.GoogleDefaultRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesModelImpl
extends GradleDslBlockModel
implements RepositoriesModel {
    public RepositoriesModelImpl(@NotNull RepositoriesDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public List<RepositoryModel> repositories() {
        ArrayList<RepositoryModel> result2 = new ArrayList<RepositoryModel>();
        for (GradleDslElement element : this.myDslElement.getAllPropertyElements()) {
            if (element instanceof MavenRepositoryDslElement) {
                if (MavenRepositoryDslElement.MAVEN.name.equals(element.getName())) {
                    result2.add(new MavenRepositoryModelImpl(this.myDslElement, (MavenRepositoryDslElement)element));
                    continue;
                }
                if (MavenRepositoryDslElement.JCENTER.name.equals(element.getName())) {
                    result2.add(new JCenterRepositoryModel(this.myDslElement, (MavenRepositoryDslElement)element));
                    continue;
                }
                if (MavenRepositoryDslElement.GOOGLE.name.equals(element.getName())) {
                    result2.add(new GoogleDefaultRepositoryModelImpl(this.myDslElement, (MavenRepositoryDslElement)element));
                    continue;
                }
                if (!MavenRepositoryDslElement.MAVEN_CENTRAL.name.equals(element.getName())) continue;
                result2.add(new MavenCentralRepositoryModel(this.myDslElement, (MavenRepositoryDslElement)element));
                continue;
            }
            if (element instanceof FlatDirRepositoryDslElement) {
                result2.add(new FlatDirRepositoryModel(this.myDslElement, (FlatDirRepositoryDslElement)element));
                continue;
            }
            if (!(element instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element.getName())) {
                result2.add(new MavenCentralRepositoryModel(this.myDslElement, (GradleDslExpressionMap)element));
                continue;
            }
            if (!"flatDir".equals(element.getName())) continue;
            result2.add(new FlatDirRepositoryModel(this.myDslElement, (GradleDslExpressionMap)element));
        }
        return result2;
    }

    @Override
    public boolean addRepositoryByMethodName(@NotNull String methodName) {
        if (this.containsMethodCall(methodName)) {
            return false;
        }
        GradleDslParser converter = this.myDslElement.getDslFile().getParser();
        PropertiesElementDescription description2 = this.myDslElement.getChildPropertiesElementDescription(converter, methodName);
        if (description2 != null) {
            this.myDslElement.setNewElement((GradleDslElement)description2.constructor.construct(this.myDslElement, GradleNameElement.fake(methodName)));
            return true;
        }
        return false;
    }

    @Override
    public void addFlatDirRepository(@NotNull String dirName) {
        List<FlatDirRepositoryDslElement> flatDirElements = this.myDslElement.getPropertyElements(FlatDirRepositoryDslElement.class);
        if (!flatDirElements.isEmpty()) {
            GradlePropertyModel listModel = new FlatDirRepositoryModel(this.myDslElement, flatDirElements.get(0)).dirs().addListValue();
            if (listModel != null) {
                listModel.setValue(dirName);
            }
        } else {
            FlatDirRepositoryDslElement gradleDslElement = new FlatDirRepositoryDslElement(this.myDslElement, GradleNameElement.fake(FlatDirRepositoryDslElement.FLAT_DIR.name));
            this.myDslElement.setNewElement(gradleDslElement);
            new FlatDirRepositoryModel(this.myDslElement, gradleDslElement).dirs().addListValue().setValue(dirName);
        }
    }

    @Override
    public boolean containsMethodCall(@NotNull String methodName) {
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            if (!methodName.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMavenRepositoryByUrl(@NotNull String url, @NotNull String name2) {
        if (this.containsMavenRepositoryByUrl(url)) {
            return;
        }
        GradleNameElement nameElement = GradleNameElement.fake(MavenRepositoryDslElement.MAVEN.name);
        MavenRepositoryDslElement newElement = new MavenRepositoryDslElement(this.myDslElement, nameElement);
        this.myDslElement.setNewElement(newElement);
        MavenRepositoryModelImpl model = new MavenRepositoryModelImpl(this.myDslElement, newElement);
        model.url().setValue(url);
        model.name().setValue(name2);
    }

    @Override
    public void removeRepository(@NotNull RepositoryModel repository2) {
        this.myDslElement.removeProperty(repository2.getDslElement());
    }

    @Override
    public boolean containsMavenRepositoryByUrl(@NotNull String repositoryUrl) {
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            String urlElement = element.getLiteral("url", String.class);
            if (!repositoryUrl.equals(urlElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGoogleMavenRepository() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        if (this.containsMethodCall("google")) {
            return true;
        }
        return this.containsMavenRepositoryByUrl("https://maven.google.com/");
    }

    @Override
    public void addGoogleMavenRepository() {
        this.addRepositoryByMethodName("google");
    }
}

