/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.android.FakeSdkElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.VersionConstraint;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkOrPreviewTransform
extends PropertyTransform {
    @NotNull
    private final ModelPropertyDescription propertyDescription;
    @NotNull
    private final String genericSetter;
    @NotNull
    private final String sdkSetter;
    @NotNull
    private final String previewSetter;
    @Nullable
    private VersionConstraint versionConstraint;
    @Nullable
    private Integer position;

    public SdkOrPreviewTransform(@NotNull ModelPropertyDescription propertyDescription, @NotNull String genericSetter, @NotNull String sdkSetter, @NotNull String previewSetter, @Nullable VersionConstraint versionConstraint, @Nullable Integer position) {
        this.propertyDescription = propertyDescription;
        this.genericSetter = genericSetter;
        this.sdkSetter = sdkSetter;
        this.previewSetter = previewSetter;
        this.versionConstraint = versionConstraint;
        this.position = position;
    }

    public SdkOrPreviewTransform(@NotNull ModelPropertyDescription propertyDescription, @NotNull String genericSetter, @NotNull String sdkSetter, @NotNull String previewSetter, @Nullable VersionConstraint versionConstraint) {
        this(propertyDescription, genericSetter, sdkSetter, previewSetter, versionConstraint, null);
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        return e == null || e.getModelProperty() == this.propertyDescription;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        if (e instanceof GradleDslSimpleExpression && this.previewSetter.equals(e.getNameElement().getLocalName())) {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)e;
            return new FakeSdkElement(expression.getParent(), GradleNameElement.copy(expression.getNameElement()), expression, true);
        }
        return e;
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name2) {
        ExternalNameInfo.ExternalNameSyntax syntax;
        String operatorName;
        if (this.versionConstraint == null || this.versionConstraint.isOkWith(holder.getDslFile().getContext().getAgpVersion())) {
            if (value2 instanceof ReferenceTo) {
                operatorName = this.genericSetter;
                syntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
            } else if (value2 instanceof Integer) {
                operatorName = this.sdkSetter;
                syntax = Objects.equals("gradle", holder.getDslFile().getFile().getExtension()) ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
            } else if (value2 instanceof String && ((String)value2).startsWith("android-")) {
                String valueAfterAndroid = ((String)value2).substring("android-".length());
                if (this.isPreviewHash((String)value2)) {
                    operatorName = this.previewSetter;
                    syntax = Objects.equals("gradle", holder.getDslFile().getFile().getExtension()) ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
                    value2 = valueAfterAndroid;
                } else {
                    try {
                        int sdkVersion = Integer.parseInt(valueAfterAndroid);
                        operatorName = this.sdkSetter;
                        syntax = Objects.equals("gradle", holder.getDslFile().getFile().getExtension()) ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
                        value2 = sdkVersion;
                    }
                    catch (NumberFormatException e) {
                        operatorName = this.genericSetter;
                        syntax = holder.getDslFile().getWriter().getKind() == GradleDslNameConverter.Kind.DECLARATIVE ? ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT : ExternalNameInfo.ExternalNameSyntax.METHOD;
                    }
                }
            } else {
                operatorName = this.genericSetter;
                syntax = holder.getDslFile().getWriter().getKind() == GradleDslNameConverter.Kind.DECLARATIVE ? ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT : ExternalNameInfo.ExternalNameSyntax.METHOD;
            }
        } else {
            operatorName = this.genericSetter;
            syntax = holder.getDslFile().getWriter().getKind() == GradleDslNameConverter.Kind.DECLARATIVE ? ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT : ExternalNameInfo.ExternalNameSyntax.METHOD;
        }
        GradleDslSimpleExpression expression = PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.create(operatorName));
        expression.setModelEffect(new ModelEffectDescription(this.propertyDescription, ModelSemanticsDescription.CREATE_WITH_VALUE));
        expression.setExternalSyntax(syntax);
        return expression;
    }

    private boolean isPreviewHash(String value2) {
        return value2.startsWith("android-") && Character.isAlphabetic(value2.charAt(value2.length() - 1));
    }

    @Override
    @NotNull
    public GradleDslElement replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name2) {
        GradlePropertiesDslElement propertiesHolder = (GradlePropertiesDslElement)holder;
        if (oldElement != null) {
            propertiesHolder.replaceElement(oldElement, newElement);
        } else if (this.position != null) {
            propertiesHolder.addNewElementAt(this.position, newElement);
        } else {
            propertiesHolder.setNewElement(newElement);
        }
        return newElement;
    }
}

