/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapMethodTransform
extends PropertyTransform {
    @NotNull
    private final String myMethodName;
    @NotNull
    private final String myFieldName;

    public MapMethodTransform(@NotNull String methodName, @NotNull String fieldName) {
        this.myMethodName = methodName;
        this.myFieldName = fieldName;
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        if (e == null) {
            return true;
        }
        if (!(e instanceof GradleDslMethodCall)) {
            return false;
        }
        GradleDslMethodCall methodCall = (GradleDslMethodCall)e;
        if (methodCall.getArguments().isEmpty()) {
            return true;
        }
        return methodCall.getArguments().get(0) instanceof GradleDslExpressionMap;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        assert (e instanceof GradleDslMethodCall);
        GradleDslMethodCall methodCall = (GradleDslMethodCall)e;
        if (methodCall.getArguments().isEmpty()) {
            return null;
        }
        assert (methodCall.getArguments().get(0) instanceof GradleDslExpressionMap);
        GradleDslExpressionMap map2 = (GradleDslExpressionMap)methodCall.getArguments().get(0);
        return map2.getPropertyElement(this.myFieldName);
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name2) {
        return PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.create(this.myFieldName));
    }

    @Override
    @NotNull
    public GradleDslExpression bindList(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull String name2) {
        return new GradleDslExpressionList(holder, GradleNameElement.create(this.myFieldName), false);
    }

    @Override
    @NotNull
    public GradleDslExpression bindMap(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull String name2) {
        return new GradleDslExpressionMap(holder, GradleNameElement.create(this.myFieldName), false);
    }

    @Override
    @NotNull
    public GradleDslMethodCall replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name2) {
        GradleDslExpressionMap map2;
        GradleDslMethodCall methodCall = !(oldElement instanceof GradleDslMethodCall) ? new GradleDslMethodCall(holder, GradleNameElement.create(name2), this.myMethodName) : (GradleDslMethodCall)oldElement;
        GradleDslElement fieldElement = null;
        if (!methodCall.getArguments().isEmpty()) {
            assert (methodCall.getArguments().get(0) instanceof GradleDslExpressionMap);
            map2 = (GradleDslExpressionMap)methodCall.getArguments().get(0);
            fieldElement = this.transform(methodCall);
        } else {
            map2 = new GradleDslExpressionMap((GradleDslElement)methodCall, GradleNameElement.empty(), false);
            methodCall.addNewArgument(map2);
        }
        if (fieldElement != null) {
            map2.removeProperty(fieldElement);
        }
        map2.setNewElement(newElement);
        return methodCall;
    }
}

