/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.UseLibrariesModel;
import com.android.tools.idea.gradle.dsl.api.android.UseLibraryModel;
import com.android.tools.idea.gradle.dsl.model.android.UseLibraryModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UseLibrariesModelImpl
implements UseLibrariesModel {
    @NotNull
    private final GradlePropertiesDslElement myDslElement;

    public UseLibrariesModelImpl(@NotNull GradlePropertiesDslElement element) {
        this.myDslElement = element;
    }

    @Override
    @NotNull
    public UseLibraryModel create(@NotNull String libraryName) {
        return UseLibraryModelImpl.createNew(this.myDslElement, libraryName);
    }

    @Override
    @NotNull
    public UseLibraryModel create(@NotNull String libraryName, boolean required) {
        return UseLibraryModelImpl.createNew(this.myDslElement, libraryName, required);
    }

    @Override
    @NotNull
    public List<UseLibraryModel> find(@NotNull String libraryName) {
        ArrayList<UseLibraryModel> result2 = new ArrayList<UseLibraryModel>();
        for (GradleDslElement element : this.myDslElement.getChildren()) {
            UseLibraryModelImpl model;
            if (!this.isUseLibraryElement(element) || !libraryName.equals((model = new UseLibraryModelImpl(element)).name())) continue;
            result2.add(model);
        }
        return result2;
    }

    private boolean isUseLibraryElement(@NotNull GradleDslElement element) {
        if (element instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
            if (!"useLibrary".equals(methodCall.getMethodName())) {
                return false;
            }
            int size = methodCall.getArguments().size();
            return size != 0 && size <= 2;
        }
        if (element instanceof GradleDslLiteral) {
            GradleDslLiteral literal = (GradleDslLiteral)element;
            return "useLibrary".equals(literal.getName());
        }
        return false;
    }
}

