/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.SyncProjectAction;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolverKeys;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class RefreshLinkedCppProjectsAction
extends SyncProjectAction {
    public RefreshLinkedCppProjectsAction() {
        super("Refresh Linked C++ Projects");
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        project.putUserData(AndroidGradleProjectResolverKeys.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, (Object)true);
        super.doPerform(e, project);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        super.doUpdate(e, project);
        if (e.getPresentation().isEnabled() && !this.containsExternalCppProjects(project)) {
            e.getPresentation().setEnabled(false);
        }
    }

    @VisibleForTesting
    boolean containsExternalCppProjects(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
            if (ndkModuleModel == null) continue;
            return true;
        }
        return false;
    }
}

