/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gemini;

import com.android.tools.idea.gemini.AiExcludeException;
import com.android.tools.idea.gemini.GeminiPluginApi;
import com.android.tools.idea.gemini.LlmPrompt;
import com.android.tools.idea.gemini.LlmPromptBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\b\u0010H\u0016J!\u0010\u0011\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\b\u0010H\u0016J!\u0010\u0012\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\b\u0010H\u0016J)\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\b\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/gemini/LlmPromptBuilderImpl;", "Lcom/android/tools/idea/gemini/LlmPromptBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "messages", "", "Lcom/android/tools/idea/gemini/LlmPrompt$Message;", "getMessages", "()Ljava/util/List;", "systemMessage", "", "builder", "Lkotlin/Function1;", "Lcom/android/tools/idea/gemini/LlmPromptBuilder$MessageBuilder;", "Lkotlin/ExtensionFunctionType;", "userMessage", "modelMessage", "message", "role", "Lcom/android/tools/idea/gemini/LlmPrompt$Role;", "MessageBuilderImpl", "intellij.android.ml-api"})
public final class LlmPromptBuilderImpl
implements LlmPromptBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final List<LlmPrompt.Message> messages;

    public LlmPromptBuilderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.messages = new ArrayList();
    }

    @NotNull
    public final List<LlmPrompt.Message> getMessages() {
        return this.messages;
    }

    @Override
    public void systemMessage(@NotNull Function1<? super LlmPromptBuilder.MessageBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.message(LlmPrompt.Role.SYSTEM, builder);
    }

    @Override
    public void userMessage(@NotNull Function1<? super LlmPromptBuilder.MessageBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.message(LlmPrompt.Role.USER, builder);
    }

    @Override
    public void modelMessage(@NotNull Function1<? super LlmPromptBuilder.MessageBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.message(LlmPrompt.Role.MODEL, builder);
    }

    private final void message(LlmPrompt.Role role, Function1<? super LlmPromptBuilder.MessageBuilder, Unit> builder) {
        MessageBuilderImpl messageBuilderImpl = new MessageBuilderImpl(this.project);
        builder.invoke((Object)messageBuilderImpl);
        this.messages.add(messageBuilderImpl.build(role));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0016J&\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0016J\u001e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001d\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/gemini/LlmPromptBuilderImpl$MessageBuilderImpl;", "Lcom/android/tools/idea/gemini/LlmPromptBuilder$MessageBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getSb", "()Ljava/lang/StringBuilder;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFiles", "()Ljava/util/Set;", "text", "", "str", "", "filesUsed", "", "code", "language", "Lcom/intellij/lang/Language;", "content", "mdFormat", "assertAiExcludeSafe", "build", "Lcom/android/tools/idea/gemini/LlmPrompt$Message;", "role", "Lcom/android/tools/idea/gemini/LlmPrompt$Role;", "intellij.android.ml-api"})
    @SourceDebugExtension(value={"SMAP\nLlmPrompt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmPrompt.kt\ncom/android/tools/idea/gemini/LlmPromptBuilderImpl$MessageBuilderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n774#2:167\n865#2,2:168\n*S KotlinDebug\n*F\n+ 1 LlmPrompt.kt\ncom/android/tools/idea/gemini/LlmPromptBuilderImpl$MessageBuilderImpl\n*L\n137#1:167\n137#1:168,2\n*E\n"})
    public static final class MessageBuilderImpl
    implements LlmPromptBuilder.MessageBuilder {
        @NotNull
        private final Project project;
        @NotNull
        private final StringBuilder sb;
        @NotNull
        private final Set<VirtualFile> files;

        public MessageBuilderImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.sb = new StringBuilder();
            this.files = new LinkedHashSet();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final StringBuilder getSb() {
            return this.sb;
        }

        @NotNull
        public final Set<VirtualFile> getFiles() {
            return this.files;
        }

        @Override
        public void text(@NotNull String str, @NotNull Collection<? extends VirtualFile> filesUsed) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter(filesUsed, (String)"filesUsed");
            this.content(str, filesUsed);
        }

        @Override
        public void code(@NotNull String code, @NotNull Language language, @NotNull Collection<? extends VirtualFile> filesUsed) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(filesUsed, (String)"filesUsed");
            this.content(this.mdFormat(code, language), filesUsed);
        }

        private final void content(String text2, Collection<? extends VirtualFile> filesUsed) {
            if (!filesUsed.isEmpty() && !GeminiPluginApi.Companion.getInstance().isContextAllowed(this.project)) {
                boolean bl = false;
                String string = "User has not enabled context sharing. This setting must be checked before building a prompt that used any files as context.";
                throw new IllegalStateException(string.toString());
            }
            this.assertAiExcludeSafe(filesUsed);
            this.sb.append('\n');
            this.sb.append(text2);
            this.files.addAll(filesUsed);
        }

        private final String mdFormat(String code, Language language) {
            String string = language.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return StringsKt.trimMargin$default((String)("\n        |```" + string2 + "\n        |" + code + "\n        |```\n      "), null, (int)1, null);
        }

        private final void assertAiExcludeSafe(Collection<? extends VirtualFile> files2) {
            List excludedFiles = (List)DumbService.Companion.getInstance(this.project).runReadActionInSmartMode(() -> MessageBuilderImpl.assertAiExcludeSafe$lambda$2(files2, this));
            if (!((Collection)excludedFiles).isEmpty()) {
                throw new AiExcludeException(excludedFiles);
            }
        }

        @NotNull
        public final LlmPrompt.Message build(@NotNull LlmPrompt.Role role) {
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new LlmPrompt.Message(role, string, (Collection<? extends VirtualFile>)this.files);
        }

        /*
         * WARNING - void declaration
         */
        private static final List assertAiExcludeSafe$lambda$2(Collection $files, MessageBuilderImpl this$0) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!GeminiPluginApi.Companion.getInstance().isFileExcluded(this$0.project, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }
}

