/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.applychanges;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.execution.common.applychanges.BaseAction;
import com.android.tools.idea.run.util.SwapInfo;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.XDebuggerManager;
import icons.StudioIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ApplyChangesAction
extends BaseAction {
    public static final String ID = "android.deploy.ApplyChanges";
    public static final String DISPLAY_NAME = "Apply Changes and Restart Activity";
    public static final String ACCELERATOR_NAME = "&Apply Changes and Restart Activity";
    private static final Shortcut SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(SystemInfo.isMac ? "control meta E" : "control F10"), null);
    private static final String DESC = "Attempt to apply resource and code changes and restart activity.";

    public ApplyChangesAction() {
        super(ID, DISPLAY_NAME, ACCELERATOR_NAME, SwapInfo.SwapType.APPLY_CHANGES, StudioIcons.Shell.Toolbar.APPLY_ALL_CHANGES, SHORTCUT, DESC);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (!e.getPresentation().isVisible() || !e.getPresentation().isEnabled()) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        AndroidExecutionTarget selectedExecutionTarget = (AndroidExecutionTarget)ExecutionTargetManager.getActiveTarget((Project)project);
        List<IDevice> devices2 = selectedExecutionTarget.getRunningDevices().stream().toList();
        List<ProcessHandler> debugProcessHandlers = Arrays.stream(XDebuggerManager.getInstance((Project)project).getDebugSessions()).map(x -> x.getDebugProcess().getProcessHandler()).toList();
        boolean debuggerConnected = debugProcessHandlers.stream().anyMatch(processHandler -> {
            AndroidSessionInfo sessionInfo = AndroidSessionInfo.Companion.from((ProcessHandler)processHandler);
            if (sessionInfo == null) {
                return false;
            }
            return devices2.stream().anyMatch(device2 -> sessionInfo.getDevices().contains(device2));
        });
        if (debuggerConnected) {
            this.disableAction(e.getPresentation(), new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "debug execution", "it is currently not allowed during debugging"));
        }
    }
}

