/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common;

import com.android.annotations.Trace;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.intellij.execution.ExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ApplicationTerminator
implements AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final IDevice myIDevice;
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final List<Client> myClientsToWaitFor = Collections.synchronizedList(new ArrayList());
    @NotNull
    private final CountDownLatch myProcessKilledLatch = new CountDownLatch(1);

    public ApplicationTerminator(@NotNull IDevice iDevice, @NotNull String applicationId2) {
        this.myIDevice = iDevice;
        this.myApplicationId = applicationId2;
    }

    @Trace
    public boolean killApp() throws ExecutionException {
        if (!this.myIDevice.isOnline()) {
            throw new ExecutionException(String.format("Couldn't terminate the existing process for %s. Device is offline.", this.myApplicationId));
        }
        this.myIDevice.forceStop(this.myApplicationId);
        if (this.myIDevice.getVersion().getApiLevel() <= 25) {
            this.myIDevice.forceStop(this.myApplicationId);
        }
        this.myClientsToWaitFor.addAll(DeploymentApplicationService.getInstance().findClient(this.myIDevice, this.myApplicationId));
        if (this.myClientsToWaitFor.isEmpty()) {
            return true;
        }
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        try {
            if (!this.myProcessKilledLatch.await(10L, TimeUnit.SECONDS)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
        return true;
    }

    public void deviceConnected(@NotNull IDevice device2) {
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        if (device2 == this.myIDevice) {
            this.myProcessKilledLatch.countDown();
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    public void deviceChanged(@NotNull IDevice changedDevice, int changeMask) {
        if (changedDevice != this.myIDevice || (changeMask & 2) == 0) {
            this.checkDone();
            return;
        }
        this.myClientsToWaitFor.retainAll(Arrays.asList(changedDevice.getClients()));
        this.checkDone();
    }

    private void checkDone() {
        if (this.myClientsToWaitFor.isEmpty()) {
            this.myProcessKilledLatch.countDown();
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }
}

