/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.FrozenColumnTable;
import com.android.tools.idea.editors.strings.table.SubTableModel;
import com.google.common.collect.Maps;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class SubTable<M extends TableModel>
extends JBTable
implements UiDataProvider,
PasteProvider {
    private final FrozenColumnTable<M> myFrozenColumnTable;

    SubTable(@NotNull SubTableModel model, @NotNull FrozenColumnTable<M> frozenColumnTable) {
        super((TableModel)model);
        this.getSelectionModel().setSelectionMode(1);
        this.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        TableSpeedSearch.installOn((JTable)((Object)this));
        this.myFrozenColumnTable = frozenColumnTable;
    }

    @NotNull
    FrozenColumnTable<M> getFrozenColumnTable() {
        return this.myFrozenColumnTable;
    }

    void setSelectedRow(int selectedViewRowIndex) {
        if (this.getSelectedRow() == selectedViewRowIndex) {
            return;
        }
        if (selectedViewRowIndex == -1) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.setRowSelectionInterval(selectedViewRowIndex, selectedViewRowIndex);
    }

    boolean hasSelectedCell() {
        return this.getSelectedRow() >= 0 && this.getSelectedColumn() >= 0;
    }

    int getSelectedModelRowIndex() {
        int selectedRow = this.getSelectedRow();
        return selectedRow == -1 ? selectedRow : this.convertRowIndexToModel(selectedRow);
    }

    int getSelectedModelColumnIndex() {
        SubTableModel model = (SubTableModel)this.getModel();
        int selectedColumn = this.getSelectedColumn();
        return selectedColumn == -1 ? selectedColumn : model.convertColumnIndexToDelegate(this.convertColumnIndexToModel(selectedColumn));
    }

    @NotNull
    List<Object> getColumnAt(int viewColumnIndex) {
        return IntStream.range(0, this.getRowCount()).mapToObj(viewRowIndex -> this.getValueAt(viewRowIndex, viewColumnIndex)).collect(Collectors.toList());
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        JBTable.JBTableHeader header = new JBTable.JBTableHeader((JBTable)this);
        header.setReorderingAllowed(false);
        header.setPreferredSize(new Dimension(1, super.getRowHeight()));
        return header;
    }

    public int getRowHeight() {
        int frozenColumnTableRowHeight;
        int subTableRowHeight = super.getRowHeight();
        if (subTableRowHeight > (frozenColumnTableRowHeight = this.myFrozenColumnTable.getRowHeight())) {
            this.myFrozenColumnTable.setRowHeight(subTableRowHeight);
            return subTableRowHeight;
        }
        return frozenColumnTableRowHeight;
    }

    public void createDefaultColumnsFromModel() {
        if (this.myFrozenColumnTable == null) {
            return;
        }
        this.addColumns(this.removeAllColumns());
    }

    private void addColumns(@NotNull Map<Integer, TableColumn> map2) {
        SubTableModel model = (SubTableModel)this.getModel();
        IntStream.range(0, this.dataModel.getColumnCount()).map(model::convertColumnIndexToDelegate).filter(this.myFrozenColumnTable::includeColumn).map(model::convertColumnIndexToModel).mapToObj(modelColumnIndex -> this.getOrCreateColumn(map2, modelColumnIndex, model)).forEach(arg_0 -> this.addColumn(arg_0));
    }

    @NotNull
    private TableColumn getOrCreateColumn(@NotNull Map<Integer, TableColumn> map2, int modelColumnIndex, @NotNull SubTableModel model) {
        TableColumn column2 = map2.get(modelColumnIndex);
        if (column2 == null) {
            column2 = this.myFrozenColumnTable.createColumn(model.convertColumnIndexToDelegate(modelColumnIndex));
            column2.setModelIndex(modelColumnIndex);
        }
        column2.setHeaderValue(null);
        return column2;
    }

    @NotNull
    private Map<Integer, TableColumn> removeAllColumns() {
        HashMap map2 = Maps.newHashMapWithExpectedSize((int)this.columnModel.getColumnCount());
        while (this.columnModel.getColumnCount() != 0) {
            TableColumn column2 = this.columnModel.getColumn(0);
            this.removeColumn(column2);
            map2.put(column2.getModelIndex(), column2);
        }
        return map2;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        sink.set(PlatformDataKeys.PASTE_PROVIDER, (Object)this);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        return this.myFrozenColumnTable.isPastePossible();
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return this.myFrozenColumnTable.isPastePossible();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return;
        }
        this.myFrozenColumnTable.paste(transferable);
    }

    public Dimension getPreferredSize() {
        if (this.getColumnCount() == 0 && this.myFrozenColumnTable.getFrozenTable().getColumnCount() > 0) {
            Dimension size = this.myFrozenColumnTable.getFrozenTable().getPreferredSize();
            size.width = 0;
            return size;
        }
        return super.getPreferredSize();
    }

    public String toString() {
        return this.getName();
    }
}

