/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.IntentFilterNodeKeyResolver;
import com.android.manifmerger.XmlNode;
import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.PositionXmlParser;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ManifestUtils {
    private ManifestUtils() {
    }

    @NotNull
    public static List<? extends Actions.Record> getRecords(@NotNull MergedManifestSnapshot manifest, @NotNull Node node) {
        Actions actions2 = manifest.getActions();
        if (actions2 != null) {
            Attr attribute2;
            XmlNode.NodeName nodeName;
            ImmutableList attributeRecords;
            XmlNode.NodeKey parentKey;
            Element parentElement;
            Element element;
            if (node instanceof Element) {
                element = (Element)node;
            } else if (node instanceof Attr) {
                Attr attribute3 = (Attr)node;
                element = attribute3.getOwnerElement();
            } else {
                return Collections.emptyList();
            }
            Node parentNode = element.getParentNode();
            if (parentNode instanceof Element && "intent-filter".equals((parentElement = (Element)parentNode).getTagName()) && (parentKey = ManifestUtils.getNodeKey(manifest, parentElement)) != null) {
                return actions2.getNodeRecords(parentKey);
            }
            XmlNode.NodeKey key = ManifestUtils.getNodeKey(manifest, element);
            if (key == null) {
                return Collections.emptyList();
            }
            if (node instanceof Attr && !(attributeRecords = actions2.getAttributeRecords(key, nodeName = XmlNode.fromXmlName((String)(attribute2 = (Attr)node).getName()))).isEmpty()) {
                return attributeRecords;
            }
            return actions2.getNodeRecords(key);
        }
        return Collections.emptyList();
    }

    @Nullable
    static XmlNode.NodeKey getNodeKey(@NotNull MergedManifestSnapshot manifest, @NotNull Element element) {
        Object key = manifest.getNodeKey(element.getNodeName());
        if (key == null) {
            Attr glEsVersionAttribute;
            Attr nameAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            key = nameAttribute != null ? manifest.getNodeKey(element.getTagName() + "#" + nameAttribute.getValue()) : ((glEsVersionAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "glEsVersion")) != null ? manifest.getNodeKey(element.getTagName() + "#" + glEsVersionAttribute.getValue()) : ("intent-filter".equals(element.getTagName()) ? manifest.getNodeKey(element.getTagName() + "#" + IntentFilterNodeKeyResolver.INSTANCE.getKey(element)) : null));
        }
        return key;
    }

    @Nullable
    public static Node getSourceNode(@NotNull Module module, @NotNull Actions.Record record) {
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file != null && !SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
            assert (vFile != null);
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module.getProject());
            if (fileModule != null && !fileModule.equals((Object)module)) {
                MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(fileModule);
                Document document = manifest.getDocument();
                assert (document != null);
                Element root = document.getDocumentElement();
                assert (root != null);
                int startLine = sourcePosition.getStartLine();
                int startColumn = sourcePosition.getStartColumn();
                return PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)startColumn);
            }
            int startLine = sourcePosition.getStartLine();
            int startColumn = sourcePosition.getStartColumn();
            try {
                byte[] bytes2 = Files.toByteArray((File)file);
                Document document = PositionXmlParser.parse((byte[])bytes2);
                return PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)startColumn);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    static SourceFilePosition getActionLocation(@NotNull Module module, @NotNull Actions.Record record) {
        int startColumn;
        AndroidFacet facet;
        Module fileModule;
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file == null || SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            return sourceFilePosition;
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        Module module2 = fileModule = vFile == null ? null : ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module.getProject());
        if (module.equals((Object)fileModule)) {
            return sourceFilePosition;
        }
        AndroidFacet androidFacet = facet = fileModule == null ? null : AndroidFacet.getInstance((Module)fileModule);
        if (facet == null || !SourceProvidersKt.isManifestFile(facet, vFile)) {
            return sourceFilePosition;
        }
        MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(fileModule);
        Document document = manifest.getDocument();
        assert (document != null);
        Element root = document.getDocumentElement();
        assert (root != null);
        int startLine = sourcePosition.getStartLine();
        Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)(startColumn = sourcePosition.getStartColumn()));
        if (node == null) {
            Logger.getInstance(ManifestPanel.class).warn("Can not find node in " + String.valueOf(fileModule) + " for " + String.valueOf(sourceFilePosition));
            return sourceFilePosition;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(manifest, node);
        if (!records.isEmpty()) {
            return ManifestUtils.getActionLocation(fileModule, records.get(0));
        }
        return sourceFilePosition;
    }

    @Nullable
    public static NamedIdeaSourceProvider findManifestSourceProvider(@NotNull AndroidFacet facet, @NotNull VirtualFile manifestFile) {
        return SourceProvidersKt.findByFile(SourceProviderManager.getInstance(facet).getCurrentSourceProviders(), manifestFile);
    }

    @NotNull
    static XmlFile getMainManifest(@NotNull AndroidFacet facet) {
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
        assert (manifestFile != null);
        PsiFile psiFile = PsiManager.getInstance((Project)facet.getModule().getProject()).findFile(manifestFile);
        assert (psiFile != null);
        return (XmlFile)psiFile;
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Node item) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (item instanceof Element) {
            ManifestUtils.toolsRemove(manifest, (Element)item);
        } else if (item instanceof Attr) {
            Attr attribute2 = (Attr)item;
            Element element = attribute2.getOwnerElement();
            if ("name".equals(attribute2.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute2.getNamespaceURI()) || Lint.getChildCount((Node)element) == 0 && element.getAttributes().getLength() == 1) {
                ManifestUtils.toolsRemove(manifest, element);
            } else {
                ManifestUtils.toolsRemove(manifest, attribute2);
            }
        }
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Element item) {
        ManifestUtils.addToolsAttribute(manifest, item, "node", "remove");
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Attr item) {
        ManifestUtils.addToolsAttribute(manifest, item.getOwnerElement(), "remove", item.getName());
    }

    static void addToolsAttribute(@NotNull XmlFile manifest, @NotNull Element item, @NotNull String attributeName, @NotNull String attributeValue) {
        if (attributeName.contains(":")) {
            throw new IllegalArgumentException("should not have namespace as it's always tools");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        IdeResourcesUtil.ensureNamespaceImported(manifest, "http://schemas.android.com/tools", null);
        XmlTag parent = null;
        XmlTag[] manifestTags = new XmlTag[]{manifest.getRootTag()};
        for (Element tag : ManifestUtils.getPath(item)) {
            XmlTag found = ManifestUtils.findTag(manifestTags, tag);
            if (found == null) {
                if (parent == null) {
                    Logger.getInstance(ManifestUtils.class).warn("can not root tag " + String.valueOf(tag) + " in xml file " + String.valueOf(manifest));
                    return;
                }
                found = parent.createChildTag(tag.getLocalName(), null, null, false);
                found = parent.addSubTag(found, true);
                Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameAttribute != null) {
                    found.setAttribute(nameAttribute.getLocalName(), nameAttribute.getNamespaceURI(), nameAttribute.getValue());
                }
                if (tag == item) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                }
            } else if (tag == item) {
                XmlAttribute attribute2 = found.getAttribute(attributeName, "http://schemas.android.com/tools");
                if (attribute2 == null) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                } else {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attribute2.getValue() + "," + attributeValue);
                }
            }
            parent = found;
            manifestTags = found.getSubTags();
        }
    }

    @Nullable
    private static XmlTag findTag(@NotNull XmlTag[] manifestTags, @NotNull Element tag) {
        Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        String name2 = nameAttribute == null ? null : nameAttribute.getValue();
        for (XmlTag xmlTag : manifestTags) {
            if (!tag.getTagName().equals(xmlTag.getName())) continue;
            if (name2 != null) {
                XmlAttribute xmlAttribute = xmlTag.getAttribute("name", "http://schemas.android.com/apk/res/android");
                if (xmlAttribute == null || !name2.equals(xmlAttribute.getValue())) continue;
                return xmlTag;
            }
            return xmlTag;
        }
        return null;
    }

    @NotNull
    private static List<Element> getPath(@NotNull Element element) {
        Element tag = element;
        ArrayList<Element> path = new ArrayList<Element>();
        while (true) {
            path.add(tag);
            Node parentNode = tag.getParentNode();
            if (!(parentNode instanceof Element)) break;
            tag = (Element)parentNode;
        }
        Collections.reverse(path);
        return path;
    }
}

