/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.liveedit.ui;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.editors.liveedit.ui.DeviceGetter;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/editors/liveedit/ui/EmulatorLiveEditAdapter;", "Lcom/android/tools/idea/editors/liveedit/ui/DeviceGetter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cachedDeviceFutures", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/ddmlib/IDevice;", "register", "", "serial", "unregister", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "device", "devices", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nEmulatorLiveEditAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorLiveEditAdapter.kt\ncom/android/tools/idea/editors/liveedit/ui/EmulatorLiveEditAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class EmulatorLiveEditAdapter
implements DeviceGetter {
    @NotNull
    private final Project project;
    @NotNull
    private ConcurrentHashMap<String, ListenableFuture<IDevice>> cachedDeviceFutures;

    public EmulatorLiveEditAdapter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cachedDeviceFutures = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void register(@NotNull String serial) {
        Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
        ((Map)this.cachedDeviceFutures).put(serial, Futures.immediateCancelledFuture());
    }

    public final void unregister(@NotNull String serial) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
            ListenableFuture<IDevice> listenableFuture = this.cachedDeviceFutures.remove(serial);
            if (listenableFuture == null) break block0;
            listenableFuture.cancel(true);
        }
    }

    @Override
    @Nullable
    public String serial(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return (String)dataContext.getData(RunningDevicesConstants.SERIAL_NUMBER_KEY);
    }

    @Override
    @Nullable
    public IDevice device(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        String string = this.serial(dataContext);
        if (string == null) {
            return null;
        }
        String serial = string;
        ListenableFuture<IDevice> listenableFuture = this.cachedDeviceFutures.get(serial);
        if (listenableFuture == null) {
            return null;
        }
        ListenableFuture<IDevice> future2 = listenableFuture;
        if (!future2.isCancelled()) {
            if (future2.isDone()) {
                IDevice device2 = (IDevice)future2.get();
                if (device2 != null && device2.isOnline()) {
                    return device2;
                }
            } else {
                return null;
            }
        }
        File file = AndroidSdkUtils.findAdb((Project)this.project).adbPath;
        if (file == null) {
            throw new Exception("Could not find adb executable");
        }
        File adbFile = file;
        ListenableFuture<AndroidDebugBridge> listenableFuture2 = AdbService.getInstance().getDebugBridge(adbFile);
        Intrinsics.checkNotNullExpressionValue(listenableFuture2, (String)"getDebugBridge(...)");
        ListenableFuture<AndroidDebugBridge> bridgeFuture = listenableFuture2;
        Map map2 = this.cachedDeviceFutures;
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        ListenableFuture listenableFuture3 = FutureUtils.transform(bridgeFuture, (Executor)executorService, arg_0 -> EmulatorLiveEditAdapter.device$lambda$1(serial, arg_0));
        map2.put(serial, listenableFuture3);
        return null;
    }

    @Override
    @NotNull
    public List<IDevice> devices() {
        List<IDevice> list = this.cachedDeviceFutures.values().stream().filter(arg_0 -> EmulatorLiveEditAdapter.devices$lambda$3(EmulatorLiveEditAdapter::devices$lambda$2, arg_0)).map(arg_0 -> EmulatorLiveEditAdapter.devices$lambda$5(EmulatorLiveEditAdapter::devices$lambda$4, arg_0)).filter(arg_0 -> EmulatorLiveEditAdapter.devices$lambda$7(EmulatorLiveEditAdapter::devices$lambda$6, arg_0)).map(arg_0 -> EmulatorLiveEditAdapter.devices$lambda$9(EmulatorLiveEditAdapter::devices$lambda$8, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    private static final IDevice device$lambda$1(String $serial, AndroidDebugBridge debugBridge) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)debugBridge, (String)"debugBridge");
            IDevice[] iDeviceArray = debugBridge.getDevices();
            Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"getDevices(...)");
            for (Object object2 : (Object[])iDeviceArray) {
                IDevice it = (IDevice)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)$serial)) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (IDevice)object;
    }

    private static final boolean devices$lambda$2(ListenableFuture it) {
        return it.isDone() && !it.isCancelled();
    }

    private static final boolean devices$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final IDevice devices$lambda$4(ListenableFuture it) {
        return (IDevice)it.get();
    }

    private static final IDevice devices$lambda$5(Function1 $tmp0, Object p0) {
        return (IDevice)$tmp0.invoke(p0);
    }

    private static final boolean devices$lambda$6(IDevice it) {
        return it != null;
    }

    private static final boolean devices$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final IDevice devices$lambda$8(IDevice it) {
        IDevice iDevice = it;
        Intrinsics.checkNotNull((Object)iDevice);
        return iDevice;
    }

    private static final IDevice devices$lambda$9(Function1 $tmp0, Object p0) {
        return (IDevice)$tmp0.invoke(p0);
    }
}

