/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.util;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.lang.management.ThreadInfo;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameInfo {
    public static final FrameInfo[] EMPTY_FRAME_INFOS = new FrameInfo[0];
    private static final String INDENT_STRING = "  ";
    private static final String INDENT_MARK_STRING = "+ ";
    private static final String[][] ourIdleApplicationImplThread = new String[][]{{"java.lang.Thread.run", "java.util.concurrent.ThreadPoolExecutor$Worker.run", "java.util.concurrent.ThreadPoolExecutor.runWorker", "java.util.concurrent.ThreadPoolExecutor.getTask", "java.util.concurrent.SynchronousQueue.poll", "java.util.concurrent.SynchronousQueue$TransferStack.transfer", "java.util.concurrent.locks.LockSupport.parkNanos", "jdk.internal.misc.Unsafe.park"}, {"java.util.concurrent.ForkJoinWorkerThread.run", "java.util.concurrent.ForkJoinPool.runWorker", "java.util.concurrent.ForkJoinPool.awaitWork", "java.util.concurrent.locks.LockSupport.park", "jdk.internal.misc.Unsafe.park"}, {"java.util.concurrent.ForkJoinWorkerThread.run", "java.util.concurrent.ForkJoinPool.runWorker", "java.util.concurrent.ForkJoinPool.awaitWork", "java.util.concurrent.locks.LockSupport.parkUntil", "jdk.internal.misc.Unsafe.park"}, {"java.lang.Thread.run", "java.util.concurrent.ThreadPoolExecutor$Worker.run", "java.util.concurrent.ThreadPoolExecutor.runWorker", "java.util.concurrent.ThreadPoolExecutor.getTask", "java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take", "java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take", "java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.awaitNanos", "java.util.concurrent.locks.LockSupport.parkNanos", "jdk.internal.misc.Unsafe.park"}, {"java.lang.Thread.run", "java.util.concurrent.ThreadPoolExecutor$Worker.run", "java.util.concurrent.ThreadPoolExecutor.runWorker", "java.util.concurrent.ThreadPoolExecutor.getTask", "java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take", "java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take", "java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject.await", "java.util.concurrent.locks.LockSupport.park", "sun.misc.Unsafe.park"}, {"java.lang.Thread.run", "java.util.concurrent.Executors$PrivilegedThreadFactory$1.run", "java.security.AccessController.doPrivileged", "java.security.AccessController.executePrivileged", "java.util.concurrent.Executors$PrivilegedThreadFactory$1$1.run", "java.util.concurrent.Executors$PrivilegedThreadFactory$1$1.run", "java.util.concurrent.ThreadPoolExecutor$Worker.run", "java.util.concurrent.ThreadPoolExecutor.runWorker", "java.util.concurrent.ThreadPoolExecutor.getTask", "java.util.concurrent.SynchronousQueue.poll", "java.util.concurrent.SynchronousQueue$TransferStack.transfer", "java.util.concurrent.locks.LockSupport.parkNanos", "jdk.internal.misc.Unsafe.park"}, {"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker.run", "kotlinx.coroutines.scheduling.CoroutineScheduler$Worker.runWorker", "kotlinx.coroutines.scheduling.CoroutineScheduler$Worker.tryPark", "kotlinx.coroutines.scheduling.CoroutineScheduler$Worker.park", "java.util.concurrent.locks.LockSupport.parkNanos", "jdk.internal.misc.Unsafe.park"}, {"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker.run", "kotlinx.coroutines.scheduling.CoroutineScheduler$Worker.runWorker", "java.util.concurrent.locks.LockSupport.parkNanos", "jdk.internal.misc.Unsafe.park"}};
    private static final boolean INCLUDE_SOURCE_INFO_IN_REPORT = true;
    private static final Comparator<StackTraceElement> STACK_TRACE_ELEMENT_COMPARATOR_NO_SOURCE = (a, b) -> ComparisonChain.start().compare((Object)a.getClassName(), (Object)b.getClassName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getMethodName(), (Object)b.getMethodName(), (Comparator)Ordering.natural().nullsFirst()).result();
    private static final Comparator<StackTraceElement> STACK_TRACE_ELEMENT_COMPARATOR_WITH_SOURCE = (a, b) -> ComparisonChain.start().compare((Object)a.getClassName(), (Object)b.getClassName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getMethodName(), (Object)b.getMethodName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getFileName(), (Object)b.getFileName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)a.getLineNumber(), (Object)b.getLineNumber(), (Comparator)Ordering.natural().nullsFirst()).result();
    private static final Comparator<StackTraceElement> STACK_TRACE_ELEMENT_COMPARATOR = STACK_TRACE_ELEMENT_COMPARATOR_WITH_SOURCE;
    private static final Comparator<FrameInfo> FRAME_INFO_COMPARATOR = (a, b) -> ComparisonChain.start().compare(b.myTimeSpent, a.myTimeSpent).compare((Object)a.myStackTraceElement, (Object)b.myStackTraceElement, STACK_TRACE_ELEMENT_COMPARATOR).result();
    private final StackTraceElement myStackTraceElement;
    private final SortedMap<StackTraceElement, FrameInfo> myChildren = new TreeMap<StackTraceElement, FrameInfo>(STACK_TRACE_ELEMENT_COMPARATOR);
    private long myTimeSpent;
    @Nullable
    private Set<String> leafInfo = null;

    public StackTraceElement getStackTraceElement() {
        return this.myStackTraceElement;
    }

    public long getTimeSpent() {
        return this.myTimeSpent;
    }

    FrameInfo(@Nullable StackTraceElement element) {
        this.myStackTraceElement = element;
    }

    @Nullable
    public FrameInfo getHottestSubframe() {
        FrameInfo result2 = null;
        for (FrameInfo fi : this.myChildren.values()) {
            if (result2 != null && fi.myTimeSpent <= result2.myTimeSpent) continue;
            result2 = fi;
        }
        return result2;
    }

    public void addThreadInfo(@NotNull ThreadInfo ti, long timeSpent) {
        this.addThreadInfo(ti, timeSpent, null);
    }

    public void addThreadInfo(@NotNull ThreadInfo ti, long timeSpent, @Nullable String leafInfo) {
        if (FrameInfo.isIdleThread(ti)) {
            return;
        }
        this.addStack(ti.getStackTrace(), timeSpent, leafInfo);
    }

    public void addStack(@NotNull StackTraceElement[] stackTrace, long timeSpent, @Nullable String leafInfo) {
        FrameInfo currentFrameInfo = this;
        for (int index = stackTrace.length - 1; index >= 0; --index) {
            currentFrameInfo.myTimeSpent += timeSpent;
            StackTraceElement element = stackTrace[index];
            FrameInfo fi = (FrameInfo)currentFrameInfo.myChildren.get(element);
            if (fi == null) {
                fi = new FrameInfo(element);
                currentFrameInfo.myChildren.put(element, fi);
            }
            currentFrameInfo = fi;
        }
        if (leafInfo != null) {
            if (currentFrameInfo.leafInfo == null) {
                currentFrameInfo.leafInfo = Sets.newHashSet();
            }
            currentFrameInfo.leafInfo.add(leafInfo);
        }
        currentFrameInfo.myTimeSpent += timeSpent;
    }

    public String getReportString(long frameTimeIgnoreThreshold) {
        StringBuilder indentString = new StringBuilder();
        return this.getReportStringWithIndent(frameTimeIgnoreThreshold, indentString, false);
    }

    @NotNull
    private String getReportStringWithIndent(long frameTimeIgnoreThreshold, @NotNull StringBuilder indentString, boolean addMark) {
        boolean shouldIndent;
        StringBuilder sb = new StringBuilder();
        if (addMark) {
            sb.append(indentString.subSequence(0, indentString.length() - INDENT_MARK_STRING.length()));
            sb.append(INDENT_MARK_STRING);
        } else {
            sb.append((CharSequence)indentString);
        }
        this.appendStackTraceForCurrentFrame(sb);
        sb.append(" [").append(this.myTimeSpent).append("ms]");
        sb.append('\n');
        if (this.leafInfo != null) {
            sb.append((CharSequence)indentString).append("{").append(String.join((CharSequence)";", this.leafInfo)).append("}").append('\n');
        }
        FrameInfo[] childFrames = this.myChildren.values().toArray(EMPTY_FRAME_INFOS);
        Arrays.sort(childFrames, FRAME_INFO_COMPARATOR);
        boolean bl = shouldIndent = Arrays.stream(childFrames).filter(fi -> fi.myTimeSpent > frameTimeIgnoreThreshold).count() > 1L;
        if (shouldIndent) {
            indentString.append(INDENT_STRING);
        }
        for (FrameInfo fi2 : childFrames) {
            if (fi2.myTimeSpent <= frameTimeIgnoreThreshold) continue;
            sb.append(fi2.getReportStringWithIndent(frameTimeIgnoreThreshold, indentString, shouldIndent));
        }
        if (shouldIndent) {
            indentString.delete(indentString.length() - INDENT_STRING.length(), indentString.length());
        }
        return sb.toString();
    }

    public void appendStackTraceForCurrentFrame(@NotNull StringBuilder sb) {
        if (this.myStackTraceElement != null) {
            sb.append(this.myStackTraceElement.toString());
        }
    }

    boolean exists(Predicate<StackTraceElement> predicate) {
        ArrayDeque<FrameInfo> queue = new ArrayDeque<FrameInfo>();
        queue.add(this);
        while (!queue.isEmpty()) {
            FrameInfo info = (FrameInfo)queue.remove();
            queue.addAll(info.myChildren.values());
            StackTraceElement stackTraceElement = info.myStackTraceElement;
            if (stackTraceElement == null || !predicate.test(stackTraceElement)) continue;
            return true;
        }
        return false;
    }

    int computeMaxDepth() {
        int depth = 0;
        ArrayDeque<FrameInfo> queue = new ArrayDeque<FrameInfo>();
        ArrayDeque<FrameInfo> queueNextLevel = new ArrayDeque<FrameInfo>();
        queue.add(this);
        while (!queue.isEmpty()) {
            ++depth;
            while (!queue.isEmpty()) {
                FrameInfo info = (FrameInfo)queue.remove();
                queueNextLevel.addAll(info.myChildren.values());
            }
            ArrayDeque<FrameInfo> tmp = queue;
            queue = queueNextLevel;
            queueNextLevel = tmp;
        }
        return depth;
    }

    private static boolean isIdleThread(ThreadInfo ti) {
        StackTraceElement[] stackTraceElements = ti.getStackTrace();
        for (String[] templateIdleStack : ourIdleApplicationImplThread) {
            StackTraceElement stackTraceElement;
            int i;
            if (stackTraceElements.length != templateIdleStack.length) continue;
            for (i = 0; i < templateIdleStack.length && templateIdleStack[i].equals((stackTraceElement = stackTraceElements[stackTraceElements.length - i - 1]).getClassName() + "." + stackTraceElement.getMethodName()); ++i) {
            }
            if (i != templateIdleStack.length) continue;
            return true;
        }
        return false;
    }
}

