/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.report;

import com.android.adblib.ServerStatus;
import com.android.tools.idea.adb.AdbServerStatusRetriever;
import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/diagnostics/report/AdbHostLogFileProvider;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticsSummaryFileProvider;", "<init>", "()V", "SERVER_STATUS_FILE", "", "name", "getName", "()Ljava/lang/String;", "getFiles", "", "Lcom/android/tools/idea/diagnostics/report/FileInfo;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
public final class AdbHostLogFileProvider
implements DiagnosticsSummaryFileProvider {
    @NotNull
    public static final AdbHostLogFileProvider INSTANCE = new AdbHostLogFileProvider();
    @NotNull
    private static final String SERVER_STATUS_FILE = "server-status.log";

    private AdbHostLogFileProvider() {
    }

    @Override
    @NotNull
    public String getName() {
        return "Adb Host";
    }

    @Override
    @NotNull
    public List<FileInfo> getFiles(@Nullable Project project) {
        if (!((Boolean)StudioFlags.ADB_HOST_LOGS_ENABLED.get()).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        ServerStatus serverStatus = (ServerStatus)AdbServerStatusRetriever.Companion.getInstance(project).getServerStatus().getValue();
        if (serverStatus == null) {
            return CollectionsKt.emptyList();
        }
        ServerStatus serverStatus2 = serverStatus;
        String string = PathManager.getLogPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogPath(...)");
        Path serverStatusOutputFile = DiagnosticsSummaryFileProvider.Companion.getDiagnosticsDirectoryPath(string).resolve(SERVER_STATUS_FILE);
        Files.writeString(serverStatusOutputFile, (CharSequence)serverStatus2.toString(), new OpenOption[0]);
        Object[] objectArray = new FileInfo[2];
        Path path = Paths.get(serverStatus2.getAbsoluteLogPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = Paths.get(serverStatus2.getAbsoluteLogPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getFileName(...)");
        objectArray[0] = new FileInfo(path, path3);
        Intrinsics.checkNotNull((Object)serverStatusOutputFile);
        Path path4 = Paths.get(SERVER_STATUS_FILE, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        objectArray[1] = new FileInfo(serverStatusOutputFile, path4);
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

