/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.analysis;

import com.android.tools.idea.diagnostics.TruncatingStringBuilder;
import com.android.tools.idea.diagnostics.jfr.analysis.CallTree;
import com.android.tools.idea.diagnostics.jfr.analysis.Freeze;
import com.android.tools.idea.diagnostics.jfr.analysis.IdleStacks;
import com.android.tools.idea.diagnostics.jfr.analysis.Sample;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.consumer.RecordingFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t*\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/JfrAnalyzer;", "", "<init>", "()V", "analyze", "", "path", "Ljava/nio/file/Path;", "getStacktrace", "", "Ljdk/jfr/consumer/RecordedEvent;", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nJfrAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrAnalyzer.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/JfrAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,116:1\n774#2:117\n865#2,2:118\n1491#2:120\n1516#2,3:121\n1519#2,3:131\n774#2:135\n865#2,2:136\n1056#2:138\n1878#2,3:139\n1068#2:143\n1869#2,2:144\n1563#2:146\n1634#2,3:147\n382#3,7:124\n216#4:134\n217#4:142\n*S KotlinDebug\n*F\n+ 1 JfrAnalyzer.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/JfrAnalyzer\n*L\n71#1:117\n71#1:118,2\n72#1:120\n72#1:121,3\n72#1:131,3\n77#1:135\n77#1:136,2\n77#1:138\n78#1:139,3\n100#1:143\n100#1:144,2\n106#1:146\n106#1:147,3\n72#1:124,7\n73#1:134\n73#1:142\n*E\n"})
public final class JfrAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> SAMPLING_EVENT_NAMES;
    @NotNull
    private static final String FREEZE_EVENT_NAME = "com.android.tools.idea.FreezeEvent";
    @NotNull
    private static final String EDT = "AWT-EventQueue-0";
    private static final int MAX_REPORT_LENGTH_BYTES = 200000;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String analyze(@NotNull Path path) {
        void $this$forEach$iv;
        void $this$forEach$iv2;
        Iterator $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        RecordedEvent it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        RecordingFile recordingFile = new RecordingFile(path);
        List events = new ArrayList();
        Map threadIdToName = new LinkedHashMap();
        long edtId = 0L;
        RecordedEvent freezeEvent = null;
        while (recordingFile.hasMoreEvents()) {
            RecordedEvent event = recordingFile.readEvent();
            Intrinsics.checkNotNull((Object)event);
            events.add(event);
            if (Intrinsics.areEqual((Object)event.getEventType().getName(), (Object)FREEZE_EVENT_NAME)) {
                freezeEvent = event;
                continue;
            }
            if (!SAMPLING_EVENT_NAMES.contains(event.getEventType().getName())) continue;
            RecordedThread thread = event.getThread("sampledThread");
            threadIdToName.put(thread.getJavaThreadId(), thread.getJavaName());
            if (!Intrinsics.areEqual((Object)thread.getJavaName(), (Object)EDT)) continue;
            edtId = thread.getJavaThreadId();
        }
        if (freezeEvent == null) {
            return "No freeze event.";
        }
        Freeze freeze = new Freeze(freezeEvent.getStartTime().toEpochMilli() - (long)freezeEvent.getInt("startOffsetMs"), freezeEvent.getEndTime().toEpochMilli());
        Iterable $this$filter$iv = events;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            if (!SAMPLING_EVENT_NAMES.contains(it.getEventType().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            Long key$iv$iv = it.getThread("sampledThread").getJavaThreadId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv2.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            void $this$sortedBy$iv;
            void $this$filterTo$iv$iv2;
            Map.Entry element$iv;
            Map.Entry $i$f$groupByTo2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            long tid = ((Number)$i$f$groupByTo2.getKey()).longValue();
            List sampleEvents = (List)$i$f$groupByTo2.getValue();
            Object v = threadIdToName.get(tid);
            Intrinsics.checkNotNull(v);
            String threadName = (String)v;
            if (IdleStacks.Companion.isIgnoredThread(threadName)) continue;
            List samples = new ArrayList();
            Iterable $this$filter$iv2 = sampleEvents;
            boolean $i$f$filter2 = false;
            Iterable answer$iv$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                RecordedEvent it2 = (RecordedEvent)element$iv$iv;
                boolean bl3 = false;
                Instant instant = it2.getStartTime();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"getStartTime(...)");
                if (!freeze.containsInstant(instant)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$sortedBy = false;
            List sortedEvents = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RecordedEvent it = (RecordedEvent)a;
                    boolean bl = false;
                    Comparable comparable = it.getStartTime();
                    it = (RecordedEvent)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getStartTime());
                }
            });
            Iterable $this$forEachIndexed$iv = sortedEvents;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void e;
                int n;
                Object element$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv = (RecordedEvent)item$iv;
                int i = n;
                boolean bl4 = false;
                long nextEventTime = i + 1 == sortedEvents.size() ? freeze.getEndTime() : ((RecordedEvent)sortedEvents.get(i + 1)).getStartTime().toEpochMilli();
                List stacktrace = this.getStacktrace((RecordedEvent)e);
                if (IdleStacks.Companion.isIdle(threadName, stacktrace)) {
                    stacktrace = CollectionsKt.listOf((Object)"IDLE.IDLE(Unknown Source)");
                }
                Instant instant = e.getStartTime();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"getStartTime(...)");
                samples.add(new Sample(threadName, instant, nextEventTime - e.getStartTime().toEpochMilli(), stacktrace, e.getStackTrace().isTruncated()));
            }
            if (!(!((Collection)samples).isEmpty())) continue;
            freeze.getSamples().put(tid, samples);
        }
        Map<Long, CallTree> callTrees = freeze.aggregateCallTrees();
        CallTree edtTree = callTrees.remove(edtId);
        TruncatingStringBuilder sb = new TruncatingStringBuilder(200000, "\n...report truncated...");
        if (edtTree != null) {
            sb.append(JfrAnalyzer.analyze$getThreadReport(threadIdToName, edtId, edtTree));
        }
        Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)callTrees.entrySet());
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((CallTree)it.getValue()).numNodesAboveCutoff());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((CallTree)it.getValue()).numNodesAboveCutoff()));
            }
        });
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            long tid = ((Number)entry.getKey()).longValue();
            CallTree tree = (CallTree)entry.getValue();
            sb.append(JfrAnalyzer.analyze$getThreadReport(threadIdToName, tid, tree));
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getStacktrace(RecordedEvent $this$getStacktrace) {
        void $this$mapTo$iv$iv;
        List<RecordedFrame> list = $this$getStacktrace.getStackTrace().getFrames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFrames(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void frame;
            RecordedFrame recordedFrame = (RecordedFrame)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(frame.getMethod().getType().getName() + "." + frame.getMethod().getName() + (String)(frame.getLineNumber() == -1 ? "(Unknown Source)" : "(?:" + frame.getLineNumber() + ")"));
        }
        return (List)destination$iv$iv;
    }

    private static final String analyze$getThreadReport(Map<Long, String> threadIdToName, long tid, CallTree tree) {
        StringBuilder stringBuilder;
        StringBuilder $this$analyze_u24getThreadReport_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$analyze_u24getThreadReport_u24lambda_u246.append(threadIdToName.get(tid) + ", TID: " + tid + " [" + tree.getTime() + "ms] (" + tree.getSampleCount() + " samples");
        $this$analyze_u24getThreadReport_u24lambda_u246.append((String)(tree.getTruncatedSampleCount() > 0 ? "; omitted " + tree.getTruncatedSampleCount() + " truncated stacks)" : ")"));
        $this$analyze_u24getThreadReport_u24lambda_u246.append("\n" + tree + "\n");
        return stringBuilder.toString();
    }

    static {
        Object[] objectArray = new String[]{"jdk.ExecutionSample", "jdk.NativeMethodSample"};
        SAMPLING_EVENT_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/JfrAnalyzer$Companion;", "", "<init>", "()V", "SAMPLING_EVENT_NAMES", "", "", "FREEZE_EVENT_NAME", "EDT", "MAX_REPORT_LENGTH_BYTES", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

