/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.util.TreeNode;
import com.android.tools.idea.diagnostics.hprof.util.TreeVisualizer;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer;", "", "<init>", "()V", "visualizeTree", "", "root", "Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;", "buffer", "Lcom/android/tools/idea/diagnostics/hprof/util/TruncatingPrintBuffer;", "options", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$DisposerTreeSummaryOptions;", "IndentStore", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nTreeVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeVisualizer.kt\ncom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1#2:57\n1869#3,2:58\n*S KotlinDebug\n*F\n+ 1 TreeVisualizer.kt\ncom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer\n*L\n52#1:58,2\n*E\n"})
public final class TreeVisualizer {
    public final void visualizeTree(@NotNull TreeNode root, @NotNull TruncatingPrintBuffer buffer, @NotNull AnalysisConfig.DisposerTreeSummaryOptions options) {
        Stack<StackItem> stack;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Stack<StackItem> $this$visualizeTree_u24lambda_u240 = stack = new Stack<StackItem>();
        boolean bl = false;
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"com/android/tools/idea/diagnostics/hprof/util/TreeVisualizer$visualizeTree$StackItem", "", "node", "Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;", "depth", "", "<init>", "(Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;I)V", "getNode", "()Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;", "getDepth", "()I", "component1", "component2", "copy", "(Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;I)Lcom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer$visualizeTree$StackItem;", "equals", "", "other", "hashCode", "toString", "", "intellij.android.core"})
        public final class StackItem {
            private final TreeNode node;
            private final int depth;

            public StackItem(TreeNode node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.node = node;
                this.depth = depth;
            }

            public final TreeNode getNode() {
                return this.node;
            }

            public final int getDepth() {
                return this.depth;
            }

            public final TreeNode component1() {
                return this.node;
            }

            public final int component2() {
                return this.depth;
            }

            public final StackItem copy(TreeNode node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return new StackItem(node, depth);
            }

            public static /* synthetic */ StackItem copy$default(StackItem stackItem, TreeNode treeNode, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    treeNode = stackItem.node;
                }
                if ((n2 & 2) != 0) {
                    n = stackItem.depth;
                }
                return stackItem.copy(treeNode, n);
            }

            public String toString() {
                return "StackItem(node=" + this.node + ", depth=" + this.depth + ")";
            }

            public int hashCode() {
                int result2 = this.node.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.depth);
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StackItem)) {
                    return false;
                }
                StackItem stackItem = (StackItem)other;
                if (!Intrinsics.areEqual((Object)this.node, (Object)stackItem.node)) {
                    return false;
                }
                return this.depth == stackItem.depth;
            }
        }
        $this$visualizeTree_u24lambda_u240.push(new StackItem(root, 0));
        Stack<StackItem> nodeStack = stack;
        IndentStore indentStore = new IndentStore();
        while (!nodeStack.empty()) {
            StackItem stackItem = (StackItem)nodeStack.pop();
            TreeNode node = stackItem.component1();
            int depth = stackItem.component2();
            String indent = indentStore.getIndentForDepth(depth);
            buffer.println(indent + node.description());
            List children2 = CollectionsKt.reversed((Iterable)node.children());
            if (depth >= options.getMaxDepth() && !((Collection)children2).isEmpty()) {
                buffer.println(indentStore.getIndentForDepth(depth + 1) + "[...]");
                continue;
            }
            Iterable $this$forEach$iv = children2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeNode child = (TreeNode)element$iv;
                boolean bl2 = false;
                nodeStack.push(new StackItem(child, depth + 1));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer$IndentStore;", "", "<init>", "()V", "map", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "getIndentForDepth", "size", "", "intellij.android.core"})
    private static final class IndentStore {
        @NotNull
        private final Int2ObjectOpenHashMap<String> map = new Int2ObjectOpenHashMap();

        @NotNull
        public final String getIndentForDepth(int size) {
            if (this.map.containsKey(size)) {
                Object object = this.map.get(size);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                return (String)object;
            }
            String indent = StringsKt.repeat((CharSequence)"  ", (int)size);
            ((Map)this.map).put(size, indent);
            return indent;
        }
    }
}

