/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisReport;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalyzeGraph;
import com.android.tools.idea.diagnostics.hprof.analysis.ClassNomination;
import com.android.tools.idea.diagnostics.hprof.analysis.HProfAnalysis;
import com.android.tools.idea.diagnostics.hprof.classstore.HProfMetadata;
import com.android.tools.idea.diagnostics.hprof.histogram.Histogram;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedIntList;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedUByteList;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedUShortList;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.IDMapper;
import com.android.tools.idea.diagnostics.hprof.util.IntList;
import com.android.tools.idea.diagnostics.hprof.util.ListProvider;
import com.android.tools.idea.diagnostics.hprof.util.PartialProgressIndicator;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import com.android.tools.idea.diagnostics.hprof.util.UShortList;
import com.android.tools.idea.diagnostics.hprof.visitors.RemapIDsVisitor;
import com.google.common.base.Stopwatch;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005*\u0001\u0014\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis;", "", "hprofFileChannel", "Ljava/nio/channels/FileChannel;", "tempFilenameSupplier", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "<init>", "(Ljava/nio/channels/FileChannel;Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;)V", "tempFiles", "", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFile;", "includeMetaInfo", "", "setIncludeMetaInfo", "", "value", "openTempEmptyFileChannel", "type", "", "fileBackedListProvider", "com/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$fileBackedListProvider$1", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$fileBackedListProvider$1;", "analyze", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$AnalysisResult;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isSupported", "instanceCount", "", "closeAndDeleteTemporaryFiles", "TempFilenameSupplier", "TempFile", "AnalysisResult", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nHProfAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HProfAnalysis.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1563#2:214\n1634#2,3:215\n1869#2,2:218\n1869#2:220\n1870#2:222\n1#3:221\n*S KotlinDebug\n*F\n+ 1 HProfAnalysis.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis\n*L\n147#1:214\n147#1:215,3\n175#1:218,2\n198#1:220\n198#1:222\n*E\n"})
public final class HProfAnalysis {
    @NotNull
    private final FileChannel hprofFileChannel;
    @NotNull
    private final TempFilenameSupplier tempFilenameSupplier;
    @NotNull
    private final List<TempFile> tempFiles;
    private boolean includeMetaInfo;
    @NotNull
    private final fileBackedListProvider.1 fileBackedListProvider;

    public HProfAnalysis(@NotNull FileChannel hprofFileChannel, @NotNull TempFilenameSupplier tempFilenameSupplier) {
        Intrinsics.checkNotNullParameter((Object)hprofFileChannel, (String)"hprofFileChannel");
        Intrinsics.checkNotNullParameter((Object)tempFilenameSupplier, (String)"tempFilenameSupplier");
        this.hprofFileChannel = hprofFileChannel;
        this.tempFilenameSupplier = tempFilenameSupplier;
        this.tempFiles = new ArrayList();
        this.includeMetaInfo = true;
        this.fileBackedListProvider = new ListProvider(this){
            final /* synthetic */ HProfAnalysis this$0;
            {
                this.this$0 = $receiver;
            }

            public UByteList createUByteList(String name2, long size) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return FileBackedUByteList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name2), size);
            }

            public UShortList createUShortList(String name2, long size) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return FileBackedUShortList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name2), size);
            }

            public IntList createIntList(String name2, long size) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return FileBackedIntList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name2), size);
            }
        };
    }

    @TestOnly
    public final void setIncludeMetaInfo(boolean value2) {
        this.includeMetaInfo = value2;
    }

    private final FileChannel openTempEmptyFileChannel(String type) {
        Path tempPath = this.tempFilenameSupplier.getTempFilePath(type);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE};
        FileChannel tempChannel = FileChannel.open(tempPath, openOptionArray);
        Intrinsics.checkNotNull((Object)tempChannel);
        this.tempFiles.add(new TempFile(type, tempPath, tempChannel));
        return tempChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisResult analyze(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        StringBuilder result2 = new StringBuilder();
        String summary = "";
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        Stopwatch prepareFilesStopwatch = Stopwatch.createStarted();
        Stopwatch analysisStopwatch = Stopwatch.createUnstarted();
        progress2.setText("Analyze Heap");
        progress2.setText2("Open heap file");
        progress2.setFraction(0.0);
        HProfEventBasedParser parser = new HProfEventBasedParser(this.hprofFileChannel);
        try {
            void $this$mapTo$iv$iv;
            progress2.setText2("Collect heap metadata");
            progress2.setFraction(0.0);
            HProfMetadata hprofMetadata = HProfMetadata.Companion.create(parser);
            progress2.setText2("Create histogram");
            progress2.setFraction(0.1);
            Histogram histogram = Histogram.Companion.create(parser, hprofMetadata.getClassStore());
            List<HistogramEntry> nominatedClasses = new ClassNomination(histogram, 5).nominateClasses();
            progress2.setText2("Remap object IDs");
            progress2.setFraction(0.2);
            if (!this.isSupported(histogram.getInstanceCount())) {
                result2.append(histogram.prepareReport("All", 50)).append('\n');
                String string = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                AnalysisResult analysisResult = new AnalysisResult(string, summary);
                return analysisResult;
            }
            FileChannel idMappingChannel = this.openTempEmptyFileChannel("id-mapping");
            RemapIDsVisitor remapIDsVisitor = RemapIDsVisitor.Companion.createFileBased(idMappingChannel, histogram.getInstanceCount());
            parser.accept(remapIDsVisitor, "id mapping");
            IDMapper idMapper = remapIDsVisitor.getIDMapper();
            parser.setIDMapper(idMapper);
            hprofMetadata.remapIds(idMapper);
            progress2.setText2("Create reference graph");
            progress2.setFraction(0.3);
            ObjectNavigator navigator = ObjectNavigator.Companion.createOnAuxiliaryFiles(parser, this.openTempEmptyFileChannel("auxOffset"), this.openTempEmptyFileChannel("aux"), hprofMetadata, histogram.getInstanceCount());
            prepareFilesStopwatch.stop();
            IntList parentList = this.fileBackedListProvider.createIntList("parents", navigator.getInstanceCount() + 1L);
            IntList sizesList = this.fileBackedListProvider.createIntList("sizes", navigator.getInstanceCount() + 1L);
            IntList visitedList = this.fileBackedListProvider.createIntList("visited", navigator.getInstanceCount() + 1L);
            UByteList refIndexList = this.fileBackedListProvider.createUByteList("refIndex", navigator.getInstanceCount() + 1L);
            analysisStopwatch.start();
            Iterable $this$map$iv = nominatedClasses;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HistogramEntry histogramEntry = (HistogramEntry)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getClassDefinition().getName());
            }
            List nominatedClassNames = (List)destination$iv$iv;
            AnalysisConfig analysisConfig = new AnalysisConfig(new AnalysisConfig.PerClassOptions(nominatedClassNames, false, null, 6, null), null, null, null, new AnalysisConfig.MetaInfoOptions(this.includeMetaInfo), null, null, null, 238, null);
            AnalysisContext analysisContext = new AnalysisContext(navigator, analysisConfig, parentList, sizesList, visitedList, refIndexList, histogram);
            AnalysisReport analysisReport = new AnalyzeGraph(analysisContext, this.fileBackedListProvider).analyze((ProgressIndicator)new PartialProgressIndicator(progress2, 0.4, 0.4));
            String string = analysisReport.getSummary().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            summary = string;
            StringBuilder stringBuilder = result2.append((CharSequence)analysisReport.getMainReport());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            stringBuilder.append('\n');
            analysisStopwatch.stop();
            if (this.includeMetaInfo) {
                result2.append(HeapReportUtils.INSTANCE.sectionHeader("Analysis information")).append('\n');
                result2.append("Prepare files duration: " + prepareFilesStopwatch).append('\n');
                result2.append("Analysis duration: " + analysisStopwatch).append('\n');
                result2.append("TOTAL DURATION: " + totalStopwatch).append('\n');
                result2.append("Temp files:").append('\n');
                result2.append("  heapdump = " + HeapReportUtils.INSTANCE.toShortStringAsCount(this.hprofFileChannel.size())).append('\n');
                Iterable $this$forEach$iv = this.tempFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TempFile temp = (TempFile)element$iv;
                    boolean bl = false;
                    FileChannel channel = temp.getChannel();
                    if (!channel.isOpen()) continue;
                    result2.append("  " + temp.getType() + " = " + HeapReportUtils.INSTANCE.toShortStringAsCount(channel.size())).append('\n');
                }
                StringBuilder stringBuilder2 = result2.append((CharSequence)analysisReport.getMetaInfo());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                stringBuilder2.append('\n');
            }
        }
        finally {
            parser.close();
            this.closeAndDeleteTemporaryFiles();
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new AnalysisResult(string, summary);
    }

    private final boolean isSupported(long instanceCount) {
        return RemapIDsVisitor.Companion.isSupported(instanceCount) && instanceCount <= Integer.MAX_VALUE;
    }

    private final void closeAndDeleteTemporaryFiles() {
        Iterable $this$forEach$iv = this.tempFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TempFile tempFile = (TempFile)element$iv;
            boolean bl = false;
            try {
                tempFile.getChannel().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Path it = tempFile.getPath();
                boolean bl2 = false;
                Files.deleteIfExists(it);
            }
            catch (Throwable throwable) {
            }
        }
        this.tempFiles.clear();
    }

    public static final /* synthetic */ FileChannel access$openTempEmptyFileChannel(HProfAnalysis $this, String type) {
        return $this.openTempEmptyFileChannel(type);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$AnalysisResult;", "", "report", "", "summary", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getReport", "()Ljava/lang/String;", "getSummary", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    public static final class AnalysisResult {
        @NotNull
        private final String report;
        @NotNull
        private final String summary;

        public AnalysisResult(@NotNull String report, @NotNull String summary) {
            Intrinsics.checkNotNullParameter((Object)report, (String)"report");
            Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
            this.report = report;
            this.summary = summary;
        }

        @NotNull
        public final String getReport() {
            return this.report;
        }

        @NotNull
        public final String getSummary() {
            return this.summary;
        }

        @NotNull
        public final String component1() {
            return this.report;
        }

        @NotNull
        public final String component2() {
            return this.summary;
        }

        @NotNull
        public final AnalysisResult copy(@NotNull String report, @NotNull String summary) {
            Intrinsics.checkNotNullParameter((Object)report, (String)"report");
            Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
            return new AnalysisResult(report, summary);
        }

        public static /* synthetic */ AnalysisResult copy$default(AnalysisResult analysisResult, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = analysisResult.report;
            }
            if ((n & 2) != 0) {
                string2 = analysisResult.summary;
            }
            return analysisResult.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AnalysisResult(report=" + this.report + ", summary=" + this.summary + ")";
        }

        public int hashCode() {
            int result2 = this.report.hashCode();
            result2 = result2 * 31 + this.summary.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnalysisResult)) {
                return false;
            }
            AnalysisResult analysisResult = (AnalysisResult)other;
            if (!Intrinsics.areEqual((Object)this.report, (Object)analysisResult.report)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.summary, (Object)analysisResult.summary);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFile;", "", "type", "", "path", "Ljava/nio/file/Path;", "channel", "Ljava/nio/channels/FileChannel;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/channels/FileChannel;)V", "getType", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "getChannel", "()Ljava/nio/channels/FileChannel;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    private static final class TempFile {
        @NotNull
        private final String type;
        @NotNull
        private final Path path;
        @NotNull
        private final FileChannel channel;

        public TempFile(@NotNull String type, @NotNull Path path, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.type = type;
            this.path = path;
            this.channel = channel;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final FileChannel getChannel() {
            return this.channel;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final Path component2() {
            return this.path;
        }

        @NotNull
        public final FileChannel component3() {
            return this.channel;
        }

        @NotNull
        public final TempFile copy(@NotNull String type, @NotNull Path path, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            return new TempFile(type, path, channel);
        }

        public static /* synthetic */ TempFile copy$default(TempFile tempFile, String string, Path path, FileChannel fileChannel, int n, Object object) {
            if ((n & 1) != 0) {
                string = tempFile.type;
            }
            if ((n & 2) != 0) {
                path = tempFile.path;
            }
            if ((n & 4) != 0) {
                fileChannel = tempFile.channel;
            }
            return tempFile.copy(string, path, fileChannel);
        }

        @NotNull
        public String toString() {
            return "TempFile(type=" + this.type + ", path=" + this.path + ", channel=" + this.channel + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + ((Object)this.path).hashCode();
            result2 = result2 * 31 + this.channel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempFile)) {
                return false;
            }
            TempFile tempFile = (TempFile)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)tempFile.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)tempFile.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.channel, (Object)tempFile.channel);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "", "getTempFilePath", "Ljava/nio/file/Path;", "type", "", "intellij.android.core"})
    public static interface TempFilenameSupplier {
        @NotNull
        public Path getTempFilePath(@NotNull String var1);
    }
}

