/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ExceededClusterStatistics;
import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.ExtendedStackNode;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.diagnostics.heap.RootPathTreeNode;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootPathTree {
    static final int MAX_NUMBER_OF_NOMINATED_NODE_TYPES = 12;
    static final int DISPOSED_BUT_REFERENCED_NOMINATED_NODE_TYPE = 9;
    static final int OBJECT_REFERRING_LOADER_NOMINATED_NODE_TYPE = 10;
    static final int HEAP_SUMMARY_NODE_TYPE = 11;
    static final IntSet ESSENTIAL_NOMINATED_NODE_TYPES = IntSet.of((int)9, (int)10);
    @NotNull
    final Map<ExtendedStackNode, RootPathTreeNode> roots = Maps.newHashMap();
    @NotNull
    final ObjectsStatistics totalNominatedLoadersReferringObjectsStatistics = new ObjectsStatistics();
    @NotNull
    final ObjectsStatistics totalRetainedDisposedObjectsStatistics = new ObjectsStatistics();
    private int numberOfRootPathTreeNodes = 0;
    private final ExtendedReportStatistics extendedReportStatistics;
    private static final int ROOT_PATH_TREE_MAX_OBJECT_DEPTH = 200;

    public RootPathTree(@NotNull ExtendedReportStatistics extendedReportStatistics) {
        this.extendedReportStatistics = extendedReportStatistics;
    }

    public void addDisposedReferencedObjectWithPathToRoot(@NotNull Stack<RootPathElement> rootPath, @NotNull ExceededClusterStatistics exceededClusterStatistics) {
        this.addObjectWithPathToRoot(rootPath, exceededClusterStatistics, 9);
        this.totalRetainedDisposedObjectsStatistics.addObject(((RootPathElement)rootPath.lastElement()).size);
    }

    public void addClassLoaderPath(@NotNull Stack<RootPathElement> rootPath, @NotNull ExceededClusterStatistics exceededClusterStatistics) {
        this.addObjectWithPathToRoot(rootPath, exceededClusterStatistics, 10);
        this.totalNominatedLoadersReferringObjectsStatistics.addObject(((RootPathElement)rootPath.lastElement()).size);
    }

    public void addObjectWithPathToRoot(@NotNull Stack<RootPathElement> rootPath, @NotNull ExceededClusterStatistics exceededClusterStatistics, int nominatedNodeTypeId) {
        if (rootPath.size() > 200 && !ESSENTIAL_NOMINATED_NODE_TYPES.contains(nominatedNodeTypeId)) {
            return;
        }
        ListIterator<RootPathElement> rootPathIterator = rootPath.listIterator(rootPath.size());
        int exceededClusterId = exceededClusterStatistics.exceededClusterIndex;
        RootPathTreeNode rootPathTreeNode = null;
        RootPathElement pathElement = null;
        while (rootPathIterator.hasPrevious()) {
            pathElement = (RootPathElement)rootPathIterator.previous();
            if (pathElement.rootPathTreeNode == null || !pathElement.isRootPathTreeNodeWasPropagated(exceededClusterId, nominatedNodeTypeId)) continue;
            rootPathIterator.next();
            rootPathTreeNode = pathElement.rootPathTreeNode;
            break;
        }
        if (rootPathTreeNode == null) {
            pathElement = (RootPathElement)rootPathIterator.next();
            if (pathElement.rootPathTreeNode != null) {
                rootPathTreeNode = pathElement.rootPathTreeNode;
            } else {
                rootPathTreeNode = this.roots.getOrDefault(pathElement.extendedStackNode, this.createRootPathTreeNode(pathElement, this.extendedReportStatistics));
                this.roots.put(pathElement.extendedStackNode, rootPathTreeNode);
            }
            rootPathTreeNode.incrementNumberOfInstances(exceededClusterId, nominatedNodeTypeId, pathElement.subtreeSize);
            pathElement.setRootPathTreeNode(rootPathTreeNode, exceededClusterId, nominatedNodeTypeId);
        }
        this.addPathElementIteration(rootPathTreeNode, pathElement, rootPathIterator, exceededClusterId, nominatedNodeTypeId);
    }

    private RootPathTreeNode createRootPathTreeNode(@NotNull RootPathElement rootPathElement, @NotNull ExtendedReportStatistics extendedReportStatistics) {
        ++this.numberOfRootPathTreeNodes;
        if (rootPathElement.isArray) {
            return new RootPathTreeNode.RootPathArrayTreeNode(rootPathElement.getLabel(), rootPathElement.getClassName(), rootPathElement.isDisposedButReferenced(), rootPathElement.isLoadedWithNominatedLoader(), extendedReportStatistics);
        }
        return new RootPathTreeNode(rootPathElement.getLabel(), rootPathElement.getClassName(), rootPathElement.isDisposedButReferenced(), rootPathElement.isLoadedWithNominatedLoader(), extendedReportStatistics);
    }

    private void addPathElementIteration(@NotNull RootPathTreeNode node, @NotNull RootPathElement currentRootPathElement, @NotNull ListIterator<RootPathElement> iterator2, int exceededClusterId, int nominatedNodeTypeId) {
        if (!iterator2.hasNext()) {
            node.markNodeAsNominated(exceededClusterId, nominatedNodeTypeId, currentRootPathElement.size);
            return;
        }
        RootPathElement rootPathElement = iterator2.next();
        if (node.label.equals(rootPathElement.getLabel()) && node.className.equals(rootPathElement.getClassName())) {
            node.isRepeated = true;
            assert (rootPathElement.rootPathTreeNode == null || rootPathElement.rootPathTreeNode == node);
            rootPathElement.setRootPathTreeNode(node, exceededClusterId, nominatedNodeTypeId);
            this.addPathElementIteration(node, rootPathElement, iterator2, exceededClusterId, nominatedNodeTypeId);
            return;
        }
        RootPathTreeNode childNode = node.children.get(rootPathElement.extendedStackNode);
        if (childNode == null) {
            childNode = Objects.requireNonNullElseGet(rootPathElement.rootPathTreeNode, () -> this.createRootPathTreeNode(rootPathElement, this.extendedReportStatistics));
            node.children.put(rootPathElement.extendedStackNode, childNode);
        }
        childNode.incrementNumberOfInstances(exceededClusterId, nominatedNodeTypeId, rootPathElement.subtreeSize);
        assert (rootPathElement.rootPathTreeNode == null || rootPathElement.rootPathTreeNode == childNode);
        rootPathElement.setRootPathTreeNode(childNode, exceededClusterId, nominatedNodeTypeId);
        this.addPathElementIteration(childNode, rootPathElement, iterator2, exceededClusterId, nominatedNodeTypeId);
    }

    public int getNumberOfRootPathTreeNodes() {
        return this.numberOfRootPathTreeNodes;
    }

    public static class RootPathElement {
        @NotNull
        final ExtendedStackNode extendedStackNode;
        private final long size;
        private long subtreeSize;
        private final boolean isArray;
        @Nullable
        private RootPathTreeNode rootPathTreeNode;
        private final short[] rootPathTreeNodeWasPropagated;

        public RootPathElement(@NotNull ExtendedStackNode node, long size, @NotNull ExtendedReportStatistics extendedReportStatistics, boolean isArray) {
            this.extendedStackNode = node;
            this.rootPathTreeNodeWasPropagated = new short[extendedReportStatistics.componentToExceededClustersStatistics.size()];
            this.size = size;
            this.subtreeSize = size;
            this.isArray = isArray;
        }

        boolean isRootPathTreeNodeWasPropagated(int exceededClusterId, int nominatedNodeTypeId) {
            return (this.rootPathTreeNodeWasPropagated[exceededClusterId] & 1 << nominatedNodeTypeId) != 0;
        }

        public String getClassName() {
            return this.extendedStackNode.getClassName();
        }

        @NotNull
        public String getLabel() {
            return this.extendedStackNode.getLabel();
        }

        public boolean isDisposedButReferenced() {
            return this.extendedStackNode.isDisposedButReferenced();
        }

        public boolean isLoadedWithNominatedLoader() {
            return this.extendedStackNode.isLoadedWithNominatedLoader();
        }

        public void setRootPathTreeNode(@Nullable RootPathTreeNode rootPathTreeNode, int exceededClusterId, int nominatedNodeTypeId) {
            this.rootPathTreeNode = rootPathTreeNode;
            int n = exceededClusterId;
            this.rootPathTreeNodeWasPropagated[n] = (short)(this.rootPathTreeNodeWasPropagated[n] | 1 << nominatedNodeTypeId);
        }

        public long getSize() {
            return this.size;
        }

        public long getSubtreeSize() {
            return this.subtreeSize;
        }

        public void addSubtreeSize(long size) {
            this.subtreeSize += size;
            if (this.rootPathTreeNode == null) {
                return;
            }
            for (int i = 0; i < this.rootPathTreeNodeWasPropagated.length; ++i) {
                int finalI = i;
                HeapTraverseUtil.processMask(this.rootPathTreeNodeWasPropagated[i], j -> this.rootPathTreeNode.instancesStatistics[finalI][j].addStats(0, size));
            }
        }

        public void update() {
            if (this.rootPathTreeNode == null) {
                return;
            }
            for (int i = 0; i < this.rootPathTreeNodeWasPropagated.length; ++i) {
                if (this.rootPathTreeNodeWasPropagated[i] == 0) continue;
                if (this.rootPathTreeNode.instancesStatistics[i][11] == null) {
                    this.rootPathTreeNode.instancesStatistics[i][11] = new ObjectsStatistics();
                }
                this.rootPathTreeNode.instancesStatistics[i][11].addObject(this.subtreeSize);
            }
        }
    }
}

