/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.DepthFirstSearchTraverse;
import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseChildProcessor;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseNode;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.MemoryReportJniHelper;
import com.android.tools.idea.diagnostics.heap.ObjectTagUtil;
import com.android.tools.idea.diagnostics.heap.StackNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.math.LongMath;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBusConnection;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class MemoryReportCollector
implements Disposable {
    static final Computable<WeakList<Object>> getLoadedClassesComputable = () -> {
        WeakList roots = new WeakList();
        Class<?>[] classes = MemoryReportJniHelper.getClasses();
        roots.addAll(Arrays.asList(classes));
        roots.addAll(Thread.getAllStackTraces().keySet());
        roots.addAll((Collection)Arrays.stream(classes).filter(c -> c instanceof Class).map(c -> ((Class)c).getClassLoader()).filter(Objects::nonNull).collect(Collectors.toSet()));
        return roots;
    };
    static final int MAX_ALLOWED_OBJECT_MAP_SIZE = 1000000;
    private static short ourIterationId = 0;
    @NotNull
    private final LowMemoryWatcher watcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived);
    @NotNull
    private final MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
    @NotNull
    final HeapTraverseChildProcessor heapTraverseChildProcessor;
    private final short iterationId;
    @NotNull
    private final HeapSnapshotStatistics statistics;
    private volatile boolean shouldAbortTraversal = false;

    public MemoryReportCollector(@NotNull HeapSnapshotStatistics statistics) {
        this(new HeapTraverseChildProcessor(statistics), statistics);
    }

    public MemoryReportCollector(@NotNull HeapTraverseChildProcessor childProcessor, @NotNull HeapSnapshotStatistics statistics) {
        this.messageBusConnection.subscribe(PowerSaveMode.TOPIC, () -> {
            if (PowerSaveMode.isEnabled()) {
                this.shouldAbortTraversal = true;
                this.messageBusConnection.disconnect();
            }
        });
        this.heapTraverseChildProcessor = childProcessor;
        this.iterationId = MemoryReportCollector.getNextIterationId();
        this.statistics = statistics;
    }

    @TestOnly
    MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode walkObjects(@NotNull List<Object> roots) {
        WeakList classes = new WeakList();
        classes.addAll(roots);
        return this.walkObjects((Computable<WeakList<Object>>)((Computable)() -> classes));
    }

    MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode walkObjects() {
        return this.walkObjects(getLoadedClassesComputable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode walkObjects(@NotNull Computable<WeakList<Object>> rootsComputable) {
        try {
            if (!MemoryReportJniHelper.canTagObjects()) {
                MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.CANT_TAG_OBJECTS;
                return statusCode;
            }
            try {
                StackNode.cacheStackNodeConstructorId(StackNode.class);
                FieldCache fieldCache = new FieldCache(this.statistics);
                StackNode.clearDepthFirstSearchStack();
                this.clearObjectIdToTraverseNodeMap();
                HeapTraverseNode.cacheHeapSnapshotTraverseNodeConstructorId(HeapTraverseNode.class);
                WeakList startRoots = (WeakList)rootsComputable.compute();
                DepthFirstSearchTraverse.ObjectsEnumerationTraverse traverse = new DepthFirstSearchTraverse.ObjectsEnumerationTraverse(fieldCache, this);
                traverse.start((WeakList<Object>)startRoots);
                this.statistics.setHeapObjectCount(traverse.getLastObjectId());
                this.statistics.setTraverseSessionId(this.iterationId);
                HashMap nameToClassObjectsStatistics = Maps.newHashMap();
                for (int currentObjectId = traverse.getLastObjectId(); currentObjectId > 0; --currentObjectId) {
                    boolean objectIsAComponentRoot;
                    this.abortTraversalIfRequested();
                    int mapSize = HeapTraverseNode.getObjectIdToTraverseNodeMapSize();
                    this.statistics.updateMaxObjectsQueueSize(mapSize);
                    if (mapSize > 1000000) {
                        MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.OBJECTS_MAP_IS_TOO_BIG;
                        return statusCode;
                    }
                    HeapTraverseNode node = this.getObjectIdToTraverseNodeMapElement(currentObjectId);
                    this.removeElementFromObjectIdToTraverseNodeMap(currentObjectId);
                    if (node == null) {
                        this.statistics.incrementGarbageCollectedObjectsCounter();
                        continue;
                    }
                    Object currentObject = node.getObject();
                    if (currentObject == null) {
                        this.statistics.incrementGarbageCollectedObjectsCounter();
                        continue;
                    }
                    ComponentsSet.Component currentObjectComponent = this.statistics.getConfig().getComponentsSet().getComponentOfObject(currentObject);
                    long currentObjectSize = MemoryReportJniHelper.getObjectSize(currentObject);
                    String currentObjectClassName = currentObject.getClass().getName();
                    boolean isPlatformObject = MemoryReportCollector.isPlatformObject(currentObject, currentObjectClassName);
                    if (isPlatformObject) {
                        node.isRetainedByPlatform = true;
                    }
                    this.statistics.addObjectToTotal(currentObjectSize, isPlatformObject, node.isRetainedByPlatform);
                    this.statistics.checkClassIsTrackedAndAdd(currentObjectClassName);
                    boolean isDisposedButReferenced = false;
                    if (this.statistics.getConfig().collectDisposerTreeInfo && currentObject instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)currentObject))) {
                        this.statistics.addDisposedButReferencedObject(currentObjectSize, currentObjectClassName);
                        isDisposedButReferenced = true;
                    }
                    boolean bl = objectIsAComponentRoot = currentObjectComponent != null;
                    if (objectIsAComponentRoot) {
                        this.updateComponentRootMasks(node, currentObjectComponent, HeapTraverseNode.RefWeight.DEFAULT);
                    }
                    HeapTraverseUtil.processMask(node.retainedMask, index -> this.statistics.addRetainedObjectSizeToComponent((int)index, currentObjectSize, isPlatformObject, node.isRetainedByPlatform));
                    HeapTraverseUtil.processMask(node.retainedMaskForCategories, index -> this.statistics.addRetainedObjectSizeToCategoryComponent((int)index, currentObjectSize, isPlatformObject, node.isRetainedByPlatform));
                    ComponentsSet.ComponentCategory category = this.getCategoryByComponentMask(node.ownedByComponentMask);
                    if (category != null) {
                        this.statistics.addOwnedObjectSizeToCategoryComponent(category.getId(), currentObjectSize, currentObjectClassName, objectIsAComponentRoot, isPlatformObject, node.isRetainedByPlatform, isDisposedButReferenced);
                    }
                    if (node.ownedByComponentMask == 0L) {
                        int uncategorizedComponentId = this.statistics.getConfig().getComponentsSet().getUncategorizedComponent().getId();
                        int uncategorizedCategoryId = this.statistics.getConfig().getComponentsSet().getUncategorizedComponent().getComponentCategory().getId();
                        this.statistics.addOwnedObjectSizeToComponent(uncategorizedComponentId, currentObjectSize, currentObjectClassName, false, isPlatformObject, node.isRetainedByPlatform, isDisposedButReferenced);
                        this.statistics.addOwnedObjectSizeToCategoryComponent(uncategorizedCategoryId, currentObjectSize, currentObjectClassName, false, isPlatformObject, node.isRetainedByPlatform, isDisposedButReferenced);
                    } else if (LongMath.isPowerOfTwo((long)node.ownedByComponentMask)) {
                        int componentId = LongMath.log2((long)node.ownedByComponentMask, (RoundingMode)RoundingMode.UP);
                        currentObjectComponent = this.statistics.getConfig().getComponentsSet().getComponents().get(componentId);
                        this.statistics.addOwnedObjectSizeToComponent(componentId, currentObjectSize, currentObjectClassName, objectIsAComponentRoot, isPlatformObject, node.isRetainedByPlatform, isDisposedButReferenced);
                    } else {
                        this.statistics.addObjectSizeToSharedComponent(node.ownedByComponentMask, currentObjectSize, currentObjectClassName, node.isMergePoint, isPlatformObject, node.isRetainedByPlatform, isDisposedButReferenced);
                    }
                    this.processObjectClassLoader(currentObject, currentObjectComponent, nameToClassObjectsStatistics);
                    this.processObjectTagPreorderTraverse(currentObject, currentObjectId, node, currentObjectComponent);
                    if (isDisposedButReferenced) {
                        node.minDepthKind = HeapTraverseNode.MinDepthKind.USING_DISPOSED_OBJECTS;
                    }
                    this.propagateComponentMask(currentObject, node, currentObjectId, fieldCache);
                }
                this.statistics.calculateExtendedReportDataIfNeeded(fieldCache, this, (WeakList<Object>)startRoots, nameToClassObjectsStatistics);
            }
            finally {
                StackNode.clearDepthFirstSearchStack();
                this.clearObjectIdToTraverseNodeMap();
            }
        }
        catch (HeapSnapshotTraverseException exception) {
            MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = exception.getStatusCode();
            return statusCode;
        }
        finally {
            this.watcher.stop();
            this.messageBusConnection.disconnect();
        }
        return MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.NO_ERROR;
    }

    private void clearObjectIdToTraverseNodeMap() {
        HeapTraverseNode.clearObjectIdToTraverseNodeMap();
        if (this.statistics.getExtendedReportStatistics() != null) {
            this.statistics.getExtendedReportStatistics().objectIdToMinDepth.clear();
            this.statistics.getExtendedReportStatistics().objectIdToMinDepthKind.clear();
        }
    }

    private void removeElementFromObjectIdToTraverseNodeMap(int objectId) {
        HeapTraverseNode.removeElementFromObjectIdToTraverseNodeMap(objectId);
        if (this.statistics.getExtendedReportStatistics() != null) {
            this.statistics.getExtendedReportStatistics().objectIdToMinDepth.remove(objectId);
            this.statistics.getExtendedReportStatistics().objectIdToMinDepthKind.remove(objectId);
        }
    }

    private HeapTraverseNode getObjectIdToTraverseNodeMapElement(int objectId) {
        HeapTraverseNode node = HeapTraverseNode.getObjectIdToTraverseNodeMapElement(objectId, HeapTraverseNode.class);
        if (node == null || this.statistics.getExtendedReportStatistics() == null) {
            return node;
        }
        if (this.statistics.getExtendedReportStatistics().objectIdToMinDepth.containsKey(objectId)) {
            node.minDepth = this.statistics.getExtendedReportStatistics().objectIdToMinDepth.get(objectId);
            node.minDepthKind = HeapTraverseNode.minDepthKindFromByte(this.statistics.getExtendedReportStatistics().objectIdToMinDepthKind.get(objectId));
        }
        return node;
    }

    private void processObjectClassLoader(@NotNull Object obj, @Nullable ComponentsSet.Component currentObjectComponent, @NotNull Map<String, ExtendedReportStatistics.ClassObjectsStatistics> nameToClassObjectsStatistics) {
        if (this.statistics.getExtendedReportStatistics() == null || obj.getClass() == null || obj.getClass().getClassLoader() == null) {
            return;
        }
        Class<?> objClass = obj.getClass();
        nameToClassObjectsStatistics.putIfAbsent(objClass.getName(), new ExtendedReportStatistics.ClassObjectsStatistics());
        ExtendedReportStatistics.ClassObjectsStatistics classObjectsStatistics = nameToClassObjectsStatistics.get(objClass.getName());
        classObjectsStatistics.classLoaders.add(obj.getClass().getClassLoader());
        classObjectsStatistics.classObjects.add(objClass);
        if (currentObjectComponent == null || !this.statistics.getExtendedReportStatistics().componentToExceededClustersStatistics.containsKey(currentObjectComponent)) {
            return;
        }
        ClassLoader loader2 = objClass.getClassLoader();
        String currentObjectClassLoader = loader2.getClass().getName();
        if (currentObjectComponent.customClassLoaders.contains(currentObjectClassLoader)) {
            this.statistics.getExtendedReportStatistics().componentToExceededClustersStatistics.get(currentObjectComponent).addNominatedClassLoader(loader2);
        }
    }

    private void processObjectTagPreorderTraverse(@NotNull Object obj, int currentObjectId, @NotNull HeapTraverseNode node, @Nullable ComponentsSet.Component currentObjectComponent) {
        if (this.statistics.getExtendedReportStatistics() == null || node.minDepth == null) {
            MemoryReportJniHelper.setObjectTag(obj, 0L);
            return;
        }
        boolean isOwnedByExceededComponent = false;
        int owningExceededClusterIndex = 0;
        if (currentObjectComponent != null && this.statistics.getExtendedReportStatistics().componentToExceededClustersStatistics.containsKey(currentObjectComponent)) {
            isOwnedByExceededComponent = true;
            owningExceededClusterIndex = this.statistics.getExtendedReportStatistics().componentToExceededClustersStatistics.get((Object)currentObjectComponent).exceededClusterIndex;
        }
        MemoryReportJniHelper.setObjectTag(obj, ObjectTagUtil.constructTag(currentObjectId, node.minDepth, node.minDepthKind, this.iterationId, isOwnedByExceededComponent, owningExceededClusterIndex));
    }

    public short getIterationId() {
        return this.iterationId;
    }

    static boolean isPlatformObject(@NotNull String className) {
        return className.startsWith("org.jetbrains") || className.startsWith("com.intellij") || className.startsWith("com.jetbrains") || className.startsWith("org.intellij");
    }

    static boolean isPlatformObject(@NotNull Object obj, @NotNull String objClassName) {
        if (obj instanceof Class) {
            return MemoryReportCollector.isPlatformObject(((Class)obj).getName());
        }
        return MemoryReportCollector.isPlatformObject(objClassName);
    }

    void putOrUpdateObjectIdToTraverseNodeMap(int id2, @NotNull Object obj, @NotNull HeapTraverseNode node) {
        HeapTraverseNode.putOrUpdateObjectIdToTraverseNodeMap(id2, obj, node.ownershipWeight.getValue(), node.ownedByComponentMask, node.retainedMask, node.retainedMaskForCategories, node.isMergePoint, node.isRetainedByPlatform);
        if (this.statistics.getExtendedReportStatistics() != null && node.minDepth != null) {
            this.statistics.getExtendedReportStatistics().objectIdToMinDepth.put(id2, node.minDepth.intValue());
            if (node.minDepthKind != null) {
                this.statistics.getExtendedReportStatistics().objectIdToMinDepthKind.put(id2, node.minDepthKind.getValue());
            }
        }
    }

    private ComponentsSet.ComponentCategory getCategoryByComponentMask(long componentMask) {
        ComponentsSet.ComponentCategory result2 = null;
        int trailingZeros = Long.numberOfTrailingZeros(componentMask);
        componentMask >>= Long.numberOfTrailingZeros(componentMask);
        int i = trailingZeros;
        while (componentMask != 0L) {
            if ((componentMask & 1L) != 0L) {
                ComponentsSet.ComponentCategory currentCategory = ((ComponentsSet.Component)this.statistics.getComponentStats().get(i).getCluster()).getComponentCategory();
                if (result2 == null) {
                    result2 = currentCategory;
                } else if (result2 != currentCategory) {
                    return null;
                }
            }
            ++i;
            componentMask >>= 1;
        }
        return result2;
    }

    private void updateComponentRootMasks(HeapTraverseNode node, ComponentsSet.Component currentObjectComponent, HeapTraverseNode.RefWeight weight) {
        node.retainedMask |= 1L << currentObjectComponent.getId();
        node.retainedMaskForCategories |= 1 << currentObjectComponent.getComponentCategory().getId();
        node.ownedByComponentMask = 1L << currentObjectComponent.getId();
        node.ownershipWeight = weight;
    }

    void abortTraversalIfRequested() throws HeapSnapshotTraverseException {
        if (this.shouldAbortTraversal) {
            throw new HeapSnapshotTraverseException(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.LOW_MEMORY);
        }
    }

    private void onLowMemorySignalReceived() {
        this.shouldAbortTraversal = true;
    }

    private void propagateComponentMask(@NotNull Object parentObj, @NotNull HeapTraverseNode parentNode, int parentId, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        this.heapTraverseChildProcessor.processChildObjects(parentObj, (TriConsumer<Object, HeapTraverseNode.RefWeight, String>)((TriConsumer)(value2, ownershipWeight, label2) -> {
            HeapTraverseNode currentNode;
            if (value2 == null || HeapTraverseUtil.isPrimitive(value2.getClass()) || value2 instanceof Thread || value2 instanceof Class || value2 instanceof ClassLoader) {
                return;
            }
            long tag = MemoryReportJniHelper.getObjectTag(value2);
            if (tag == 0L) {
                return;
            }
            int objectId = ObjectTagUtil.getObjectId(tag, this.iterationId);
            if (objectId == -1 || objectId >= parentId) {
                return;
            }
            if (parentObj.getClass().isSynthetic()) {
                ownershipWeight = HeapTraverseNode.RefWeight.SYNTHETIC;
            }
            if (parentNode.ownedByComponentMask == 0L) {
                ownershipWeight = HeapTraverseNode.RefWeight.NON_COMPONENT;
            }
            if ((currentNode = HeapTraverseNode.getObjectIdToTraverseNodeMapElement(objectId, HeapTraverseNode.class)) == null) {
                currentNode = this.createHeapTraverseNodeFromParent(value2, (HeapTraverseNode.RefWeight)((Object)ownershipWeight), parentNode);
            }
            currentNode.retainedMask &= parentNode.retainedMask;
            currentNode.retainedMaskForCategories &= parentNode.retainedMaskForCategories;
            currentNode.isRetainedByPlatform &= parentNode.isRetainedByPlatform;
            if (currentNode.minDepth != null && currentNode.minDepthKind != null && parentNode.minDepth != null && parentNode.minDepthKind != null) {
                if (parentNode.minDepthKind.getValue() == currentNode.minDepthKind.getValue()) {
                    currentNode.minDepth = Math.min(currentNode.minDepth, parentNode.minDepth + 1);
                }
                if (parentNode.minDepthKind.getValue() < currentNode.minDepthKind.getValue()) {
                    currentNode.minDepth = parentNode.minDepth + 1;
                    currentNode.minDepthKind = parentNode.minDepthKind;
                }
            }
            if (ownershipWeight.compareTo(currentNode.ownershipWeight) > 0) {
                currentNode.ownershipWeight = ownershipWeight;
                currentNode.ownedByComponentMask = parentNode.ownedByComponentMask;
                currentNode.isMergePoint = false;
            } else if (ownershipWeight.compareTo(currentNode.ownershipWeight) == 0) {
                if (currentNode.ownedByComponentMask != 0L && parentNode.ownedByComponentMask != currentNode.ownedByComponentMask) {
                    currentNode.isMergePoint = true;
                }
                currentNode.ownedByComponentMask |= parentNode.ownedByComponentMask;
            }
            this.putOrUpdateObjectIdToTraverseNodeMap(objectId, value2, currentNode);
        }), fieldCache);
    }

    private HeapTraverseNode createHeapTraverseNodeFromParent(@Nullable Object obj, @NotNull HeapTraverseNode.RefWeight ownershipWeight, @NotNull HeapTraverseNode parentNode) {
        HeapTraverseNode node = new HeapTraverseNode(obj, ownershipWeight, parentNode.ownedByComponentMask, parentNode.retainedMask, parentNode.retainedMaskForCategories, false, parentNode.isRetainedByPlatform);
        if (this.statistics.getExtendedReportStatistics() != null && parentNode.minDepth != null) {
            node.minDepth = parentNode.minDepth + 1;
            node.minDepthKind = parentNode.minDepthKind;
        }
        return node;
    }

    HeapTraverseNode createRootNode(@Nullable Object root) {
        HeapTraverseNode node = new HeapTraverseNode(root, HeapTraverseNode.RefWeight.DEFAULT.getValue(), 0L, 0L, 0, false, false);
        if (this.statistics.getExtendedReportStatistics() != null) {
            node.minDepth = 0;
            node.minDepthKind = HeapTraverseNode.MinDepthKind.DEFAULT;
        }
        return node;
    }

    public void dispose() {
        this.watcher.stop();
        this.messageBusConnection.disconnect();
    }

    public static void collectAndWriteStats(@NotNull Consumer<String> writer2, @NotNull HeapSnapshotStatistics stats, @NotNull HeapSnapshotPresentationConfig presentationConfig) {
        long collectionStartTimestamp = System.nanoTime();
        new MemoryReportCollector(stats).walkObjects(getLoadedClassesComputable);
        stats.print(writer2, bytes2 -> HeapTraverseUtil.getObjectsStatsPresentation(bytes2, presentationConfig.sizePresentation), presentationConfig, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - collectionStartTimestamp));
    }

    public static MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode collectMemoryReport(@NotNull HeapSnapshotStatistics stats, @NotNull Computable<WeakList<Object>> rootsComputable) {
        long startTime = System.nanoTime();
        MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = new MemoryReportCollector(stats).walkObjects(rootsComputable);
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.MEMORY_USAGE_REPORT_EVENT).setMemoryUsageReportEvent(stats.buildMemoryUsageReportEvent(statusCode, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), TimeUnit.NANOSECONDS.toMillis(startTime), ComponentsSet.getServerFlagConfiguration().getSharedComponentsLimit())));
        List<ComponentsSet.Component> exceededComponents = MemoryReportCollector.getComponentsThatExceededThreshold(stats);
        if (!exceededComponents.isEmpty()) {
            MemoryReportCollector.collectAndSendExtendedMemoryReport(stats.getConfig().getComponentsSet(), exceededComponents, rootsComputable, 10000000L);
        }
        return statusCode;
    }

    @NotNull
    private static List<ComponentsSet.Component> getComponentsThatExceededThreshold(@NotNull HeapSnapshotStatistics stats) {
        ArrayList result2 = Lists.newArrayList();
        for (ComponentsSet.Component component : stats.getConfig().getComponentsSet().getComponents()) {
            if (stats.getComponentStats().get(component.getId()).getOwnedClusterStat().getObjectsStatistics().getTotalSizeInBytes() <= component.getExtendedReportCollectionThresholdBytes()) continue;
            result2.add(component);
            if (result2.size() < 16) continue;
            break;
        }
        return result2;
    }

    public static void collectAndSendExtendedMemoryReport(@NotNull ComponentsSet componentsSet, @NotNull List<ComponentsSet.Component> exceededClusters, @NotNull Computable<WeakList<Object>> rootsComputable, long summaryRequiredSubtreeSize) {
        HeapSnapshotStatistics extendedReportStats = new HeapSnapshotStatistics(new HeapTraverseConfig(componentsSet, true, true, 10, true, summaryRequiredSubtreeSize, exceededClusters));
        MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = new MemoryReportCollector(extendedReportStats).walkObjects(rootsComputable);
        for (ComponentsSet.Component cluster : exceededClusters) {
            StudioCrashReporter.getInstance().submit(extendedReportStats.asCrashReport(exceededClusters, cluster, statusCode), true);
        }
    }

    private static short getNextIterationId() {
        ourIterationId = (short)(ourIterationId + 1);
        return ourIterationId;
    }

    static class HeapSnapshotPresentationConfig {
        final PresentationStyle sizePresentation;
        final boolean shouldLogSharedClusters;
        final boolean shouldLogRetainedSizes;

        HeapSnapshotPresentationConfig(PresentationStyle sizePresentation, boolean shouldLogSharedClusters, boolean shouldLogRetainedSizes) {
            this.sizePresentation = sizePresentation;
            this.shouldLogSharedClusters = shouldLogSharedClusters;
            this.shouldLogRetainedSizes = shouldLogRetainedSizes;
        }

        static enum PresentationStyle {
            PLAIN_VALUES,
            OPTIMAL_UNITS;

        }
    }
}

