/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.diagnostics.crash.ExceptionDataConfiguration;
import com.android.tools.idea.diagnostics.crash.LogBuffer;
import com.android.tools.idea.diagnostics.crash.LogCache;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.diagnostics.crash.UploadFields;
import com.android.tools.idea.diagnostics.crash.exception.NoPiiException;
import com.android.tools.idea.serverflags.protos.ExceptionAction;
import com.android.tools.idea.serverflags.protos.ExceptionConfiguration;
import com.android.tools.idea.serverflags.protos.ExceptionSeverity;
import com.android.tools.idea.serverflags.protos.LogFilter;
import com.android.tools.idea.serverflags.protos.MessageFilter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.intellij.diagnostic.DialogAppender;
import com.intellij.diagnostic.logs.LogLevelConfigurationManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.gradle.diagnostic.CompilerInternalError;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 92\u00020\u0001:\u00039:;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001eJ\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u001e\u0010&\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001eJ>\u0010&\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010\"2\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u00060.j\u0002`/H\u0002J\u0010\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006H\u0002J\f\u00102\u001a\u00020\u0006*\u000203H\u0002J\u000e\u00104\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"J\u0014\u00105\u001a\u00020\u001e*\u00020\u00192\u0006\u00106\u001a\u00020\u0019H\u0002J\u0014\u00107\u001a\u00020\u001e*\u00020\u00192\u0006\u00106\u001a\u00020\u0019H\u0002J\b\u00108\u001a\u00020)H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006<"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection;", "", "<init>", "()V", "configs", "", "", "Lcom/android/tools/idea/serverflags/protos/ExceptionConfiguration;", "logCache", "Lcom/android/tools/idea/diagnostics/crash/LogCache;", "layout", "Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$ExceptionDataCollectionLayout;", "registeredAppenders", "", "Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$TrackingAppender;", "getRegisteredAppenders", "()Ljava/util/List;", "initializeLog", "registerTrackingAppenders", "", "registerAppendersForLogFilter", "logName", "logFilter", "Lcom/android/tools/idea/serverflags/protos/LogFilter;", "severityToLevel", "Ljava/util/logging/Level;", "kotlin.jvm.PlatformType", "severity", "Lcom/android/tools/idea/serverflags/protos/ExceptionSeverity;", "tryReconfigureExistingHandlers", "", "getExceptionUploadFields", "Lcom/android/tools/idea/diagnostics/crash/UploadFields;", "t", "", "forceExceptionMessage", "includeLogs", "getExceptionUploadConfigurations", "getDescription", "stripMessage", "includeFullStack", "", "containingThrowable", "depth", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fixStackTraceStringForLoggerErrorMethod", "s", "extractKotlinCompilerInternalErrorExceptionName", "Lorg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError;", "requiresConfirmation", "isGreaterThanOrEqual", "other", "isLessThan", "unregisterLogAppenders", "Companion", "ExceptionDataCollectionLayout", "TrackingAppender", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nExceptionDataCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionDataCollection.kt\ncom/android/tools/idea/diagnostics/crash/ExceptionDataCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,523:1\n1761#2,3:524\n1761#2,2:527\n1761#2,3:529\n1763#2:532\n1869#2,2:533\n1869#2,2:548\n1761#2,3:550\n1761#2,3:553\n1252#2,4:558\n1740#2,2:572\n1742#2:576\n1869#2,2:594\n12434#3,2:535\n4135#3,11:537\n12637#3,2:574\n1682#3,6:585\n463#4:556\n413#4:557\n504#4,7:562\n504#4,3:569\n507#4,4:577\n37#5:581\n36#5,3:582\n188#6,3:591\n*S KotlinDebug\n*F\n+ 1 ExceptionDataCollection.kt\ncom/android/tools/idea/diagnostics/crash/ExceptionDataCollection\n*L\n182#1:524,3\n195#1:527,2\n196#1:529,3\n195#1:532\n225#1:533,2\n286#1:548,2\n300#1:550,3\n303#1:553,3\n307#1:558,4\n355#1:572,2\n355#1:576\n515#1:594,2\n277#1:535,2\n286#1:537,11\n356#1:574,2\n454#1:585,6\n307#1:556\n307#1:557\n308#1:562,7\n327#1:569,3\n327#1:577,4\n442#1:581\n442#1:582,3\n500#1:591,3\n*E\n"})
public final class ExceptionDataCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, ExceptionConfiguration> configs;
    @NotNull
    private LogCache logCache = new LogCache();
    @NotNull
    private final ExceptionDataCollectionLayout layout = new ExceptionDataCollectionLayout();
    @TestOnly
    @NotNull
    private final List<TrackingAppender> registeredAppenders;
    private static final ImmutableList<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableList.of(LinkageError.class, ReflectiveOperationException.class, ArrayIndexOutOfBoundsException.class, ClassCastException.class, IndexOutOfBoundsException.class, NoPiiException.class);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String LOGGER_ERROR_MESSAGE_EXCEPTION = "com.android.diagnostic.LoggerErrorMessage";
    private static final boolean LOG_COLLECTION_ENABLED = true;
    private static final ImmutableList<String> LOGGER_CLASSES;
    @NotNull
    private static final Regex regex;

    public ExceptionDataCollection() {
        List appendersList = null;
        try {
            this.configs = ExceptionDataConfiguration.Companion.getInstance().getConfigurations();
            appendersList = this.initializeLog();
        }
        catch (Throwable t) {
            LOG.error("Cannot initialize exception log collection", t);
            this.configs = MapsKt.emptyMap();
            appendersList = CollectionsKt.emptyList();
        }
        this.registeredAppenders = appendersList;
    }

    @NotNull
    public final List<TrackingAppender> getRegisteredAppenders() {
        return this.registeredAppenders;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TrackingAppender> initializeLog() {
        block12: {
            block13: {
                block10: {
                    $this$any$iv = this.configs.values();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (ExceptionConfiguration)element$iv;
                            $i$a$-any-ExceptionDataCollection$initializeLog$hasAnyLog$1 = false;
                            if (!(it.getAction().getLogFilter().getMessageFilterCount() > 0)) continue;
                            v0 = true;
                            break block10;
                        }
                        v0 = hasAnyLog = false;
                    }
                }
                if (!hasAnyLog) {
                    return CollectionsKt.emptyList();
                }
                if (((Collection)LogLevelConfigurationManager.Companion.getInstance().getCategories()).isEmpty() == false) {
                    ExceptionDataCollection.LOG.info("Cannot register appenders: debug/trace logging enabled through " + LogLevelConfigurationManager.class.getSimpleName() + ".");
                    return CollectionsKt.emptyList();
                }
                $this$any$iv = this.configs.values();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block13;
                v1 = false;
                break block12;
            }
            for (T element$iv : $this$any$iv) {
                block11: {
                    block14: {
                        config = (ExceptionConfiguration)element$iv;
                        $i$a$-any-ExceptionDataCollection$initializeLog$needsToReconfigureAppenders$1 = false;
                        v2 = config.getAction().getLogFilter().getMessageFilterList();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getMessageFilterList(...)");
                        $this$any$iv = v2;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block14;
                        v3 = false;
                        break block11;
                    }
                    for (T element$iv : $this$any$iv) {
                        messageFilter = (MessageFilter)element$iv;
                        $i$a$-any-ExceptionDataCollection$initializeLog$needsToReconfigureAppenders$1$1 = false;
                        if (!messageFilter.hasSeverity()) ** GOTO lbl-1000
                        v4 = messageFilter.getSeverity();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getSeverity(...)");
                        v5 = this.severityToLevel(v4);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"severityToLevel(...)");
                        v6 = Level.INFO;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"INFO");
                        if (this.isLessThan(v5, v6)) {
                            v7 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v7 = false;
                        }
                        if (!v7) continue;
                        v3 = true;
                        break block11;
                    }
                    v3 = false;
                }
                if (!v3) continue;
                v1 = true;
                break block12;
            }
            v1 = needsToReconfigureAppenders = false;
        }
        if (needsToReconfigureAppenders && !this.tryReconfigureExistingHandlers()) {
            return CollectionsKt.emptyList();
        }
        return this.registerTrackingAppenders();
    }

    private final List<TrackingAppender> registerTrackingAppenders() {
        List registeredAppenders = new ArrayList();
        for (Map.Entry<String, ExceptionConfiguration> entry : this.configs.entrySet()) {
            String name2 = entry.getKey();
            ExceptionConfiguration config = entry.getValue();
            ExceptionAction action2 = config.getAction();
            if (!action2.hasLogFilter() || action2.getLogFilter().getMaxMessageCount() <= 0) continue;
            LogFilter logFilter = action2.getLogFilter();
            Intrinsics.checkNotNullExpressionValue((Object)logFilter, (String)"getLogFilter(...)");
            List<TrackingAppender> newAppenders = this.registerAppendersForLogFilter(name2, logFilter);
            registeredAppenders.addAll((Collection)newAppenders);
        }
        return registeredAppenders;
    }

    private final List<TrackingAppender> registerAppendersForLogFilter(String logName, LogFilter logFilter) {
        LogBuffer logBuffer = this.logCache.getLogBufferFor(logName, logFilter.getMaxMessageCount());
        List result2 = new ArrayList();
        List list = logFilter.getMessageFilterList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMessageFilterList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Level desiredLevel;
            java.util.logging.Logger logger;
            block4: {
                block3: {
                    MessageFilter filter2 = (MessageFilter)element$iv;
                    boolean bl = false;
                    logger = LogManager.getLogManager().getLogger(filter2.getLoggerCategory());
                    ExceptionSeverity exceptionSeverity = filter2.getSeverity();
                    Intrinsics.checkNotNullExpressionValue((Object)exceptionSeverity, (String)"getSeverity(...)");
                    desiredLevel = this.severityToLevel(exceptionSeverity);
                    if (logger.getLevel() == null) break block3;
                    Level level = logger.getLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
                    Intrinsics.checkNotNull((Object)desiredLevel);
                    if (!this.isLessThan(level, desiredLevel)) break block4;
                }
                logger.setLevel(desiredLevel);
            }
            Intrinsics.checkNotNull((Object)logger);
            TrackingAppender trackingAppender = new TrackingAppender(logger, this.layout, logBuffer);
            trackingAppender.setLevel(desiredLevel);
            logger.addHandler(trackingAppender);
            result2.add(trackingAppender);
        }
        return result2;
    }

    private final Level severityToLevel(ExceptionSeverity severity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1 -> Level.ALL;
            case 2 -> Level.FINE;
            case 3 -> Level.INFO;
            case 4 -> Level.WARNING;
            case 5 -> Level.SEVERE;
            default -> Level.INFO;
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean tryReconfigureExistingHandlers() {
        block9: {
            if (((Collection)LogLevelConfigurationManager.Companion.getInstance().getCategories()).isEmpty() == false) {
                ExceptionDataCollection.LOG.info("Cannot register appenders: debug/trace logging enabled through " + LogLevelConfigurationManager.class.getSimpleName() + ".");
                return false;
            }
            rootLogger = java.util.logging.Logger.getLogger("");
            v0 = rootLogger.getLevel();
            if (v0 == null) {
                v0 = Level.FINE;
            }
            rootLoggerLevel = v0;
            handlers = rootLogger.getHandlers();
            Intrinsics.checkNotNull((Object)handlers);
            $this$all$iv = handlers;
            $i$f$all = false;
            var8_8 = $this$all$iv.length;
            for (var7_6 = 0; var7_6 < var8_8; ++var7_6) {
                block10: {
                    handler = element$iv = $this$all$iv[var7_6];
                    $i$a$-all-ExceptionDataCollection$tryReconfigureExistingHandlers$allHandlersAllowed$1 = false;
                    if (!(handler instanceof ConsoleHandler)) break block10;
                    if (((ConsoleHandler)handler).getLevel() == null) ** GOTO lbl-1000
                    v1 = ((ConsoleHandler)handler).getLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getLevel(...)");
                    Intrinsics.checkNotNull((Object)rootLoggerLevel);
                    if (this.isGreaterThanOrEqual(v1, rootLoggerLevel)) ** GOTO lbl-1000
                }
                if (handler instanceof FileHandler) ** GOTO lbl-1000
                if (!(handler instanceof DialogAppender)) ** GOTO lbl-1000
                if (((DialogAppender)handler).getLevel() == null) ** GOTO lbl-1000
                v2 = ((DialogAppender)handler).getLevel();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getLevel(...)");
                Intrinsics.checkNotNull((Object)rootLoggerLevel);
                if (this.isGreaterThanOrEqual(v2, rootLoggerLevel)) lbl-1000:
                // 5 sources

                {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) continue;
                v4 = false;
                break block9;
            }
            v4 = allHandlersAllowed = true;
        }
        if (!allHandlersAllowed) {
            ExceptionDataCollection.LOG.info("Cannot register appenders: unknown appender on root logger or threshold already specified on appenders.");
            return false;
        }
        $this$filterIsInstance$iv /* !! */  = handlers;
        $i$f$filterIsInstance = false;
        var7_7 = $this$filterIsInstance$iv /* !! */ ;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FileHandler)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv /* !! */  = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (FileHandler)element$iv;
            $i$a$-forEach-ExceptionDataCollection$tryReconfigureExistingHandlers$1 = false;
            if (it.getLevel() != null) {
                Intrinsics.checkNotNull((Object)rootLoggerLevel);
                v5 = it.getLevel();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getLevel(...)");
                if (!this.isLessThan(rootLoggerLevel, v5)) continue;
            }
            it.setLevel(rootLoggerLevel);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UploadFields getExceptionUploadFields(@NotNull Throwable t, boolean forceExceptionMessage, boolean includeLogs) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        try {
            Map map2;
            boolean includeFullStack;
            boolean includeMessage;
            Map<String, ExceptionConfiguration> configs;
            Throwable cause;
            block13: {
                boolean bl;
                block12: {
                    Throwable throwable = StudioExceptionReport.getRootCause(t);
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(...)");
                    cause = throwable;
                    configs = this.getExceptionUploadConfigurations(cause);
                    Iterable $this$any$iv = configs.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ExceptionConfiguration it = (ExceptionConfiguration)element$iv;
                            boolean bl2 = false;
                            if (!it.getAction().getIncludeExceptionMessage()) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                includeMessage = bl || forceExceptionMessage || THROWABLE_CLASSES_TO_TRACK_MESSAGES.stream().anyMatch(arg_0 -> ExceptionDataCollection.getExceptionUploadFields$lambda$8(arg_0 -> ExceptionDataCollection.getExceptionUploadFields$lambda$7(t, arg_0), arg_0));
                Iterable $this$any$iv = configs.values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ExceptionConfiguration it = (ExceptionConfiguration)element$iv;
                        boolean bl3 = false;
                        if (!it.getAction().getIncludeFullStack()) continue;
                        v2 = true;
                        break block13;
                    }
                    v2 = includeFullStack = false;
                }
            }
            if (includeLogs) {
                void $this$filterValues$iv;
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv;
                Object element$iv;
                Map<String, ExceptionConfiguration> $i$f$any = configs;
                boolean $i$f$mapValues = false;
                element$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    String string = this.logCache.getLogAndClearFor((String)it.getKey());
                    map4.put(k, string);
                }
                $this$mapValues$iv = destination$iv$iv;
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                    String it = (String)entry$iv.getValue();
                    boolean bl = false;
                    boolean bl5 = ((CharSequence)it).length() > 0;
                    if (!bl5) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                map2 = MapsKt.toSortedMap((Map)result$iv);
            } else {
                map2 = MapsKt.emptyMap();
            }
            Map logs = map2;
            return new UploadFields(this.getDescription(includeFullStack ? t : cause, !includeMessage, includeFullStack), logs);
        }
        catch (Throwable t2) {
            LOG.error("getExceptionUploadFields() call failed", t2);
            return new UploadFields(this.getDescription(t2, true, true), MapsKt.emptyMap());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Map<String, ExceptionConfiguration> getExceptionUploadConfigurations(Throwable t) {
        now = new GregorianCalendar();
        now.setTime(AnalyticsSettings.getDateProvider().now());
        $this$filterValues$iv = this.configs;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<String, ExceptionConfiguration>();
        for (Map.Entry<String, ExceptionConfiguration> entry$iv : $this$filterValues$iv.entrySet()) {
            block12: {
                block14: {
                    block10: {
                        block13: {
                            block11: {
                                config = entry$iv.getValue();
                                $i$a$-filterValues-ExceptionDataCollection$getExceptionUploadConfigurations$1 = false;
                                if (config.hasExpirationDate()) break block11;
                                v0 = false;
                                break block12;
                            }
                            expirationDate = new GregorianCalendar();
                            expirationDate.set(config.getExpirationDate().getYear(), config.getExpirationDate().getMonth() - 1, config.getExpirationDate().getDay());
                            if (!now.after(expirationDate)) break block13;
                            v0 = false;
                            break block12;
                        }
                        match = true;
                        atLeastOneFilter = false;
                        filter = config.getExceptionFilter();
                        if (filter.hasExceptionType()) {
                            match = Intrinsics.areEqual((Object)t.getClass().getName(), (Object)filter.getExceptionType()) != false;
                            atLeastOneFilter = true;
                        }
                        if (filter.hasSignature()) {
                            signature = ExceptionDataCollection.Companion.calculateSignature(t);
                            match = match != false && Intrinsics.areEqual((Object)signature, (Object)filter.getSignature()) != false;
                            atLeastOneFilter = true;
                        }
                        if (filter.getFramePatternsCount() <= 0) break block14;
                        atLeastOneFilter = true;
                        stackTrace = t.getStackTrace();
                        if (!match) ** GOTO lbl-1000
                        v1 = filter.getFramePatternsList();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getFramePatternsList(...)");
                        $this$all$iv = (Iterable)v1;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v2 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                block9: {
                                    frameToMatch = (String)element$iv;
                                    $i$a$-all-ExceptionDataCollection$getExceptionUploadConfigurations$1$1 = false;
                                    Intrinsics.checkNotNull((Object)stackTrace);
                                    $this$any$iv = stackTrace;
                                    $i$f$any = false;
                                    var24_24 = $this$any$iv.length;
                                    for (var23_23 = 0; var23_23 < var24_24; ++var23_23) {
                                        frame = element$iv = $this$any$iv[var23_23];
                                        $i$a$-any-ExceptionDataCollection$getExceptionUploadConfigurations$1$1$1 = false;
                                        if (!Intrinsics.areEqual((Object)(frame.getClassName() + frame.getMethodName()), (Object)frameToMatch)) continue;
                                        v3 = true;
                                        break block9;
                                    }
                                    v3 = false;
                                }
                                if (v3) continue;
                                v2 = false;
                                break block10;
                            }
                            v2 = true;
                        }
                    }
                    if (v2) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    match = v4;
                }
                v0 = atLeastOneFilter != false && match != false;
            }
            if (!v0) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    public final String getDescription(@NotNull Throwable t, boolean stripMessage, boolean includeFullStack) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        StringBuilder sb = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.getDescription(t, stripMessage, includeFullStack, null, 1, sb);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void getDescription(Throwable t, boolean stripMessage, boolean includeFullStack, Throwable containingThrowable, int depth, StringBuilder sb) {
        block7: {
            if (depth >= 20) {
                return;
            }
            if (!stripMessage) {
                String traceAsString = Throwables.getStackTraceAsString((Throwable)t);
                Intrinsics.checkNotNull((Object)traceAsString);
                sb.append(this.fixStackTraceStringForLoggerErrorMethod(traceAsString));
                return;
            }
            StackTraceElement[] originalStackTraceElements = t.getStackTrace();
            StackTraceElement[] stackTraceElementArray = t.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            StackTraceElement[] stackTraceElements = ExceptionDataCollection.Companion.removeLoggerErrorFrames(stackTraceElementArray);
            boolean isLoggerErrorException = stackTraceElements.length != originalStackTraceElements.length;
            String exceptionName = isLoggerErrorException ? LOGGER_ERROR_MESSAGE_EXCEPTION : (t instanceof CompilerInternalError ? this.extractKotlinCompilerInternalErrorExceptionName((CompilerInternalError)t) : t.getClass().getName());
            sb.append(exceptionName + ": <elided>\n");
            int commonFrames = 0;
            if (containingThrowable != null) {
                int currThis = stackTraceElements.length - 1;
                StackTraceElement[] containingTrace = containingThrowable.getStackTrace();
                int currContaining = containingTrace.length - 1;
                while (currThis >= 0 && currContaining >= 0 && Intrinsics.areEqual((Object)stackTraceElements[currThis], (Object)containingTrace[currContaining])) {
                    --currThis;
                    --currContaining;
                    ++commonFrames;
                }
            }
            int n = stackTraceElements.length - commonFrames;
            for (int i = 0; i < n; ++i) {
                sb.append("\tat " + stackTraceElements[i] + "\n");
            }
            if (commonFrames > 0) {
                sb.append("\t... " + commonFrames + " more");
            }
            if (!includeFullStack) break block7;
            Throwable throwable = t.getCause();
            if (throwable != null) {
                Throwable cause = throwable;
                boolean bl = false;
                sb.append("Caused by: ");
                this.getDescription(cause, stripMessage, includeFullStack, t, depth + 1, sb);
            }
        }
    }

    private final String fixStackTraceStringForLoggerErrorMethod(String s) {
        int indexOfFirstNonLoggerFrame;
        int indexOfFirstFrame;
        String throwableText;
        String[] lines;
        block6: {
            int n;
            CharSequence charSequence = s;
            Regex regex = new Regex("\n");
            int n2 = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n2);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            lines = thisCollection$iv.toArray(new String[0]);
            if (lines.length <= 2) {
                return s;
            }
            throwableText = Throwable.class.getName();
            String throwableColonText = throwableText + ":";
            if (!Intrinsics.areEqual((Object)lines[0], (Object)throwableText) && !StringsKt.startsWith$default((String)lines[0], (String)throwableColonText, (boolean)false, (int)2, null)) {
                return s;
            }
            String[] $this$indexOfFirst$iv = lines;
            boolean $i$f$indexOfFirst = false;
            int n3 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n3; ++index$iv) {
                String it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"\tat ", (boolean)false, (int)2, null)) continue;
                n = index$iv;
                break block6;
            }
            n = indexOfFirstFrame = -1;
        }
        if (indexOfFirstFrame == -1) {
            return s;
        }
        for (indexOfFirstNonLoggerFrame = indexOfFirstFrame; indexOfFirstNonLoggerFrame < lines.length && (StringsKt.startsWith$default((String)lines[indexOfFirstNonLoggerFrame], (String)("\tat " + Logger.class.getName() + ".error("), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lines[indexOfFirstNonLoggerFrame], (String)("\tat " + IdeaLogger.class.getName() + ".error("), (boolean)false, (int)2, null)); ++indexOfFirstNonLoggerFrame) {
        }
        if (indexOfFirstNonLoggerFrame == lines.length || indexOfFirstNonLoggerFrame == indexOfFirstFrame) {
            return s;
        }
        String string = lines[0].substring(throwableText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        lines[0] = LOGGER_ERROR_MESSAGE_EXCEPTION + string;
        Stream<String> exceptionMessageLines = Arrays.stream(lines).limit(indexOfFirstFrame);
        Stream<String> stackFramesLines = Arrays.stream(lines).skip(indexOfFirstNonLoggerFrame);
        String string2 = Stream.concat(exceptionMessageLines, stackFramesLines).collect(Collectors.joining("\n"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"collect(...)");
        return string2;
    }

    private final String extractKotlinCompilerInternalErrorExceptionName(CompilerInternalError $this$extractKotlinCompilerInternalErrorExceptionName) {
        String string = $this$extractKotlinCompilerInternalErrorExceptionName.getMessage();
        if (string == null) {
            string = "";
        }
        String rootExceptionName = StringsKt.substringBefore((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)":", (String)"UnknownRootException");
        return CompilerInternalError.class.getName() + "_" + rootExceptionName;
    }

    public final boolean requiresConfirmation(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        try {
            boolean bl;
            block5: {
                Map<String, ExceptionConfiguration> exceptionUploadConfigurations;
                Throwable throwable = StudioExceptionReport.getRootCause(t);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(...)");
                Throwable cause = throwable;
                Map<String, ExceptionConfiguration> $this$any$iv = exceptionUploadConfigurations = this.getExceptionUploadConfigurations(cause);
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<String, ExceptionConfiguration>> iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, ExceptionConfiguration> element$iv;
                        Map.Entry<String, ExceptionConfiguration> entry = element$iv = iterator2.next();
                        boolean bl2 = false;
                        ExceptionConfiguration config = entry.getValue();
                        if (!(!config.getAction().hasRequiresConfirmation() || config.getAction().getRequiresConfirmation())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (Throwable t2) {
            LOG.warn("cannot compute if exception requires confirmation", t2);
            return false;
        }
    }

    private final boolean isGreaterThanOrEqual(Level $this$isGreaterThanOrEqual, Level other) {
        return $this$isGreaterThanOrEqual.intValue() >= other.intValue();
    }

    private final boolean isLessThan(Level $this$isLessThan, Level other) {
        return $this$isLessThan.intValue() < other.intValue();
    }

    @TestOnly
    public final void unregisterLogAppenders() {
        Iterable $this$forEach$iv = this.registeredAppenders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackingAppender trackingAppender = (TrackingAppender)element$iv;
            boolean bl = false;
            java.util.logging.Logger logger = trackingAppender.getLogger();
            logger.removeHandler(trackingAppender);
        }
    }

    private static final boolean getExceptionUploadFields$lambda$7(Throwable $t, Class it) {
        return it.isInstance($t);
    }

    private static final boolean getExceptionUploadFields$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final ExceptionDataCollection getInstance() {
        return Companion.getInstance();
    }

    static {
        Logger logger = Logger.getInstance(ExceptionDataCollection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        LOGGER_CLASSES = ImmutableList.of((Object)Logger.class.getName(), (Object)IdeaLogger.class.getName());
        regex = new Regex("(.*)\\$[0-9]+");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0007J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0007RR\u0010\u0004\u001aF\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0007 \b*\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00060\u0006 \b*\"\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0007 \b*\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$Companion;", "", "<init>", "()V", "THROWABLE_CLASSES_TO_TRACK_MESSAGES", "Lcom/google/common/collect/ImmutableList;", "Ljava/lang/Class;", "", "kotlin.jvm.PlatformType", "getInstance", "Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOGGER_ERROR_MESSAGE_EXCEPTION", "", "LOG_COLLECTION_ENABLED", "", "LOGGER_CLASSES", "removeLoggerErrorFrames", "", "Ljava/lang/StackTraceElement;", "stackTraceElements", "([Ljava/lang/StackTraceElement;)[Ljava/lang/StackTraceElement;", "regex", "Lkotlin/text/Regex;", "calculateSignature", "t", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nExceptionDataCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionDataCollection.kt\ncom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,523:1\n1#2:524\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExceptionDataCollection getInstance() {
            Object object = ApplicationManager.getApplication().getService(ExceptionDataCollection.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ExceptionDataCollection)object;
        }

        private final StackTraceElement[] removeLoggerErrorFrames(StackTraceElement[] stackTraceElements) {
            int firstNonLoggerFrame;
            for (firstNonLoggerFrame = 0; firstNonLoggerFrame < stackTraceElements.length && Intrinsics.areEqual((Object)stackTraceElements[firstNonLoggerFrame].getMethodName(), (Object)"error") && LOGGER_CLASSES.contains((Object)stackTraceElements[firstNonLoggerFrame].getClassName()); ++firstNonLoggerFrame) {
            }
            return (StackTraceElement[])ArraysKt.sliceArray((Object[])stackTraceElements, (IntRange)RangesKt.until((int)firstNonLoggerFrame, (int)stackTraceElements.length));
        }

        @NotNull
        public final String calculateSignature(@NotNull Throwable t) {
            Object object;
            String classLoaderName;
            String it;
            String className;
            StringBuilder sb;
            Object[] stackTrace;
            MessageDigest digest;
            block10: {
                block9: {
                    block8: {
                        Object object2;
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                            digest = MessageDigest.getInstance("SHA-1");
                            Throwable throwable = StudioExceptionReport.getRootCause(t);
                            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(...)");
                            Throwable rootCause = throwable;
                            StackTraceElement[] originalStackTrace = rootCause.getStackTrace();
                            Intrinsics.checkNotNull((Object)originalStackTrace);
                            if (originalStackTrace.length == 0) {
                                return "MissingCrashedThreadStack";
                            }
                            stackTrace = this.removeLoggerErrorFrames(originalStackTrace);
                            boolean isLoggerError = originalStackTrace.length != stackTrace.length;
                            sb = new StringBuilder();
                            CollectionsKt.joinTo$default((Iterable)ArraysKt.slice((Object[])stackTrace, (IntRange)RangesKt.until((int)1, (int)Integer.min(6, stackTrace.length))), (Appendable)sb, (CharSequence)"", null, null, (int)0, null, Companion::calculateSignature$lambda$2, (int)60, null);
                            className = isLoggerError ? ExceptionDataCollection.LOGGER_ERROR_MESSAGE_EXCEPTION : rootCause.getClass().getName();
                            object2 = ((StackTraceElement)stackTrace[0]).getClassLoaderName();
                            if (object2 == null) break block7;
                            it = object2;
                            boolean bl = false;
                            String string = ((StackTraceElement)stackTrace[0]).getClassLoaderName() + "/";
                            object2 = string;
                            if (string != null) break block8;
                        }
                        object2 = classLoaderName = "";
                    }
                    if ((object = ((StackTraceElement)stackTrace[0]).getModuleName()) == null) break block9;
                    String moduleName = object;
                    boolean bl = false;
                    String string = ((StackTraceElement)stackTrace[0]).getModuleVersion() != null ? moduleName + "@" + ((StackTraceElement)stackTrace[0]).getModuleVersion() + "/" : moduleName + "/";
                    object = string;
                    if (string != null) break block10;
                }
                object = "";
            }
            String modulePart = object;
            String signaturePrefix = className + " at " + classLoaderName + modulePart + ((StackTraceElement)stackTrace[0]).getClassName() + "." + ((StackTraceElement)stackTrace[0]).getMethodName();
            sb.append(signaturePrefix);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            it = string;
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = it.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] hashBytes = digest.digest(byArray);
            Intrinsics.checkNotNull((Object)hashBytes);
            String string2 = ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, Companion::calculateSignature$lambda$5, (int)30, null).substring(0, 8);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String hash = string2;
            return signaturePrefix + "-" + hash;
        }

        private static final CharSequence calculateSignature$lambda$2(StackTraceElement it) {
            CharSequence charSequence;
            block12: {
                block7: {
                    Object object;
                    String classLoaderName;
                    String methodName;
                    block11: {
                        block10: {
                            block9: {
                                Object object2;
                                block8: {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    methodName = it.getMethodName();
                                    Regex regex = regex;
                                    String string = methodName;
                                    Intrinsics.checkNotNull((Object)string);
                                    MatchResult matchResult = regex.matchEntire((CharSequence)string);
                                    if (matchResult != null) {
                                        methodName = (String)matchResult.getGroupValues().get(1);
                                    }
                                    if (Intrinsics.areEqual((Object)methodName, (Object)"")) break block7;
                                    object2 = it.getClassLoaderName();
                                    if (object2 == null) break block8;
                                    String it2 = object2;
                                    boolean bl = false;
                                    String string2 = it2 + "/";
                                    object2 = string2;
                                    if (string2 != null) break block9;
                                }
                                object2 = classLoaderName = "";
                            }
                            if ((object = it.getModuleName()) == null) break block10;
                            String moduleName = object;
                            boolean bl = false;
                            String string = it.getModuleVersion() != null ? moduleName + "@" + it.getModuleVersion() + "/" : moduleName + "/";
                            object = string;
                            if (string != null) break block11;
                        }
                        object = "";
                    }
                    String modulePart = object;
                    charSequence = classLoaderName + modulePart + it.getClassName() + "." + methodName;
                    break block12;
                }
                charSequence = "";
            }
            return charSequence;
        }

        private static final CharSequence calculateSignature$lambda$5(byte it) {
            String string = Integer.toString(it & 0xFF, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return StringsKt.padStart((String)string, (int)2, (char)'0');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$ExceptionDataCollectionLayout;", "Ljava/util/logging/Formatter;", "<init>", "()V", "creationTimestamp", "", "format", "", "event", "Ljava/util/logging/LogRecord;", "intellij.android.core"})
    public static final class ExceptionDataCollectionLayout
    extends Formatter {
        private final long creationTimestamp = System.currentTimeMillis();

        @Override
        @NotNull
        public String format(@Nullable LogRecord event) {
            StringBuilder stringBuilder;
            if (event == null) {
                return "";
            }
            long now = System.currentTimeMillis();
            StringBuilder $this$format_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$format_u24lambda_u240.append('[');
            $this$format_u24lambda_u240.append(StringsKt.padStart$default((String)String.valueOf(now - this.creationTimestamp), (int)7, (char)'\u0000', (int)2, null));
            $this$format_u24lambda_u240.append("] ");
            String string = event.getLevel().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String levelString = string;
            String string2 = levelString.substring(0, Integer.min(1, levelString.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            $this$format_u24lambda_u240.append(string2);
            $this$format_u24lambda_u240.append(" [");
            String category = event.getLoggerName();
            Intrinsics.checkNotNull((Object)category);
            String string3 = category.substring(Integer.max(0, category.length() - 30), category.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            $this$format_u24lambda_u240.append(string3);
            $this$format_u24lambda_u240.append("] ");
            String message = event.getMessage().toString();
            String string4 = message.substring(0, Integer.min(200, message.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            $this$format_u24lambda_u240.append(string4);
            return stringBuilder.toString();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$TrackingAppender;", "Ljava/util/logging/Handler;", "logger", "Ljava/util/logging/Logger;", "formatter", "Ljava/util/logging/Formatter;", "logBuffer", "Lcom/android/tools/idea/diagnostics/crash/LogBuffer;", "<init>", "(Ljava/util/logging/Logger;Ljava/util/logging/Formatter;Lcom/android/tools/idea/diagnostics/crash/LogBuffer;)V", "getLogger", "()Ljava/util/logging/Logger;", "publish", "", "record", "Ljava/util/logging/LogRecord;", "flush", "close", "intellij.android.core"})
    public static final class TrackingAppender
    extends Handler {
        @NotNull
        private final java.util.logging.Logger logger;
        @NotNull
        private final LogBuffer logBuffer;

        public TrackingAppender(@NotNull java.util.logging.Logger logger, @NotNull Formatter formatter, @NotNull LogBuffer logBuffer) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
            Intrinsics.checkNotNullParameter((Object)logBuffer, (String)"logBuffer");
            this.logger = logger;
            this.logBuffer = logBuffer;
            this.setFormatter(formatter);
        }

        @NotNull
        public final java.util.logging.Logger getLogger() {
            return this.logger;
        }

        @Override
        public void publish(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            if (Intrinsics.areEqual((Object)record.getLoggerName(), (Object)this.logger.getName())) {
                String string = this.getFormatter().format(record);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                this.logBuffer.addEntry(string);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionSeverity.values().length];
            try {
                nArray[ExceptionSeverity.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

