/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import com.android.tools.idea.diagnostics.DiagnosticUtils;
import com.android.tools.idea.diagnostics.freeze.FreezeGraph;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u001c\u0010\u0013\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n*\u00060\u0017j\u0002`\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\n*\u00060\u0017j\u0002`\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/diagnostics/LockStatusReportContributor;", "Lcom/android/tools/idea/diagnostics/DiagnosticReportContributor;", "<init>", "()V", "report", "", "threadBean", "Ljava/lang/management/ThreadMXBean;", "kotlin.jvm.PlatformType", "setup", "", "configuration", "Lcom/android/tools/idea/diagnostics/DiagnosticReportConfiguration;", "startCollection", "timeElapsedSoFarMs", "", "stopCollection", "totalDurationMs", "getReport", "generateReport", "saveReportCallback", "Ljava/util/function/BiConsumer;", "appendJvmAnalysis", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendFreezeGraphAnalysis", "freezeGraph", "Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLockStatusReportContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LockStatusReportContributor.kt\ncom/android/tools/idea/diagnostics/LockStatusReportContributor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,120:1\n1310#2,2:121\n*S KotlinDebug\n*F\n+ 1 LockStatusReportContributor.kt\ncom/android/tools/idea/diagnostics/LockStatusReportContributor\n*L\n58#1:121,2\n*E\n"})
public final class LockStatusReportContributor
implements DiagnosticReportContributor {
    @NotNull
    private String report = "";
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    @Override
    public void setup(@NotNull DiagnosticReportConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
    }

    @Override
    public void startCollection(long timeElapsedSoFarMs) {
        ThreadInfo[] threadInfoArray = this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds(), true, true);
        Intrinsics.checkNotNullExpressionValue((Object)threadInfoArray, (String)"getThreadInfo(...)");
        List allThreads = ArraysKt.filterNotNull((Object[])threadInfoArray);
        FreezeGraph freezeGraph = FreezeGraph.Companion.analyzeThreads(allThreads);
        StringBuilder sb = new StringBuilder();
        try {
            this.appendFreezeGraphAnalysis(sb, freezeGraph);
            sb.append('\n');
            this.appendJvmAnalysis(sb);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.report = string;
        }
        catch (Throwable t) {
            this.report = "ERROR: " + ExceptionsKt.stackTraceToString((Throwable)t) + "\n" + sb;
        }
    }

    @Override
    public void stopCollection(long totalDurationMs) {
    }

    @Override
    @NotNull
    public String getReport() {
        return this.report;
    }

    @Override
    public void generateReport(@NotNull BiConsumer<String, String> saveReportCallback) {
        Intrinsics.checkNotNullParameter(saveReportCallback, (String)"saveReportCallback");
        saveReportCallback.accept("lockDiagnostics", this.report);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendJvmAnalysis(StringBuilder $this$appendJvmAnalysis) {
        ThreadInfo threadInfo;
        Object object;
        Object[] allThreads;
        long[] deadlockedThreads;
        block15: {
            void $this$firstOrNull$iv;
            Object object2;
            block17: {
                block16: {
                    object2 = this.threadBean.findDeadlockedThreads();
                    if ((long[])object2 == null) break block16;
                    Set set2 = ArraysKt.toSet((long[])object2);
                    object2 = set2;
                    if (set2 != null) break block17;
                }
                object2 = SetsKt.emptySet();
            }
            deadlockedThreads = object2;
            allThreads = this.threadBean.dumpAllThreads(true, true);
            Intrinsics.checkNotNull((Object)allThreads);
            object = allThreads;
            DiagnosticUtils.Companion companion = DiagnosticUtils.Companion;
            boolean $i$f$firstOrNull = false;
            int n = ((void)$this$firstOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void p0 = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!companion.isAwtThread((ThreadInfo)p0)) continue;
                threadInfo = element$iv;
                break block15;
            }
            threadInfo = null;
        }
        ThreadInfo awtThread = threadInfo;
        $this$appendJvmAnalysis.append('\n');
        $this$appendJvmAnalysis.append("ANALYSIS - JVM").append('\n');
        $this$appendJvmAnalysis.append("==============").append('\n');
        ThreadInfo threadInfo2 = awtThread;
        $this$appendJvmAnalysis.append("AWT thread ID: " + (threadInfo2 != null ? Long.valueOf(threadInfo2.getThreadId()) : null)).append('\n');
        if (deadlockedThreads.isEmpty()) {
            v4 = $this$appendJvmAnalysis.append("JVM did not detect any deadlocks").append('\n');
        } else {
            String awtDeadlockedString = awtThread != null && deadlockedThreads.contains(awtThread.getThreadId()) ? "AWT#" + awtThread.getThreadId() : "background";
            $this$appendJvmAnalysis.append("JVM detected a deadlock (" + awtDeadlockedString + ")").append('\n');
            v4 = $this$appendJvmAnalysis.append("Deadlocked threads: [" + CollectionsKt.joinToString$default((Iterable)((Iterable)deadlockedThreads), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]").append('\n');
        }
        object = ArrayIteratorKt.iterator((Object[])allThreads);
        while (object.hasNext()) {
            Iterator iterator2;
            ThreadInfo threadInfo3 = (ThreadInfo)object.next();
            LockInfo lockInfo = threadInfo3.getLockInfo();
            Object[] lockedMonitors = threadInfo3.getLockedMonitors();
            Object[] lockedSynchronizers = threadInfo3.getLockedSynchronizers();
            if (lockInfo != null && threadInfo3.getLockOwnerId() != -1L) {
                $this$appendJvmAnalysis.append("Thread #" + threadInfo3.getThreadId() + " blocked on ");
                $this$appendJvmAnalysis.append(lockInfo.getClassName() + "@" + lockInfo.getIdentityHashCode() + " owned by thread #" + threadInfo3.getLockOwnerId());
                $this$appendJvmAnalysis.append(": " + threadInfo3.getThreadState());
                if (deadlockedThreads.contains(threadInfo3.getThreadId())) {
                    $this$appendJvmAnalysis.append(" - DEADLOCKED");
                }
                v5 = $this$appendJvmAnalysis.append('\n');
            } else {
                Intrinsics.checkNotNull((Object)lockedMonitors);
                if (!(!(lockedMonitors.length == 0))) {
                    Intrinsics.checkNotNull((Object)lockedSynchronizers);
                    if (!(!(lockedSynchronizers.length == 0))) continue;
                }
                v5 = $this$appendJvmAnalysis.append("Thread #" + threadInfo3.getThreadId() + ": " + threadInfo3.getThreadState()).append('\n');
            }
            Intrinsics.checkNotNull((Object)lockedMonitors);
            if (!(lockedMonitors.length == 0)) {
                $this$appendJvmAnalysis.append("  Locked monitors:").append('\n');
                iterator2 = ArrayIteratorKt.iterator((Object[])lockedMonitors);
                while (iterator2.hasNext()) {
                    MonitorInfo lockedMonitor = (MonitorInfo)iterator2.next();
                    int stackDepth = lockedMonitor.getLockedStackDepth();
                    $this$appendJvmAnalysis.append("  * " + lockedMonitor.getClassName() + "@" + lockedMonitor.getIdentityHashCode() + " at " + lockedMonitor.getLockedStackFrame());
                    if (stackDepth >= 0) {
                        $this$appendJvmAnalysis.append("@" + stackDepth);
                    }
                    $this$appendJvmAnalysis.append('\n');
                }
            }
            Intrinsics.checkNotNull((Object)lockedSynchronizers);
            if (!(!(lockedSynchronizers.length == 0))) continue;
            $this$appendJvmAnalysis.append("  Locked synchronizers:").append('\n');
            iterator2 = ArrayIteratorKt.iterator((Object[])lockedSynchronizers);
            while (iterator2.hasNext()) {
                LockInfo lockedSynchronizer = (LockInfo)iterator2.next();
                $this$appendJvmAnalysis.append("  * " + lockedSynchronizer.getClassName() + "@" + lockedSynchronizer.getIdentityHashCode()).append('\n');
            }
        }
    }

    private final void appendFreezeGraphAnalysis(StringBuilder $this$appendFreezeGraphAnalysis, FreezeGraph freezeGraph) {
        $this$appendFreezeGraphAnalysis.append("ANALYSIS - FREEZE GRAPH").append('\n');
        $this$appendFreezeGraphAnalysis.append("=======================").append('\n');
        $this$appendFreezeGraphAnalysis.append("AWT thread deadlocked: " + freezeGraph.getAwtDeadlocked()).append('\n');
        $this$appendFreezeGraphAnalysis.append("Summary:").append('\n');
        $this$appendFreezeGraphAnalysis.append(freezeGraph.getSummary());
    }
}

