/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.monitor.adbimpl;

import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.device.explorer.monitor.DeviceService;
import com.android.tools.idea.device.explorer.monitor.DeviceServiceListener;
import com.android.tools.idea.device.explorer.monitor.adbimpl.AdbDeviceService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.guava.ListenableFutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 22\u00020\u00012\u00020\u0002:\u0005./012B\u0019\b\u0007\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0013H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0013H\u0016J\u0014\u0010%\u001a\u0004\u0018\u00010\u00102\b\u0010&\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010'\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/device/explorer/monitor/DeviceService;", "adbSupplier", "Lkotlin/Function0;", "Ljava/io/File;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "devices", "", "", "Lcom/android/ddmlib/IDevice;", "listeners", "", "Lcom/android/tools/idea/device/explorer/monitor/DeviceServiceListener;", "state", "Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$State;", "bridge", "Lcom/android/ddmlib/AndroidDebugBridge;", "clientChangeListener", "Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$DeviceClientListener;", "deviceChangeListener", "Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$DeviceChangeListener;", "debugBridgeChangeListener", "Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$DebugBridgeChangeListener;", "deviceListSynced", "Lkotlinx/coroutines/CompletableDeferred;", "", "dispose", "addListener", "listener", "removeListener", "getIDeviceFromSerialNumber", "serialNumber", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMaskBitSet", "", "value", "", "mask", "State", "DebugBridgeChangeListener", "DeviceChangeListener", "DeviceClientListener", "Companion", "intellij.android.device-explorer-monitor"})
@SourceDebugExtension(value={"SMAP\nAdbDeviceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbDeviceService.kt\ncom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,207:1\n14#2:208\n*S KotlinDebug\n*F\n+ 1 AdbDeviceService.kt\ncom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService\n*L\n205#1:208\n*E\n"})
public final class AdbDeviceService
implements Disposable,
DeviceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<File> adbSupplier;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Map<String, IDevice> devices;
    @NotNull
    private final List<DeviceServiceListener> listeners;
    @NotNull
    private State state;
    @Nullable
    private AndroidDebugBridge bridge;
    @NotNull
    private final DeviceClientListener clientChangeListener;
    @NotNull
    private final DeviceChangeListener deviceChangeListener;
    @NotNull
    private final DebugBridgeChangeListener debugBridgeChangeListener;
    @NotNull
    private CompletableDeferred<Unit> deviceListSynced;
    @NotNull
    private static Logger LOGGER;

    @NonInjectable
    public AdbDeviceService(@NotNull Function0<? extends File> adbSupplier) {
        Intrinsics.checkNotNullParameter(adbSupplier, (String)"adbSupplier");
        this.adbSupplier = adbSupplier;
        this.coroutineScope = CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        this.devices = new HashMap();
        this.listeners = new ArrayList();
        this.state = State.Initial;
        this.clientChangeListener = new DeviceClientListener();
        this.deviceChangeListener = new DeviceChangeListener();
        this.debugBridgeChangeListener = new DebugBridgeChangeListener();
        this.deviceListSynced = CompletableDeferredKt.CompletableDeferred((Job)((Job)this.coroutineScope.getCoroutineContext().get((CoroutineContext.Key)Job.Key)));
    }

    public AdbDeviceService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this((Function0<? extends File>)((Function0)() -> AdbDeviceService._init_$lambda$0(project)));
    }

    public void dispose() {
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.clientChangeListener);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.deviceChangeListener);
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.debugBridgeChangeListener);
        this.bridge = null;
        this.devices.clear();
        this.listeners.clear();
    }

    @Override
    public void addListener(@NotNull DeviceServiceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceServiceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.listeners.remove(listener2);
    }

    @Override
    @Nullable
    public IDevice getIDeviceFromSerialNumber(@Nullable String serialNumber) {
        if (serialNumber == null) {
            return null;
        }
        return this.devices.containsKey(serialNumber) ? this.devices.get(serialNumber) : null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object start(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof start.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AdbDeviceService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (this.state == State.SetupRunning || this.state == State.SetupDone) {
                    return Unit.INSTANCE;
                }
                adb = (File)this.adbSupplier.invoke();
                if (adb == null) {
                    AdbDeviceService.LOGGER.warn("ADB not found");
                    throw new FileNotFoundException("Android Debug Bridge not found.");
                }
                AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.clientChangeListener);
                AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.deviceChangeListener);
                AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.debugBridgeChangeListener);
                this.state = State.SetupRunning;
                v0 = AdbService.getInstance().getDebugBridge(adb);
                Intrinsics.checkNotNullExpressionValue(v0, (String)"getDebugBridge(...)");
                $continuation.L$0 = adb;
                $continuation.label = 1;
                v1 = ListenableFutureKt.await(v0, (Continuation)$continuation);
                ** if (v1 != var6_4) goto lbl32
lbl31:
                // 1 sources

                return var6_4;
lbl32:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                adb = (File)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                AdbDeviceService.LOGGER.debug("Successfully obtained debug bridge");
                $continuation.L$0 = adb;
                $continuation.label = 2;
                v2 = this.deviceListSynced.await((Continuation)$continuation);
                ** if (v2 != var6_4) goto lbl45
lbl44:
                // 1 sources

                return var6_4;
lbl45:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                adb = (File)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl52:
                    // 2 sources

                    this.state = State.SetupDone;
                }
                catch (Throwable t) {
                    AdbDeviceService.LOGGER.warn("Unable to obtain debug bridge", t);
                    this.state = State.Initial;
                    if (t.getMessage() != null) {
                        throw t;
                    }
                    throw new RuntimeException(AdbService.getDebugBridgeDiagnosticErrorMessage(t, adb), t);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isMaskBitSet(int value2, int mask) {
        return (value2 & mask) != 0;
    }

    private static final File _init_$lambda$0(Project $project) {
        return AdbFileProvider.Companion.fromProject($project).get();
    }

    public static final /* synthetic */ AndroidDebugBridge access$getBridge$p(AdbDeviceService $this) {
        return $this.bridge;
    }

    public static final /* synthetic */ void access$setBridge$p(AdbDeviceService $this, AndroidDebugBridge androidDebugBridge) {
        $this.bridge = androidDebugBridge;
    }

    public static final /* synthetic */ CompletableDeferred access$getDeviceListSynced$p(AdbDeviceService $this) {
        return $this.deviceListSynced;
    }

    public static final /* synthetic */ boolean access$isMaskBitSet(AdbDeviceService $this, int value2, int mask) {
        return $this.isMaskBitSet(value2, mask);
    }

    public static final /* synthetic */ List access$getListeners$p(AdbDeviceService $this) {
        return $this.listeners;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AdbDeviceService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService;", "project", "Lcom/intellij/openapi/project/Project;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOGGER", "()Lcom/intellij/openapi/diagnostic/Logger;", "setLOGGER", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "intellij.android.device-explorer-monitor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AdbDeviceService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(AdbDeviceService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AdbDeviceService)object;
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public final void setLOGGER(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
            LOGGER = logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$DebugBridgeChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDebugBridgeChangeListener;", "<init>", "(Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService;)V", "bridgeChanged", "", "bridge", "Lcom/android/ddmlib/AndroidDebugBridge;", "intellij.android.device-explorer-monitor"})
    private final class DebugBridgeChangeListener
    implements AndroidDebugBridge.IDebugBridgeChangeListener {
        public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
            Companion.getLOGGER().info("Debug bridge changed");
            BuildersKt.launch$default((CoroutineScope)AdbDeviceService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceService.this, bridge, null){
                int label;
                final /* synthetic */ AdbDeviceService this$0;
                final /* synthetic */ AndroidDebugBridge $bridge;
                {
                    this.this$0 = $receiver;
                    this.$bridge = $bridge;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (AdbDeviceService.access$getBridge$p(this.this$0) != null) {
                                AdbDeviceService.access$getDevices$p(this.this$0).clear();
                            }
                            AdbDeviceService.access$setBridge$p(this.this$0, this.$bridge);
                            if (this.$bridge != null) {
                                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.$bridge.getDevices());
                                while (iterator2.hasNext()) {
                                    IDevice device2 = (IDevice)iterator2.next();
                                    AdbDeviceService.access$getDevices$p(this.this$0).put(device2.getSerialNumber(), device2);
                                }
                            }
                            AdbDeviceService.access$getDeviceListSynced$p(this.this$0).complete((Object)Unit.INSTANCE);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$DeviceChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "<init>", "(Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService;)V", "deviceConnected", "", "device", "Lcom/android/ddmlib/IDevice;", "deviceDisconnected", "deviceChanged", "changeMask", "", "intellij.android.device-explorer-monitor"})
    private final class DeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        public void deviceConnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Logger logger = Companion.getLOGGER();
            String string = "Device connected: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.debug(string2);
            AdbDeviceService.this.devices.put(device2.getSerialNumber(), device2);
        }

        public void deviceDisconnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Logger logger = Companion.getLOGGER();
            String string = "Device disconnected: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.debug(string2);
            AdbDeviceService.this.devices.remove(device2.getSerialNumber());
        }

        public void deviceChanged(@NotNull IDevice device2, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Logger logger = Companion.getLOGGER();
            String string = "Device changed: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.debug(string2);
            BuildersKt.launch$default((CoroutineScope)AdbDeviceService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceService.this, device2, changeMask, null){
                int label;
                final /* synthetic */ AdbDeviceService this$0;
                final /* synthetic */ IDevice $device;
                final /* synthetic */ int $changeMask;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    this.$changeMask = $changeMask;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            IDevice iDevice = (IDevice)AdbDeviceService.access$getDevices$p(this.this$0).get(this.$device.getSerialNumber());
                            if (iDevice != null) {
                                IDevice iDevice2 = iDevice;
                                AdbDeviceService adbDeviceService = this.this$0;
                                int n = this.$changeMask;
                                IDevice it = iDevice2;
                                boolean bl = false;
                                if (AdbDeviceService.access$isMaskBitSet(adbDeviceService, n, 2)) {
                                    Iterable $this$forEach$iv = AdbDeviceService.access$getListeners$p(adbDeviceService);
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        DeviceServiceListener l = (DeviceServiceListener)element$iv;
                                        boolean bl2 = false;
                                        l.deviceProcessListUpdated(it);
                                    }
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$DeviceClientListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IClientChangeListener;", "<init>", "(Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService;)V", "clientChanged", "", "client", "Lcom/android/ddmlib/Client;", "changeMask", "", "intellij.android.device-explorer-monitor"})
    private final class DeviceClientListener
    implements AndroidDebugBridge.IClientChangeListener {
        public void clientChanged(@NotNull Client client, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            IDevice device2 = client.getDevice();
            Logger logger = Companion.getLOGGER();
            String string = "Client changed: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.debug(string2);
            BuildersKt.launch$default((CoroutineScope)AdbDeviceService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceService.this, device2, changeMask, null){
                int label;
                final /* synthetic */ AdbDeviceService this$0;
                final /* synthetic */ IDevice $device;
                final /* synthetic */ int $changeMask;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    this.$changeMask = $changeMask;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            IDevice iDevice = (IDevice)AdbDeviceService.access$getDevices$p(this.this$0).get(this.$device.getSerialNumber());
                            if (iDevice != null) {
                                IDevice iDevice2 = iDevice;
                                AdbDeviceService adbDeviceService = this.this$0;
                                int n = this.$changeMask;
                                IDevice it = iDevice2;
                                boolean bl = false;
                                if (AdbDeviceService.access$isMaskBitSet(adbDeviceService, n, 7)) {
                                    Iterable $this$forEach$iv = AdbDeviceService.access$getListeners$p(adbDeviceService);
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        DeviceServiceListener l = (DeviceServiceListener)element$iv;
                                        boolean bl2 = false;
                                        l.deviceProcessListUpdated(it);
                                    }
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/adbimpl/AdbDeviceService$State;", "", "<init>", "(Ljava/lang/String;I)V", "Initial", "SetupRunning", "SetupDone", "intellij.android.device-explorer-monitor"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Initial = new State();
        public static final /* enum */ State SetupRunning = new State();
        public static final /* enum */ State SetupDone = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Initial, State.SetupRunning, State.SetupDone};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

