/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.databinding.project.LayoutBindingEnabledFacetsProvider;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class ConvertLayoutToDataBindingAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return AndroidBundle.message("android.convert.to.data.binding.layout.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (IdeResourcesUtil.getFolderType(file) != ResourceFolderType.LAYOUT) {
            return false;
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        XmlTag tag = xmlFile.getRootTag();
        if (tag == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        if (!tag.equals((Object)element.getParent()) && offset >= tag.getTextOffset()) {
            return false;
        }
        if (tag.getName().equals("layout")) {
            return false;
        }
        LayoutBindingEnabledFacetsProvider enabledFacetsProvider = LayoutBindingEnabledFacetsProvider.getInstance(project);
        return !enabledFacetsProvider.getDataBindingEnabledFacets().isEmpty();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        XmlFile xmlFile = (XmlFile)file;
        XmlTag root = xmlFile.getRootTag();
        assert (root != null);
        XmlElementFactory factory2 = XmlElementFactory.getInstance((Project)project);
        XmlTag newRoot = factory2.createTagFromText((CharSequence)"<layout>\n<data>\n\n</data></layout>");
        String rootText = root.getText();
        newRoot = (XmlTag)root.replace((PsiElement)newRoot);
        root = factory2.createTagFromText((CharSequence)rootText);
        for (XmlAttribute attribute2 : root.getAttributes()) {
            String name2 = attribute2.getName();
            if (!name2.startsWith("xmlns:")) continue;
            newRoot.setAttribute(name2, attribute2.getValue());
            attribute2.delete();
        }
        XmlAttribute context = root.getAttribute("context", "http://schemas.android.com/tools");
        if (context != null) {
            root.setAttribute("context", "http://schemas.android.com/tools", context.getValue());
            context.delete();
        }
        newRoot.addSubTag(root, false);
    }
}

