/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.NavSource;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.Symbol;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/codenavigation/NativeNavSource;", "Lcom/android/tools/idea/codenavigation/NavSource;", "project", "Lcom/intellij/openapi/project/Project;", "symbolizer", "Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;)V", "lookUp", "Lcom/intellij/pom/Navigatable;", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "arch", "", "codenavigation"})
public final class NativeNavSource
implements NavSource {
    @NotNull
    private final Project project;
    @NotNull
    private final NativeSymbolizer symbolizer;

    public NativeNavSource(@NotNull Project project, @NotNull NativeSymbolizer symbolizer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbolizer, (String)"symbolizer");
        this.project = project;
        this.symbolizer = symbolizer;
    }

    @Override
    @Nullable
    public Navigatable lookUp(@NotNull CodeLocation location, @Nullable String arch) {
        Navigatable navigatable2;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!location.isNativeCode() || location.getFileName() == null || arch == null) {
            return null;
        }
        try {
            Symbol symbol = this.symbolizer.symbolize(arch, new File(location.getFileName()), location.getNativeVAddress());
            navigatable2 = (Navigatable)(symbol == null ? null : new FileNavigatable(this.project, new FilePosition(new File(symbol.getSourceFile()), symbol.getLineNumber() - 1, 0)));
        }
        catch (IOException e) {
            navigatable2 = null;
        }
        return navigatable2;
    }
}

