/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.tools.idea.actions.ActionUtils;
import com.android.tools.idea.backup.ActionHelper;
import com.android.tools.idea.backup.ActionHelperImpl;
import com.android.tools.idea.backup.BackupBundle;
import com.android.tools.idea.backup.BackupManager;
import com.android.tools.idea.backup.DeviceChecker;
import com.android.tools.idea.backup.DialogFactory;
import com.android.tools.idea.backup.DialogFactoryImpl;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\rH\u0002J\u0014\u0010\u0016\u001a\u00020\u000b*\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/backup/BackupAppAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionHelper", "Lcom/android/tools/idea/backup/ActionHelper;", "dialogFactory", "Lcom/android/tools/idea/backup/DialogFactory;", "<init>", "(Lcom/android/tools/idea/backup/ActionHelper;Lcom/android/tools/idea/backup/DialogFactory;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "doBackup", "project", "Lcom/intellij/openapi/project/Project;", "backupInfo", "Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo$Valid;", "getBackupInfo", "Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo;", "showDialog", "Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo$Invalid;", "BackupInfo", "intellij.android.backup"})
public final class BackupAppAction
extends AnAction {
    @NotNull
    private final ActionHelper actionHelper;
    @NotNull
    private final DialogFactory dialogFactory;

    public BackupAppAction(@NotNull ActionHelper actionHelper, @NotNull DialogFactory dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)actionHelper, (String)"actionHelper");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        this.actionHelper = actionHelper;
        this.dialogFactory = dialogFactory;
    }

    public /* synthetic */ BackupAppAction(ActionHelper actionHelper, DialogFactory dialogFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            actionHelper = new ActionHelperImpl();
        }
        if ((n & 2) != 0) {
            dialogFactory = new DialogFactoryImpl();
        }
        this(actionHelper, dialogFactory);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!((Boolean)StudioFlags.BACKUP_ENABLED.get()).booleanValue()) {
            return;
        }
        boolean ok2 = DeviceChecker.Companion.checkEventDeviceType(this, e);
        if (!ok2) {
            return;
        }
        e.getPresentation().setVisible(true);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (this.actionHelper.getApplicationId(project2) == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            ActionUtils.enableRichTooltip((Presentation)presentation, (AnAction)this, (String)"Selected run configuration is not an app");
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        ActionUtils.disableRichTooltip((Presentation)presentation);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackupInfo backupInfo = this.getBackupInfo(e);
        if (backupInfo instanceof BackupInfo.Invalid) {
            this.showDialog((BackupInfo.Invalid)backupInfo, project2);
        } else if (backupInfo instanceof BackupInfo.Valid) {
            this.doBackup(project2, (BackupInfo.Valid)backupInfo);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void doBackup(Project project, BackupInfo.Valid backupInfo) {
        BackupManager backupManager = BackupManager.Companion.getInstance(project);
        BackupManager.showBackupDialog$default(backupManager, backupInfo.getSerialNumber(), backupInfo.getApplicationId(), BackupManager.Source.BACKUP_APP_ACTION, false, 8, null);
    }

    private final BackupInfo getBackupInfo(AnActionEvent $this$getBackupInfo) {
        Project project = $this$getBackupInfo.getProject();
        if (project == null) {
            throw new IllegalStateException("Missing project");
        }
        Project project2 = project;
        String string = this.actionHelper.getDeployTargetSerial(project2);
        if (string == null) {
            return new BackupInfo.Invalid(BackupBundle.message("error.device.not.running", new Object[0]));
        }
        String serialNumber = string;
        String string2 = this.actionHelper.getApplicationId(project2);
        if (string2 == null) {
            return new BackupInfo.Invalid(BackupBundle.message("error.incompatible.run.config", new Object[0]));
        }
        String applicationId2 = string2;
        int targetCount = this.actionHelper.getDeployTargetCount(project2);
        return targetCount == 0 ? (BackupInfo)new BackupInfo.Invalid(BackupBundle.message("error.device.not.running", new Object[0])) : (targetCount > 1 ? (BackupInfo)new BackupInfo.Invalid(BackupBundle.message("error.multiple.devices", new Object[0])) : (BackupInfo)new BackupInfo.Valid(applicationId2, serialNumber));
    }

    private final void showDialog(BackupInfo.Invalid $this$showDialog, Project project) {
        DialogFactory.showDialog$default(this.dialogFactory, project, BackupBundle.message("backup.app.action.error.title", new Object[0]), $this$showDialog.getReason(), null, 8, null);
    }

    public BackupAppAction() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo;", "", "<init>", "()V", "Valid", "Invalid", "Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo$Invalid;", "Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo$Valid;", "intellij.android.backup"})
    private static abstract sealed class BackupInfo {
        private BackupInfo() {
        }

        public /* synthetic */ BackupInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo$Invalid;", "Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo;", "reason", "", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "intellij.android.backup"})
        public static final class Invalid
        extends BackupInfo {
            @NotNull
            private final String reason;

            public Invalid(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo$Valid;", "Lcom/android/tools/idea/backup/BackupAppAction$BackupInfo;", "applicationId", "", "serialNumber", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "getSerialNumber", "intellij.android.backup"})
        public static final class Valid
        extends BackupInfo {
            @NotNull
            private final String applicationId;
            @NotNull
            private final String serialNumber;

            public Valid(@NotNull String applicationId2, @NotNull String serialNumber) {
                Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
                Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
                super(null);
                this.applicationId = applicationId2;
                this.serialNumber = serialNumber;
            }

            @NotNull
            public final String getApplicationId() {
                return this.applicationId;
            }

            @NotNull
            public final String getSerialNumber() {
                return this.serialNumber;
            }
        }
    }
}

