/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EnumSet;
import javax.swing.ComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class StorageField
extends JPanel {
    private final Storage.Unit DEFAULT_UNIT = Storage.Unit.MiB;
    private final ComboBoxModel unitModel = new EnumComboBoxModel<Storage.Unit>(Storage.Unit.class){

        @NotNull
        protected EnumSet<Storage.Unit> createEnumSet(@NotNull Class<Storage.Unit> en) {
            return EnumSet.of(Storage.Unit.KiB, Storage.Unit.MiB, Storage.Unit.GiB);
        }
    };
    private final ComboBox myUnitsCombo = new ComboBox(this.unitModel);
    private final JTextField myValueField = new JTextField();
    private Storage.Unit myCurrentUnit = this.DEFAULT_UNIT;
    private final ObjectProperty<Storage> myStorage = new ObjectValueProperty<Storage>(new Storage(0L, this.DEFAULT_UNIT));

    public ObjectProperty<Storage> storage() {
        return this.myStorage;
    }

    public final Dimension getPreferredSizeOfUnitsDropdown() {
        return this.myUnitsCombo.getPreferredSize();
    }

    public StorageField() {
        this.setLayout(new BorderLayout(3, 0));
        this.updateStorageField();
        this.add((Component)this.myValueField, "Center");
        this.add((Component)this.myUnitsCombo, "East");
        this.myUnitsCombo.setSelectedItem((Object)this.DEFAULT_UNIT);
        this.myUnitsCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", Storage.Unit::getDisplayValue));
        this.myValueField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> StorageField.this.updateStorage());
            }
        });
        this.myUnitsCombo.addActionListener(e -> this.updateStorageField());
        this.myStorage.addListener(() -> this.updateStorageField());
    }

    private void updateStorageField() {
        String oldText;
        this.myCurrentUnit = (Storage.Unit)this.myUnitsCombo.getSelectedItem();
        String newText = Long.toString(((Storage)this.myStorage.get()).getSizeAsUnit(this.myCurrentUnit));
        if (!newText.equals(oldText = this.myValueField.getText())) {
            this.myValueField.setText(newText);
        }
    }

    private void updateStorage() {
        String text2 = this.myValueField.getText();
        if (text2 == null || text2.isEmpty()) {
            this.myStorage.set(new Storage(0L, this.myCurrentUnit));
        } else {
            try {
                long newValue = Long.parseLong(text2);
                this.myStorage.set(new Storage(newValue, this.myCurrentUnit));
            }
            catch (NumberFormatException ex) {
                long oldValue = ((Storage)this.myStorage.get()).getSizeAsUnit(this.myCurrentUnit);
                this.myValueField.setText(Long.toString(oldValue));
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myUnitsCombo.setEnabled(enabled);
        this.myValueField.setEnabled(enabled);
    }
}

