/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.deviceprovisioner.RunningAvd;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.EmulatorLogListener;
import com.android.tools.idea.avdmanager.EmulatorProcessHandlerKt;
import com.android.tools.idea.avdmanager.RunningAvdTracker;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.messages.MessageBus;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/avdmanager/EmulatorProcessHandler;", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "process", "Ljava/lang/Process;", "commandLine", "", "avd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "<init>", "(Ljava/lang/Process;Ljava/lang/String;Lcom/android/sdklib/internal/avd/AvdInfo;)V", "avdName", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "defaultMessagePattern", "Lkotlin/text/Regex;", "verboseMessagePattern", "runType", "Lcom/android/sdklib/deviceprovisioner/RunningAvd$RunType;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "ownedRunningEmulators", "Lcom/android/tools/idea/avdmanager/RunningAvdTracker;", "notifyListeners", "", "severity", "Lcom/android/tools/idea/avdmanager/EmulatorLogListener$Severity;", "notifyUser", "", "message", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "EmulatorProcessListener", "intellij.android.core"})
public final class EmulatorProcessHandler
extends BaseOSProcessHandler {
    @NotNull
    private final AvdInfo avd;
    @NotNull
    private final String avdName;
    @NotNull
    private final Logger log;
    @NotNull
    private final Regex defaultMessagePattern;
    @NotNull
    private final Regex verboseMessagePattern;
    @NotNull
    private final RunningAvd.RunType runType;
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private final RunningAvdTracker ownedRunningEmulators;

    public EmulatorProcessHandler(@NotNull Process process2, @NotNull String commandLine, @NotNull AvdInfo avd) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        super(process2, commandLine, null);
        this.avd = avd;
        this.avdName = this.avd.getDisplayName();
        Logger logger = Logger.getInstance((String)("Emulator: " + this.avdName));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.defaultMessagePattern = new Regex("^(?<notifyUser>USER_)?(?<severity>VERBOSE|DEBUG|INFO|WARNING|ERROR|FATAL)\\s+\\| (?<message>.*)");
        this.verboseMessagePattern = new Regex("^(?<timestamp>\\d+:\\d+:\\d+\\.\\d+) (?<thread>\\d+)\\s+(?<notifyUser>USER_)?(?<severity>VERBOSE|DEBUG|INFO|WARNING|ERROR|FATAL)\\s+(?<location>[\\w-]+\\.[A-Za-z]+:\\d+)\\s+\\| (?<message>.*)");
        this.runType = StringsKt.contains$default((CharSequence)commandLine, (CharSequence)" -qt-hide-window ", (boolean)false, (int)2, null) ? RunningAvd.RunType.EMBEDDED : RunningAvd.RunType.STANDALONE;
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        this.messageBus = messageBus;
        this.ownedRunningEmulators = RunningAvdTracker.Companion.getInstance();
        this.addProcessListener(new EmulatorProcessListener());
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)this));
    }

    private final void notifyListeners(AvdInfo avd, EmulatorLogListener.Severity severity, boolean notifyUser, String message) {
        try {
            ((EmulatorLogListener)this.messageBus.syncPublisher(EmulatorLogListener.Companion.getTOPIC())).messageLogged(avd, severity, notifyUser, message);
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
            // empty catch block
        }
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
        return options;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorProcessListener;", "Lcom/intellij/execution/process/ProcessListener;", "<init>", "(Lcom/android/tools/idea/avdmanager/EmulatorProcessHandler;)V", "startNotified", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "parseAndLogMessage", "text", "", "notify", "title", "content", "notificationType", "Lcom/intellij/notification/NotificationType;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nEmulatorProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorProcessHandler.kt\ncom/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorProcessListener\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,179:1\n106#2:180\n78#2,22:181\n*S KotlinDebug\n*F\n+ 1 EmulatorProcessHandler.kt\ncom/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorProcessListener\n*L\n104#1:180\n104#1:181,22\n*E\n"})
    private final class EmulatorProcessListener
    implements ProcessListener {
        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            RunningAvdTracker runningAvdTracker = EmulatorProcessHandler.this.ownedRunningEmulators;
            Path path = EmulatorProcessHandler.this.avd.getDataFolderPath();
            ProcessHandle processHandle = EmulatorProcessHandler.this.getProcess().toHandle();
            Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
            runningAvdTracker.started(path, processHandle, EmulatorProcessHandler.this.runType, true);
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Integer exitCode2;
            String text2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            String string = event.getText();
            if (string != null) {
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                v2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else {
                v2 = text2 = null;
            }
            if (text2 != null) {
                this.parseAndLogMessage(text2);
            }
            if (Intrinsics.areEqual((Object)ProcessOutputType.SYSTEM, outputType) && EmulatorProcessHandler.this.isProcessTerminated() && (exitCode2 = EmulatorProcessHandler.this.getExitCode()) != null && exitCode2 != 0) {
                EmulatorProcessHandler.this.log.warn("Emulator terminated with exit code " + exitCode2);
            }
        }

        private final void parseAndLogMessage(String text2) {
            boolean notifyUser = false;
            EmulatorLogListener.Severity severity = null;
            Object message = null;
            MatchResult matchResult = EmulatorProcessHandler.this.defaultMessagePattern.matchEntire((CharSequence)text2);
            MatchNamedGroupCollection groups = (MatchNamedGroupCollection)(matchResult != null ? matchResult.getGroups() : null);
            if (groups != null) {
                notifyUser = groups.get("notifyUser") != null;
                MatchGroup matchGroup = groups.get("severity");
                Intrinsics.checkNotNull((Object)matchGroup);
                severity = EmulatorProcessHandlerKt.access$mapSeverity(matchGroup.getValue());
                MatchGroup matchGroup2 = groups.get("message");
                Intrinsics.checkNotNull((Object)matchGroup2);
                message = matchGroup2.getValue();
            } else {
                MatchResult matchResult2 = EmulatorProcessHandler.this.verboseMessagePattern.matchEntire((CharSequence)text2);
                groups = (MatchNamedGroupCollection)(matchResult2 != null ? matchResult2.getGroups() : null);
                if (groups != null) {
                    notifyUser = groups.get("notifyUser") != null;
                    MatchGroup matchGroup = groups.get("severity");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    severity = EmulatorProcessHandlerKt.access$mapSeverity(matchGroup.getValue());
                    MatchGroup matchGroup3 = groups.get("timestamp");
                    Intrinsics.checkNotNull((Object)matchGroup3);
                    String string = matchGroup3.getValue();
                    MatchGroup matchGroup4 = groups.get("thread");
                    Intrinsics.checkNotNull((Object)matchGroup4);
                    String string2 = matchGroup4.getValue();
                    MatchGroup matchGroup5 = groups.get("location");
                    Intrinsics.checkNotNull((Object)matchGroup5);
                    String string3 = matchGroup5.getValue();
                    MatchGroup matchGroup6 = groups.get("message");
                    Intrinsics.checkNotNull((Object)matchGroup6);
                    message = string + " " + string2 + " " + string3 + " " + matchGroup6.getValue();
                } else {
                    notifyUser = false;
                    severity = EmulatorLogListener.Severity.INFO;
                    message = text2;
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    EmulatorProcessHandler.this.log.trace((String)message);
                    break;
                }
                case 2: {
                    EmulatorProcessHandler.this.log.debug((String)message);
                    break;
                }
                case 3: {
                    EmulatorProcessHandler.this.log.info((String)message);
                    break;
                }
                case 4: 
                case 5: {
                    EmulatorProcessHandler.this.log.warn((String)message);
                    break;
                }
                case 6: {
                    EmulatorProcessHandler.this.log.warn((String)message);
                    this.notify("Emulator: " + EmulatorProcessHandler.this.avdName, (String)message, NotificationType.ERROR);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            EmulatorProcessHandler.this.notifyListeners(EmulatorProcessHandler.this.avd, severity, notifyUser, (String)message);
        }

        private final void notify(String title2, String content2, NotificationType notificationType) {
            block0: {
                Notification notification;
                String notificationGroup = EmulatorProcessHandler.this.runType == RunningAvd.RunType.EMBEDDED ? "Running Devices Messages" : "Device Manager Messages";
                NotificationGroup notificationGroup2 = NotificationGroup.Companion.findRegisteredGroup(notificationGroup);
                if (notificationGroup2 == null || (notification = notificationGroup2.createNotification(title2, content2, notificationType)) == null) break block0;
                notification.notify(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EmulatorLogListener.Severity.values().length];
                try {
                    nArray[EmulatorLogListener.Severity.VERBOSE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EmulatorLogListener.Severity.DEBUG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EmulatorLogListener.Severity.INFO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EmulatorLogListener.Severity.WARNING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EmulatorLogListener.Severity.ERROR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EmulatorLogListener.Severity.FATAL.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

